/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.util.ArrayList;
import java.util.Iterator;
import org.esa.beam.dataio.landsat.LandsatConstants;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

public final class LandsatLoc {
    private String path = null;
    private String row = null;
    private String fraction = null;
    private String subscene = null;

    public LandsatLoc(String locationString, int format) {
        if (LandsatLoc.isValideLocationString(locationString, format)) {
            this.parseLocationString(locationString, format);
        }
    }

    public LandsatLoc(String path, String row) {
        this.path = path;
        this.row = row;
    }

    private void parseLocationString(String locationString, int format) {
        if (format == 0) {
            this.setPath(locationString.substring(0, 3));
            this.setRow(locationString.substring(4, 7));
            this.setFraction(locationString.substring(7));
        }
    }

    private static boolean isValideLocationString(String locationString, int format) {
        Guardian.assertNotNullOrEmpty((String)"locationString", (String)locationString);
        String trimmedLocationString = locationString.trim();
        return format == 0 && trimmedLocationString.length() == 9 && trimmedLocationString.charAt(3) == '/';
    }

    private static boolean checkPath(String path) {
        int pathNumber = Integer.parseInt(path);
        return pathNumber > 0 && pathNumber < 234;
    }

    private static boolean checkRow(String row) {
        int rowNumber = Integer.parseInt(row);
        return rowNumber > 0 && rowNumber < 249;
    }

    public final String getFraction() {
        return this.fraction;
    }

    private void setFraction(String _fraction) {
        this.fraction = _fraction;
    }

    public final String getPath() {
        return this.path;
    }

    private void setPath(String _path) {
        if (LandsatLoc.checkPath(_path)) {
            this.path = _path;
        } else {
            Debug.trace((String)"wrong path format");
        }
    }

    public final String getRow() {
        return this.row;
    }

    private void setRow(String _row) {
        if (LandsatLoc.checkRow(_row)) {
            this.row = _row;
        } else {
            Debug.trace((String)"wrong row format");
        }
    }

    public final String getSubscene() {
        return this.subscene;
    }

    public final void setSubscene(String _subscene) {
        this.subscene = _subscene;
    }

    public final String[] locationRecord() {
        ArrayList<String> locRec = new ArrayList<String>();
        String[] locArray = new String[]{this.path, this.row, this.fraction, this.subscene};
        for (int i = 0; i < locArray.length; ++i) {
            if (locArray[i] == null || locArray[i].equals("")) continue;
            locRec.add(locArray[i]);
        }
        String[] tempArray = new String[locRec.size()];
        int i = 0;
        Iterator iter = locRec.iterator();
        while (iter.hasNext()) {
            tempArray[i++] = (String)iter.next();
        }
        return tempArray;
    }

    public final String[] locationRecordDescription() {
        ArrayList<String> locRec = new ArrayList<String>();
        String[] locArray = new String[]{this.path, this.row, this.fraction, this.subscene};
        for (int i = 0; i < locArray.length; ++i) {
            if (locArray[i] == null || locArray[i].equals("")) continue;
            locRec.add(LandsatConstants.LOC_DESC[i]);
        }
        String[] tempArray = new String[locRec.size()];
        int i = 0;
        Iterator iter = locRec.iterator();
        while (iter.hasNext()) {
            tempArray[i++] = (String)iter.next();
        }
        return tempArray;
    }
}

