/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import org.esa.beam.dataio.landsat.GeometricData;
import org.esa.beam.dataio.landsat.LandsatConstants;
import org.esa.beam.dataio.landsat.LandsatHeaderStream;
import org.esa.beam.dataio.landsat.LandsatImageInputStream;
import org.esa.beam.dataio.landsat.LandsatLoc;
import org.esa.beam.dataio.landsat.LandsatTMFile;
import org.esa.beam.dataio.landsat.LandsatUtils;
import org.esa.beam.dataio.landsat.RadiometricData;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.Debug;
import org.esa.beam.util.io.FileUtils;

public final class LandsatHeader {
    private String productID;
    private String formatVersion;
    private final List<LandsatHeaderStream> headerStreamCollection = new Vector<LandsatHeaderStream>();
    private String _productType;
    private String _productSize;
    private String typeOfProcessing;
    private String resampling;
    private String tapeSpanningFlag;
    private long startLine;
    private long linesPerVolume;
    private int _pixelsPerLine;
    private float pixelSize;
    private long recordLength;
    private int imageHeight;
    private int blockingFactor;
    private int[] bandsPresent;
    private int numberOfBands = 0;
    private RadiometricData _radData;
    private GeometricData _geoData;
    private LandsatLoc loc;
    private String rawDate;
    private ProductData.UTC acquisitionDate;
    private String instrumentMode;
    private String instrumentType;
    private double earthSunDistance;
    private final LandsatTMFile _inputFile;

    public LandsatHeader(LandsatTMFile inputFile) {
        this._inputFile = inputFile;
        if (inputFile.getFormat() == 0) {
            this.headerStreamCollection.add(inputFile.getLandsatHeaderStream());
        }
    }

    public final GeometricData getGeoData() {
        return this._geoData;
    }

    public final void setGeoData(GeometricData data) {
        this._geoData = data;
    }

    public final float getPixelSize() {
        return this.pixelSize;
    }

    public final int getImageWidth() {
        return this._pixelsPerLine;
    }

    public final void setImageWidth(int offset, int size, LandsatImageInputStream inputStream) throws IllegalArgumentException, IOException {
        this._pixelsPerLine = Integer.parseInt(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final String getProductID() {
        return this.productID;
    }

    public final void setProductID(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.productID = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
    }

    public final String getProductSize() {
        return this._productSize;
    }

    public final void setProductSize(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this._productSize = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
    }

    public final String getProductType() {
        return this._productType;
    }

    public final void setProductType(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this._productType = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
    }

    public final RadiometricData getRadData() {
        return this._radData;
    }

    public final void setRadData(RadiometricData data) {
        this._radData = data;
    }

    public final long getRecordLength() {
        return this.recordLength;
    }

    public final void setRecordLength(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.recordLength = Long.parseLong(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final String getResampling() {
        return this.resampling;
    }

    public String getRawDate() {
        return this.rawDate;
    }

    public final ProductData.UTC getAcquisitionDate() {
        return this.acquisitionDate;
    }

    public final LandsatLoc getLoc() {
        return this.loc;
    }

    public final void setLoc(int offset, int size, int format, LandsatImageInputStream inputStream) throws IOException {
        this.loc = new LandsatLoc(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size), format);
    }

    public final void setLoc(LandsatLoc loc) {
        this.loc = loc;
    }

    public final String getInstrumentMode() {
        return this.instrumentMode;
    }

    public final void setInstrumentMode(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.instrumentMode = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
    }

    public final void setAcquisitionDate(int offset, int size, LandsatImageInputStream inputStream, String format) throws IOException {
        this.rawDate = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
        this.acquisitionDate = ProductData.UTC.create((Date)LandsatHeader.convertToUTCString(this.rawDate, format), (long)0L);
        this.earthSunDistance = LandsatConstants.EarthSunDistance.getEarthSunDistance(LandsatHeader.getDays(this.acquisitionDate.getAsDate()));
    }

    public final void setAcquisitionDate(ProductData.UTC date) {
        this.acquisitionDate = date;
    }

    public final String getInstrumentType() {
        return this.instrumentType;
    }

    public final void setInstrumentTyp(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.instrumentType = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
    }

    public final void setResampling(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.resampling = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
    }

    public final String getTapeSpanningFlag() {
        return this.tapeSpanningFlag;
    }

    public final void setTapeSpanningFlag(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.tapeSpanningFlag = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
    }

    public final String getTypeOfProcessing() {
        return this.typeOfProcessing;
    }

    public final void setTypeOfProcessing(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.typeOfProcessing = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
    }

    public final int[] getBandsPresent() {
        return this.bandsPresent;
    }

    public final void setBandsPresent(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.bandsPresent = LandsatHeader.parseIncludingBands(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
        this.setNumberOfBands(this.bandsPresent.length);
    }

    public final void setBandsPresent(int[] bands) {
        this.bandsPresent = bands;
    }

    public final int getBlockingFactor() {
        return this.blockingFactor;
    }

    public final void setBlockingFactor(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.blockingFactor = Integer.parseInt(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final String getFormatVersion() {
        return this.formatVersion;
    }

    public final void setFormatVersion(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.formatVersion = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim();
    }

    public final int getImageHeight() {
        return this.imageHeight;
    }

    public final void setImageHeight(int offset, int size, LandsatImageInputStream inputStream) throws IllegalArgumentException, IOException {
        this.imageHeight = Integer.parseInt(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final long getLinesPerVolume() {
        return this.linesPerVolume;
    }

    public final void setLinesPerVolume(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.linesPerVolume = Long.parseLong(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final long getStartLine() {
        return this.startLine;
    }

    public final void setStartLine(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.startLine = Long.parseLong(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final int getNumberOfBands() {
        return this.numberOfBands;
    }

    public final void setNumberOfBands(int numberofBands) {
        this.numberOfBands = numberofBands;
    }

    public final void setPixelSize(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.pixelSize = Float.parseFloat(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    private static int[] parseIncludingBands(String bands) {
        int size = bands.length();
        int[] bandCollection = null;
        if (size <= 7) {
            bandCollection = new int[size];
            for (int i = 0; i < size; ++i) {
                bandCollection[i] = Character.getNumericValue(bands.charAt(i));
            }
        } else {
            Debug.trace((String)"The size of the present band array is wrong");
        }
        return bandCollection;
    }

    private static Date convertToUTCString(String date, String format) {
        try {
            SimpleDateFormat formatInHeaderFile = new SimpleDateFormat(format);
            SimpleDateFormat formatUsedInBeam = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            TimeZone tz = TimeZone.getTimeZone("UTM");
            formatInHeaderFile.setTimeZone(tz);
            formatUsedInBeam.setTimeZone(tz);
            Date dateConversion = formatInHeaderFile.parse(date);
            return dateConversion;
        }
        catch (ParseException e) {
            Debug.trace((Throwable)e);
            return null;
        }
    }

    public final double getEarthSunDistance() {
        return this.earthSunDistance;
    }

    private static int getDays(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("D");
        return Integer.parseInt(formatter.format(date));
    }

    public final LandsatImageInputStream getHeaderInputStreamAt(String fileName) {
        fileName = FileUtils.getFilenameWithoutExtension((String)fileName);
        for (LandsatHeaderStream element : this.headerStreamCollection) {
            if (!element.getHeaderFileName().equalsIgnoreCase(fileName)) continue;
            return element.getInputStream();
        }
        return null;
    }

    public final void addHeaderFile(File file) throws IOException {
        this.headerStreamCollection.add(new LandsatHeaderStream(file));
    }

    public final String getPath() {
        return this._inputFile.getFileLocation();
    }

    public final LandsatImageInputStream getHeaderInputStreamAt(File headerFile) {
        return this.getHeaderInputStreamAt(headerFile.getName());
    }

    public void close() {
        for (int i = 0; i < this.headerStreamCollection.size(); ++i) {
            LandsatHeaderStream landsatHeaderStream = this.headerStreamCollection.get(i);
            landsatHeaderStream.close();
        }
    }
}

