/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

public class LandsatConstants {
    public static final Class[] INPUT_TYPES = new Class[]{String.class, File.class};
    public static final int FAST_L5 = 0;
    public static final int CEOS = 3;
    public static final int ZIPED_UNKNOWN_FORMAT = 1;
    public static final int INVALID_FORMAT = -1;
    public static final String[] LANDSAT_EXTENSIONS = new String[]{".dat", ".zip"};
    public static final String DESCRIPTION = "Landsat 5 TM Product Reader";
    public static final String[] FILE_NAMES = new String[]{"FAST L5", "LANDSAT ZIP"};
    public static final String[] SATELLITE_NAMES = new String[]{"L5"};
    public static final String TM_INSTRUMENT = "TM";
    public static final int LANDSAT_5 = 0;
    public static final int POSITION_OF_SEPERATOR = 3;
    public static final String[] LOC_DESC = new String[]{"Path", "Row", "Fraction", "Subscence"};
    public static final int NOM_FORMER_MIN_RADIANCE = 4;
    public static final int NOM_FORMER_MAX_RADIANCE = 5;
    public static final int NOM_FORMER_GAIN = 6;
    public static final int NOM_NEWER_MIN_RADIANCE = 7;
    public static final int NOM_NEWER_MAX_RADIANCE = 8;
    public static final int NOM_NEWER_GAIN = 9;
    public static final int MIN_RADIANCE = 0;
    public static final int MAX_RADIANCE = 1;
    public static final int GAIN = 2;
    public static final int BIAS = 3;
    public static final String[] RADIANCE_DESCRIPTION_SHORT = new String[]{"MinRad", "MaxRad", "Gain", "Bias", "old NomMinRad", "old NomMaxRad", "old NomGain", "new NomMinRad", "new NomMaxRad", "new NomGain"};
    public static final String[] RADIANCE_DESCRIPTION = new String[]{"minimum radiance value", "maximum radiance value", "gain of the band", "bias of the band", "nominal minimum radiance value before 5 may 2003", "nominal maximal radiance value before 5 may 2003", "nominal gain radiance value before 5 may 2003", "nominal minimum radiance value after 5 may 2003", "nominal maximum radiance value after 5 may 2003", "nominal gain radiance value after 5 may 2003"};
    public static final String DATUM_SHORT = "Datum";
    public static final String DATUM_DESCRIPTION = "Ellipsoid used";
    public static final String SEMI_MAJ_SHORT = "Semi-Major-Axis";
    public static final String SEMI_MAJ_DESCRIPTION = "Semi-Major-Axis of earth ellipsoid";
    public static final String SEMI_MIN_SHORT = "Semi-Minor-Axis";
    public static final String SEMI_MIN_DESCRIPTION = "Semi-Major-Axis of earth ellipsoid";
    public static final String OFFSET_SHORT = "Horizontal offset ";
    public static final String OFFSET_DESCRIPTION = "Horizontal offset of the true";
    public static final String PROJECTION_SHORT = "Projection ";
    public static final String PROJECTION_DESCRIPTION = "Map projection Name";
    public static final String PROJECTION_ID_SHORT = "USG Projection";
    public static final String PROJECTION_ID_DESCRIPTION = "USG projection number";
    public static final String MAP_ZONE_SHORT = "Map zone";
    public static final String MAP_ZONE_DESCRIPTION = "USG map zone number";
    public static final String SUN_ELEV_SHORT = "Sun elevation";
    public static final String SUN_ELEV_DESCRIPTION = "Sun elevation angle at scene center";
    public static final String SUN_AZIMUTH_SHORT = "Sun azimuth";
    public static final String SUN_AZIMUTH_DESCRIPTION = "Sun azimuth at scene center";
    public static final String PARAMETER_SHORT = ". USG Projections parameter";
    public static final String PARAMETER_DESCRIPTION = "The USG projections parameters in standard USGS order. The meaning of these values depends on the projection used";
    public static final String PRODUCT_ID = "Product";
    public static final String PRODUCT_ID_DESCRIPTION = "Product ordernummer yydddnnn-cc";
    public static final String ACQUISITION_DATE = "Aquisition date";
    public static final String INSTRUMENT_MODE = "Instrument mode";
    public static final String INSTRUMENT_MODE_DESCRIPTION = "mode number";
    public static final String PRODUCT_TYPE = "Type of product";
    public static final String INSTRUMENT = "Instrument";
    public static final String PRODUCT_SIZE = "Product Size";
    public static final String RESAMPLING = "Resampling";
    public static final String TAPE_SPANNING = "Tape Spanning";
    public static final String TAPE_SPANNING_DESCRIPTION = "Tape volume number of volumes in tape set in 'n/m' format";
    public static final String START_LINE = "Startline";
    public static final String START_LINE_DESCRIPTION = "First image line number on this volume";
    public static final String LINES_PER_VOL = "Lines per Volumes";
    public static final String LINES_PER_VOL_DESCRIPTION = "Number of image lines on this volume ";
    public static final String ORIENTATION = "orientation angle";
    public static final String PIXEL_SIZE = "Pixel size";
    public static final String PIXEL_PER_LINES = "Number of pixels";
    public static final String PIXEL_PER_LINES_DESCRIPTION = "Number of pixels per image line";
    public static final String LINES_PER_IMAGE = "Number of lines";
    public static final String LINES_PER_IMAGE_DESCRIPTION = "Number of lines in the output image";
    public static final String BANDS_PRESENT = "Bands";
    public static final String BANDS_PRESENT_DESCRIPTION = "Bands present on the volume";
    public static final String BLOCKING_FACTOR = "Blocking factor";
    public static final String BLOCKING_FACTOR_DESCRIPTION = "Tape blocking factor";
    public static final String RECORD_LENGTH = "Record length";
    public static final String RECORD_LENGTH_DESCRIPTION = "Length of physical tape record";
    public static final String VERSION = "Version";
    public static final String VERSION_DESCRIPTION = "Format version code(A-Z)";
    public static final int CONVERT_MINUTE_DEGREE = 60;
    public static final int CONVERT_SECOND_DEGREE = 3600;
    public static final double NULL_DATA_VALUE = 0.0;
    public static final int FAST_FORMAT_HEADER_SIZE = 1536;

    public static final class Unit {
        private final String unit;
        public static final Unit RADIANCE = new Unit("mW/(cm^2*sr*nm)");
        public static final Unit ANGLE = new Unit("deg.");
        public static final Unit METER = new Unit("m");
        public static final Unit PIXEL = new Unit("pixel");
        public static final Unit REFLECTANCE = new Unit("1000*Reflectance");
        public static final Unit KELVIN = new Unit("Kelvin");

        private Unit(String unit) {
            this.unit = unit;
        }

        public String toString() {
            return this.unit;
        }
    }

    public static final class geoPointsAttributes {
        private final String id;
        public static final geoPointsAttributes LONGITUDE = new geoPointsAttributes("longitude");
        public static final geoPointsAttributes LATITUDE = new geoPointsAttributes("latitude");
        public static final geoPointsAttributes EASTING = new geoPointsAttributes("easting");
        public static final geoPointsAttributes NORTHING = new geoPointsAttributes("northing");
        public static final geoPointsAttributes CENTER_LINE = new geoPointsAttributes("center line");
        public static final geoPointsAttributes CENTER_PIXEL = new geoPointsAttributes("center pixel");

        private geoPointsAttributes(String anId) {
            this.id = anId;
        }

        public String toString() {
            return this.id;
        }
    }

    public static final class EarthSunDistance {
        private final int julianDay;
        private final double distance;
        private static final String UNIT = "Astronomical";
        private static final List<EarthSunDistance> distanceCollection = new Vector<EarthSunDistance>();

        private EarthSunDistance(int julianDay, double distance) {
            this.julianDay = julianDay;
            this.distance = distance;
        }

        public static String getUnit() {
            return UNIT;
        }

        public static double getEarthSunDistance(int julianDay) {
            Guardian.assertGreaterThan((String)"julianDay <= 0", (long)julianDay, (long)0L);
            Guardian.assertTrue((String)"julianDay < 367", (julianDay < 367 ? 1 : 0) != 0);
            EarthSunDistance firstElement = distanceCollection.get(0);
            double distance = firstElement.getDistance();
            for (EarthSunDistance element : distanceCollection) {
                if (element.getJulianDay() > julianDay) {
                    return distance;
                }
                distance = element.getDistance();
            }
            EarthSunDistance lastElement = distanceCollection.get(distanceCollection.size() - 1);
            return lastElement.getDistance();
        }

        private int getJulianDay() {
            return this.julianDay;
        }

        private double getDistance() {
            return this.distance;
        }

        static {
            distanceCollection.add(new EarthSunDistance(15, 0.9836));
            distanceCollection.add(new EarthSunDistance(32, 0.9853));
            distanceCollection.add(new EarthSunDistance(46, 0.9878));
            distanceCollection.add(new EarthSunDistance(60, 0.9909));
            distanceCollection.add(new EarthSunDistance(74, 0.9945));
            distanceCollection.add(new EarthSunDistance(91, 0.9993));
            distanceCollection.add(new EarthSunDistance(106, 1.0033));
            distanceCollection.add(new EarthSunDistance(121, 1.0076));
            distanceCollection.add(new EarthSunDistance(135, 1.0109));
            distanceCollection.add(new EarthSunDistance(152, 1.014));
            distanceCollection.add(new EarthSunDistance(166, 1.0158));
            distanceCollection.add(new EarthSunDistance(182, 1.0167));
            distanceCollection.add(new EarthSunDistance(196, 1.0165));
            distanceCollection.add(new EarthSunDistance(213, 1.0149));
            distanceCollection.add(new EarthSunDistance(227, 1.0128));
            distanceCollection.add(new EarthSunDistance(242, 1.0092));
            distanceCollection.add(new EarthSunDistance(258, 1.0057));
            distanceCollection.add(new EarthSunDistance(274, 1.0011));
            distanceCollection.add(new EarthSunDistance(288, 0.9972));
            distanceCollection.add(new EarthSunDistance(305, 0.9925));
            distanceCollection.add(new EarthSunDistance(319, 0.9892));
            distanceCollection.add(new EarthSunDistance(335, 0.986));
            distanceCollection.add(new EarthSunDistance(349, 0.9843));
            distanceCollection.add(new EarthSunDistance(365, 0.9833));
        }
    }

    public static final class Points {
        private final String id;
        public static final Points UPPER_LEFT = new Points("Upper left");
        public static final Points LOWER_RIGHT = new Points("Lower right");
        public static final Points UPPER_RIGHT = new Points("Upper right");
        public static final Points LOWER_LEFT = new Points("Lower left");
        public static final Points CENTER = new Points("Center");

        private Points(String anId) {
            this.id = anId;
        }

        public String toString() {
            return this.id;
        }
    }

    public static final class Thermal {
        private final double constant;
        private final String unit;
        private final String description;
        public static final Thermal K2 = new Thermal(1260.56, "Kelvin", "calibration constant");
        public static final Thermal K1 = new Thermal(607.76, "W/(m*m*sr*microm)", "calibration constant");

        private Thermal(double constant, String unit, String description) {
            this.unit = unit;
            this.constant = constant;
            this.description = description;
        }

        public double getConstant() {
            return this.constant;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUnit() {
            return this.unit;
        }
    }

    public static final class NomRadiance {
        public static final int AFTER_5_MAY_2003 = 0;
        public static final int BEFORE_5_MAY_2003 = 1;
        private final double lmin;
        private final double lmax;
        private double _gain;
        private final int _bandNumber;
        private static final List<NomRadiance> after2003Radiances = new Vector<NomRadiance>();
        private static final List<NomRadiance> before2003Radiances;

        private NomRadiance(int index, double lmin, double lmax, double gain) {
            this.lmin = lmin;
            this.lmax = lmax;
            this._gain = gain;
            this._bandNumber = index;
        }

        public static List<NomRadiance> getAfter2003Radiances() {
            return after2003Radiances;
        }

        public double getGain() {
            return this._gain;
        }

        public int getBandNumber() {
            return this._bandNumber;
        }

        public double getLmax() {
            return this.lmax;
        }

        public double getLmin() {
            return this.lmin;
        }

        public static NomRadiance getConstantRadAt(int index, int date) {
            Guardian.assertTrue((String)"date == AFTER_5_MAY_2003 || date == BEFORE_5_MAY_2003", (date == 0 || date == 1 ? 1 : 0) != 0);
            List<NomRadiance> radianceConstants = date == 0 ? after2003Radiances : before2003Radiances;
            for (NomRadiance element : radianceConstants) {
                if (index != element.getBandNumber()) continue;
                return element;
            }
            Debug.trace((String)("no Radiance data found at index: " + index));
            return null;
        }

        static {
            after2003Radiances.add(new NomRadiance(1, -1.5, 193.0, 0.762824));
            after2003Radiances.add(new NomRadiance(2, -2.84, 365.0, 1.44251));
            after2003Radiances.add(new NomRadiance(3, -1.17, 264.0, 1.03988));
            after2003Radiances.add(new NomRadiance(4, -1.51, 221.0, 0.87251));
            after2003Radiances.add(new NomRadiance(5, -0.37, 30.2, 0.119882));
            after2003Radiances.add(new NomRadiance(6, 1.2378, 15.303, 0.055158));
            after2003Radiances.add(new NomRadiance(7, -0.15, 16.5, 0.065294));
            before2003Radiances = new Vector<NomRadiance>();
            before2003Radiances.add(new NomRadiance(1, -1.5, 152.1, 0.602431));
            before2003Radiances.add(new NomRadiance(2, -2.84, 296.81, 1.1751));
            before2003Radiances.add(new NomRadiance(3, -1.17, 204.3, 0.805765));
            before2003Radiances.add(new NomRadiance(4, -1.51, 206.2, 0.814549));
            before2003Radiances.add(new NomRadiance(5, -0.37, 27.19, 0.108078));
            before2003Radiances.add(new NomRadiance(6, 1.2378, 15.303, 0.055158));
            before2003Radiances.add(new NomRadiance(7, -0.15, 14.38, 0.05698));
        }
    }

    public static final class ConstBand {
        private final String bandName;
        private final int bandIndex;
        private final float wavelength;
        private final float bandwidth;
        private final int resolution;
        private final String description;
        private final float solarFluxValue;
        private static final List<ConstBand> allBands = new Vector<ConstBand>();

        private ConstBand(String bandName, int index, float wavelength, float bandwidth, int resolution, String description, float solarFlux) {
            this.bandName = bandName;
            this.bandIndex = index;
            this.wavelength = wavelength;
            this.bandwidth = bandwidth;
            this.resolution = resolution;
            this.description = description;
            this.solarFluxValue = solarFlux;
        }

        public String toString() {
            return this.bandName;
        }

        public static ConstBand getConstBand(Band band) {
            for (ConstBand element : allBands) {
                if (band.getSpectralBandIndex() != element.getBandIndex()) continue;
                return element;
            }
            return null;
        }

        public float getBandwidth() {
            return this.bandwidth;
        }

        public String getDescription() {
            return this.description;
        }

        public int getResolution() {
            return this.resolution;
        }

        public float getWavelength() {
            return this.wavelength;
        }

        public int getBandIndex() {
            return this.bandIndex;
        }

        public float getSolarFlux() {
            return this.solarFluxValue;
        }

        public static ConstBand getConstantBandAt(int index) {
            for (ConstBand element : allBands) {
                if (index != element.getBandIndex()) continue;
                return element;
            }
            Debug.trace((String)("no band found at index: " + index));
            return null;
        }

        static {
            allBands.add(new ConstBand("Band1", 1, 490.0f, 66.0f, 30, "Blue", 1957.0f));
            allBands.add(new ConstBand("Band2", 2, 560.0f, 82.0f, 30, "Green", 1826.0f));
            allBands.add(new ConstBand("Band3", 3, 660.0f, 67.0f, 30, "Red", 1554.0f));
            allBands.add(new ConstBand("Band4", 4, 830.0f, 128.0f, 30, "NearIR", 1036.0f));
            allBands.add(new ConstBand("Band5", 5, 1670.0f, 217.0f, 30, "MidIR", 215.0f));
            allBands.add(new ConstBand("Band6", 6, 11500.0f, 1000.0f, 120, "ThermalIR", 0.0f));
            allBands.add(new ConstBand("Band7", 7, 2240.0f, 252.0f, 30, "MidIR", 80.67f));
        }
    }
}

