/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.beam.dataio.landsat.GeoPoint;
import org.esa.beam.dataio.landsat.LandsatConstants;
import org.esa.beam.dataio.landsat.LandsatImageInputStream;
import org.esa.beam.dataio.landsat.LandsatUtils;
import org.esa.beam.util.Guardian;

public final class GeometricData {
    private String mapProjection;
    private String ellipsoid;
    private double semiMajorAxis;
    private double semiMinorAxis;
    private int mapZoneNumber;
    private int projectionNumber;
    private double[] projectionParameter;
    private List<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
    private int horizontalOffset;
    private float sunElevationAngles;
    private float sunAzimuthAngles;
    private float lookAngle;

    public final List getImagePoints() {
        return this.geoPoints;
    }

    public final void addGeoPoint(GeoPoint geoPoint) {
        Guardian.assertNotNull((String)"geoPoints", this.geoPoints);
        if (!this.geoPoints.contains(geoPoint)) {
            this.geoPoints.add(geoPoint);
        }
    }

    public final String getEllipsoid() {
        return this.ellipsoid;
    }

    public final void setEllipsoid(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.ellipsoid = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim();
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public final void setHorizontalOffset(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.horizontalOffset = Integer.parseInt(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final String getMapProjection() {
        return this.mapProjection;
    }

    public final void setMapProjection(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.mapProjection = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim();
    }

    public final int getMapZoneNumber() {
        return this.mapZoneNumber;
    }

    public final void setMapZoneNumber(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.mapZoneNumber = Integer.parseInt(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final float getLookAngle() {
        return this.lookAngle;
    }

    public final void setLookAngle(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.lookAngle = Float.parseFloat(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public final void setSemiMajorAxis(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.semiMajorAxis = Double.parseDouble(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public final void setSemiMinorAxis(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.semiMinorAxis = Double.parseDouble(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final float getSunAzimuthAngle() {
        return this.sunAzimuthAngles;
    }

    public final void setSunAzimuthAngles(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.sunAzimuthAngles = Float.parseFloat(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final double[] getProjectionParameter() {
        return this.projectionParameter;
    }

    public final void setProjectionParameter(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.projectionParameter = GeometricData.parseProjectionParameter(offset, size, inputStream);
    }

    public final float getSunElevationAngle() {
        return this.sunElevationAngles;
    }

    public final int getProjectionNumber() {
        return this.projectionNumber;
    }

    public final void setProjectionNumber(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.projectionNumber = Integer.parseInt(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final void setSunElevationAngles(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.sunElevationAngles = Float.parseFloat(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final GeoPoint getGeoPointAt(LandsatConstants.Points geoPointID) {
        for (GeoPoint geoPoint : this.geoPoints) {
            if (geoPoint.getGeoPointID() != geoPointID) continue;
            return geoPoint;
        }
        throw new IllegalArgumentException("invalid geoPointID");
    }

    private static double[] parseProjectionParameter(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        ArrayList<Double> parameterList = new ArrayList<Double>();
        StringTokenizer token = new StringTokenizer(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size));
        while (token.hasMoreElements()) {
            double checkValue = Double.parseDouble(token.nextToken().substring(0, 16));
            if (checkValue == 0.0) continue;
            parameterList.add(new Double(checkValue));
        }
        double[] parameter = new double[parameterList.size()];
        for (int i = 0; i < parameterList.size(); ++i) {
            Double projpara = (Double)parameterList.get(i);
            parameter[i] = projpara;
        }
        return parameter;
    }
}

