/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.io.IOException;
import java.util.regex.Pattern;
import org.esa.beam.dataio.landsat.LandsatConstants;
import org.esa.beam.dataio.landsat.LandsatImageInputStream;
import org.esa.beam.dataio.landsat.LandsatUtils;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.util.Guardian;

public class GeoPoint {
    private final LandsatConstants.Points geoPointID;
    private String geodicLongitude;
    private String geodicLatitude;
    private double easting;
    private double northing;
    private boolean northernHemisphere;
    private int locationY;
    private int locationX;

    public GeoPoint(LandsatConstants.Points point) {
        this.geoPointID = point;
        this.locationX = -1;
        this.locationY = -1;
    }

    public final double getEasting() {
        return this.easting;
    }

    public final void setEasting(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.easting = Float.parseFloat(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size));
    }

    public final String getGeodicLatitude() {
        return GeoPos.getLatString((float)GeoPoint.latlon2Decimal(this.geodicLatitude));
    }

    public final void setGeodicLatitude(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.geodicLatitude = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
        this.setHemisphere(this.geodicLatitude);
    }

    public final String getGeodicLongitude() {
        return GeoPos.getLonString((float)GeoPoint.latlon2Decimal(this.geodicLongitude));
    }

    public final void setGeodicLongitude(int offset, int size, LandsatImageInputStream inputStream) throws IOException {
        this.geodicLongitude = LandsatUtils.getValueFromLandsatFile(inputStream, offset, size);
    }

    public final double getNorthing() {
        return this.northing;
    }

    public final void setNorthing(int offset, int size, LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        this.northing = Float.parseFloat(LandsatUtils.getValueFromLandsatFile(inputStream, offset, size).trim());
    }

    public final LandsatConstants.Points getGeoPointID() {
        return this.geoPointID;
    }

    private void setHemisphere(String longlat) {
        this.northernHemisphere = longlat.contains("N") || longlat.contains("n");
    }

    public final String toString() {
        return this.geoPointID.toString();
    }

    public final boolean isNorthernHemisphere() {
        return this.northernHemisphere;
    }

    private static float latlon2Decimal(String latlon) {
        Guardian.assertNotNullOrEmpty((String)"latlon", (String)latlon);
        int signFaktor = 1;
        if (GeoPoint.isSouth(latlon) || GeoPoint.isWest(latlon)) {
            signFaktor = -1;
        }
        double latlonValue = 0.0;
        Pattern p = Pattern.compile("[wWnNsSEe]");
        String[] data = p.split(latlon);
        if (data.length == 1) {
            latlonValue = Double.parseDouble(data[0]);
        }
        int dd = (int)(latlonValue / 10000.0);
        int mm = (int)((latlonValue - (double)(dd * 10000)) / 100.0);
        double ssffff = latlonValue - (double)(dd * 10000 + mm * 100);
        return (float)signFaktor * ((float)dd + (float)mm / 60.0f + (float)ssffff / 3600.0f);
    }

    private static boolean isWest(String latlon) {
        return latlon.contains("W") || latlon.contains("w");
    }

    private static boolean isSouth(String latlon) {
        return latlon.contains("S") || latlon.contains("s");
    }

    public void sePixelY(int y) {
        this.locationY = y;
    }

    public int getPixelY() {
        return this.locationY;
    }

    public void setPixelX(int x) {
        this.locationX = x;
    }

    public int getPixelX() {
        return this.locationX;
    }
}

