/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.about;

import com.bc.ceres.core.runtime.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.esa.snap.rcp.util.BrowserUtils;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;

public class S3tbxAboutBox
extends JPanel {
    private static final String releaseNotesUrlString = "https://senbox.atlassian.net/issues/?filter=-4&jql=project%20%3D%20SIIITBX%20AND%20fixVersion%20%3D%20";

    public S3tbxAboutBox() {
        super(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        ImageIcon aboutImage = new ImageIcon(S3tbxAboutBox.class.getResource("about_s3tbx.jpg"));
        JLabel iconLabel = new JLabel(aboutImage);
        this.add((Component)iconLabel, "Center");
        this.add((Component)this.createVersionPanel(), "South");
    }

    private JPanel createVersionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        ModuleInfo moduleInfo = Modules.getDefault().ownerOf(S3tbxAboutBox.class);
        panel.add(new JLabel("<html><b>Sentinel-3 Toolbox (S3TBX) version " + moduleInfo.getImplementationVersion() + "</b>", 4));
        Version specVersion = Version.parseVersion((String)moduleInfo.getSpecificationVersion().toString());
        String versionString = String.format("%s.%s.%s", specVersion.getMajor(), specVersion.getMinor(), specVersion.getMicro());
        String changelogUrl = releaseNotesUrlString + versionString;
        JLabel releaseNoteLabel = new JLabel("<html><a href=\"" + changelogUrl + "\">Release Notes</a>", 4);
        releaseNoteLabel.setCursor(new Cursor(12));
        releaseNoteLabel.addMouseListener((MouseListener)new BrowserUtils.URLClickAdaptor(changelogUrl));
        panel.add(releaseNoteLabel);
        return panel;
    }
}

