/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.ui;

import java.util.ArrayList;
import org.esa.s3tbx.insitu.ui.InsituClientModel;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MinMaxGeoCoordinatesTest {
    @Test
    public void testCreate_NoProduct() throws Exception {
        ArrayList products = new ArrayList();
        InsituClientModel.MinMaxGeoCoordinates coordinates = InsituClientModel.MinMaxGeoCoordinates.create(products);
        Assert.assertEquals((double)90.0, (double)coordinates.getMaxLat(), (double)1.0E-6);
        Assert.assertEquals((double)-90.0, (double)coordinates.getMinLat(), (double)1.0E-6);
        Assert.assertEquals((double)180.0, (double)coordinates.getMaxLon(), (double)1.0E-6);
        Assert.assertEquals((double)-180.0, (double)coordinates.getMinLon(), (double)1.0E-6);
    }

    @Test
    public void testCreate_OneProduct() throws Exception {
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(this.createProduct(1, -180, 90));
        InsituClientModel.MinMaxGeoCoordinates coordinates = InsituClientModel.MinMaxGeoCoordinates.create(products);
        Assert.assertEquals((double)90.0, (double)coordinates.getMaxLat(), (double)1.0E-6);
        Assert.assertEquals((double)81.0, (double)coordinates.getMinLat(), (double)1.0E-6);
        Assert.assertEquals((double)-171.0, (double)coordinates.getMaxLon(), (double)1.0E-6);
        Assert.assertEquals((double)-180.0, (double)coordinates.getMinLon(), (double)1.0E-6);
    }

    @Test
    public void testCreate_MultipleProduct() throws Exception {
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(this.createProduct(1, -5, 80));
        products.add(this.createProduct(2, 165, 5));
        products.add(this.createProduct(3, -5, -70));
        products.add(this.createProduct(4, -175, 5));
        InsituClientModel.MinMaxGeoCoordinates coordinates = InsituClientModel.MinMaxGeoCoordinates.create(products);
        Assert.assertEquals((double)80.0, (double)coordinates.getMaxLat(), (double)1.0E-6);
        Assert.assertEquals((double)-79.0, (double)coordinates.getMinLat(), (double)1.0E-6);
        Assert.assertEquals((double)174.0, (double)coordinates.getMaxLon(), (double)1.0E-6);
        Assert.assertEquals((double)-175.0, (double)coordinates.getMinLon(), (double)1.0E-6);
    }

    private Product createProduct(int index, int easting, int northing) throws Exception {
        int width = 10;
        int height = 10;
        Product product = new Product("p" + index, "t", width, height);
        CrsGeoCoding gc = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, width, height, (double)easting, (double)northing, 1.0, 1.0, 0.5, 0.5);
        product.setSceneGeoCoding((GeoCoding)gc);
        return product;
    }
}

