/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.server;

import java.util.Set;
import org.esa.s3tbx.insitu.TestInsituServer;
import org.esa.s3tbx.insitu.server.InsituServerRegistry;
import org.esa.s3tbx.insitu.server.InsituServerSpi;
import org.junit.Assert;
import org.junit.Test;

public class InsituServerRegistryTest {
    @Test
    public void testCreation() {
        InsituServerRegistry registry = InsituServerRegistry.getInstance();
        Set registeredServers = registry.getAllRegisteredServers();
        Assert.assertTrue((registeredServers.size() >= 1 ? 1 : 0) != 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddingServerToReturnedList() {
        InsituServerRegistry registry = InsituServerRegistry.getInstance();
        Set registeredServers = registry.getAllRegisteredServers();
        registeredServers.add(new TestInsituServer.Spi());
    }

    @Test
    public void testAddingAndRemovingServer() {
        InsituServerRegistry registry = InsituServerRegistry.getInstance();
        TestInsituServer.Spi serverSpi = new TestInsituServer.Spi();
        int serverCount = registry.getAllRegisteredServers().size();
        registry.addServer((InsituServerSpi)serverSpi);
        Assert.assertEquals((long)(serverCount + 1), (long)registry.getAllRegisteredServers().size());
        registry.removeServer(serverSpi.getName());
        Assert.assertEquals((long)serverCount, (long)registry.getAllRegisteredServers().size());
        registry.addServer((InsituServerSpi)serverSpi);
        Assert.assertEquals((long)(serverCount + 1), (long)registry.getAllRegisteredServers().size());
        registry.removeServer((InsituServerSpi)serverSpi);
        Assert.assertEquals((long)serverCount, (long)registry.getAllRegisteredServers().size());
    }
}

