/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.ui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.esa.s3tbx.insitu.ui.InsituClientModel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Test;

public class TimeSpanTest {
    @Test
    public void testCreate_NoProduct() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        ArrayList products = new ArrayList();
        InsituClientModel.TimeSpan timeSpan = InsituClientModel.TimeSpan.create(products);
        Calendar utcCalendar = InsituClientModel.createUtcCalendar();
        Date expectedStopDate = utcCalendar.getTime();
        Assert.assertEquals((Object)ProductData.UTC.parse((String)"01-JAN-1970 12:00:00").getAsDate(), (Object)timeSpan.getStartDate());
        Assert.assertEquals((Object)expectedStopDate, (Object)timeSpan.getStopDate());
    }

    @Test
    public void testCreate_OneProduct() throws Exception {
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(this.createProduct(1, ProductData.UTC.parse((String)"16-MAR-2007 12:35:14"), ProductData.UTC.parse((String)"16-MAR-2007 12:55:14")));
        InsituClientModel.TimeSpan timeSpan = InsituClientModel.TimeSpan.create(products);
        Assert.assertEquals((Object)ProductData.UTC.parse((String)"16-MAR-2007 12:35:14").getAsDate(), (Object)timeSpan.getStartDate());
        Assert.assertEquals((Object)ProductData.UTC.parse((String)"16-MAR-2007 12:55:14").getAsDate(), (Object)timeSpan.getStopDate());
    }

    private Product createProduct(int index, ProductData.UTC startTime, ProductData.UTC endTime) throws Exception {
        Product product = new Product("p" + index, "t", 10, 10);
        product.setStartTime(startTime);
        product.setEndTime(endTime);
        return product;
    }
}

