/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.server.mermaid;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.esa.s3tbx.insitu.server.InsituQuery;
import org.esa.s3tbx.insitu.server.InsituResponse;
import org.esa.s3tbx.insitu.server.InsituServer;
import org.esa.s3tbx.insitu.server.InsituServerRegistry;
import org.esa.s3tbx.insitu.server.InsituServerSpi;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Should not run with automatic tests")
public class MermaidServerTest {
    private InsituServer server = null;
    private SimpleDateFormat dateFormat;

    @Before
    public void setUp() throws Exception {
        InsituServerRegistry registry = InsituServerRegistry.getInstance();
        InsituServerSpi serverSpi = registry.getRegisteredServer("MERMAID");
        this.server = serverSpi.createServer();
        this.dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Test
    public void testMermaidServer_Observations() throws Exception {
        InsituQuery query = new InsituQuery().lonMin(Double.valueOf(20.5)).lonMax(Double.valueOf(80.9)).latMin(Double.valueOf(3.2)).latMax(Double.valueOf(9.7));
        query.startDate(this.dateFormat.parse("01-SEP-2003 15:20:11"));
        query.stopDate(this.dateFormat.parse("23-SEP-2003 10:15:36"));
        query.param(new String[]{"es_412", "es_443"});
        query.subject(InsituQuery.SUBJECT.OBSERVATIONS);
        InsituResponse response = this.server.query(query);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertEquals((long)12L, (long)response.getObservationCount());
        Assert.assertEquals((long)1L, (long)response.getDatasets().size());
    }

    @Test
    public void testMermaidServer_Observations_WithCamapigns() throws Exception {
        InsituQuery query = new InsituQuery().datasets(new String[]{"AERONET"});
        query.param(new String[]{"es_412", "es_443"});
        query.subject(InsituQuery.SUBJECT.OBSERVATIONS);
        InsituResponse response = this.server.query(query);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertEquals((long)200L, (long)response.getObservationCount());
        Assert.assertEquals((long)1L, (long)response.getDatasets().size());
        query = new InsituQuery().datasets(new String[]{"BOUSSOLE"});
        query.param(new String[]{"es_412", "es_443"});
        query.subject(InsituQuery.SUBJECT.OBSERVATIONS);
        response = this.server.query(query);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertEquals((long)188L, (long)response.getObservationCount());
        Assert.assertEquals((long)1L, (long)response.getDatasets().size());
        query = new InsituQuery().datasets(new String[]{"BOUSSOLE", "AERONET"});
        query.param(new String[]{"es_412", "es_443"});
        query.subject(InsituQuery.SUBJECT.OBSERVATIONS);
        response = this.server.query(query);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertEquals((long)388L, (long)response.getObservationCount());
        Assert.assertEquals((long)2L, (long)response.getDatasets().size());
    }

    @Test
    public void testMermaidServer_Campaigns() throws Exception {
        InsituQuery query = new InsituQuery().subject(InsituQuery.SUBJECT.DATASETS);
        InsituResponse response = this.server.query(query);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertEquals((long)2L, (long)response.getDatasets().size());
    }

    @Test
    public void testMermaidServer_Parameters() throws Exception {
        InsituQuery query = new InsituQuery().subject(InsituQuery.SUBJECT.PARAMETERS);
        InsituResponse response = this.server.query(query);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertEquals((long)30L, (long)response.getParameters().size());
    }

    @Test
    public void testMermaidServer_Parameters_withCampaigns() throws Exception {
        InsituQuery query = new InsituQuery().subject(InsituQuery.SUBJECT.PARAMETERS);
        query.datasets(new String[]{"BOUSSOLE"});
        InsituResponse response = this.server.query(query);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertEquals((long)23L, (long)response.getParameters().size());
        query = new InsituQuery().subject(InsituQuery.SUBJECT.PARAMETERS);
        query.datasets(new String[]{"AERONET"});
        response = this.server.query(query);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertEquals((long)17L, (long)response.getParameters().size());
        query = new InsituQuery().subject(InsituQuery.SUBJECT.PARAMETERS);
        query.datasets(new String[]{"BOUSSOLE", "AERONET"});
        response = this.server.query(query);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertEquals((long)30L, (long)response.getParameters().size());
    }
}

