/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.server.mermaid;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.esa.s3tbx.insitu.server.InsituQuery;
import org.esa.s3tbx.insitu.server.mermaid.MermaidQueryFormatter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MermaidQueryFormatterTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @Test
    public void testQueryCreation() throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        InsituQuery query = new InsituQuery();
        query.subject(InsituQuery.SUBJECT.PARAMETERS);
        query.datasets(new String[]{"Muscheln", "Robben"});
        query.latMin(Double.valueOf(-10.943));
        query.latMax(Double.valueOf(46.12));
        query.lonMin(Double.valueOf(5.0));
        query.lonMax(Double.valueOf(15.36));
        query.startDate(dateFormat.parse("01-Jan-2014 00:00:00"));
        query.stopDate(dateFormat.parse("31-Dec-2015 00:00:00"));
        query.param(new String[]{"param1", "param2", "param3"});
        query.limit(10);
        query.shift(5);
        query.countOnly(true);
        String queryString = MermaidQueryFormatter.format((InsituQuery)query);
        Assert.assertTrue((boolean)queryString.startsWith("/parameters?"));
        Assert.assertTrue((boolean)queryString.contains("campaign=Muscheln,Robben"));
        Assert.assertTrue((boolean)queryString.contains("lat_min=-10.943"));
        Assert.assertTrue((boolean)queryString.contains("lon_min=5.0"));
        Assert.assertTrue((boolean)queryString.contains("lat_max=46.12"));
        Assert.assertTrue((boolean)queryString.contains("lon_max=15.36"));
        Assert.assertTrue((boolean)queryString.contains("start_date=2014-01-01+00%3A00%3A00"));
        Assert.assertTrue((boolean)queryString.contains("stop_date=2015-12-31+00%3A00%3A00"));
        Assert.assertTrue((boolean)queryString.contains("param=param1,param2,param3"));
        Assert.assertTrue((boolean)queryString.contains("limit=10"));
        Assert.assertTrue((boolean)queryString.contains("shift=5"));
        Assert.assertTrue((boolean)queryString.contains("count_only"));
        Assert.assertEquals((long)10L, (long)queryString.chars().filter(value -> value == 38).count());
        int lastIndex = queryString.length() - 1;
        Assert.assertTrue((queryString.charAt(lastIndex) != '&' ? 1 : 0) != 0);
    }
}

