/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.server.mermaid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.esa.s3tbx.insitu.server.InsituObservation;
import org.esa.s3tbx.insitu.server.InsituResponse;
import org.esa.s3tbx.insitu.server.mermaid.Campaign;
import org.esa.s3tbx.insitu.server.mermaid.MermaidParameter;
import org.esa.s3tbx.insitu.server.mermaid.MermaidResponse;
import org.esa.s3tbx.insitu.server.mermaid.UtcDateTypeAdapter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JsonDeserializationTest {
    private Gson gson;
    private static Locale defaultLocale;

    @BeforeClass
    public static void setUpClass() {
        defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
    }

    @AfterClass
    public static void tearDown() {
        Locale.setDefault(defaultLocale);
    }

    @Before
    public void setUp() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new UtcDateTypeAdapter());
        this.gson = gsonBuilder.create();
    }

    @Test
    public void testParseCampaignsResponse() {
        InputStream jsonStream = JsonDeserializationTest.class.getResourceAsStream("CampaignsResponse.json");
        MermaidResponse response = (MermaidResponse)this.gson.fromJson((Reader)new InputStreamReader(jsonStream), MermaidResponse.class);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertNull((Object)response.getFailureReasons());
        List campaigns = response.getDatasets();
        Assert.assertNotNull((Object)campaigns);
        Assert.assertEquals((long)2L, (long)campaigns.size());
        Campaign aeronetDescr = (Campaign)campaigns.get(0);
        Assert.assertEquals((Object)"AERONET", (Object)aeronetDescr.getName());
        Assert.assertEquals((Object)"Giuseppe Zibordi", (Object)aeronetDescr.getPi());
        Assert.assertNull((Object)aeronetDescr.getWebsite());
        Assert.assertEquals((Object)"giuseppe.zibordi@jrc.it", (Object)aeronetDescr.getContact());
        Assert.assertTrue((boolean)aeronetDescr.getPolicy().startsWith("The AAOT AERONET-OC insitu dataset"));
        Assert.assertTrue((boolean)aeronetDescr.getDescription().startsWith("The network AERONET - Ocean Color"));
        Campaign boussoleDescr = (Campaign)campaigns.get(1);
        Assert.assertEquals((Object)"BOUSSOLE", (Object)boussoleDescr.getName());
        Assert.assertEquals((Object)"David Antoine", (Object)boussoleDescr.getPi());
        Assert.assertEquals((Object)"http://www.obs-vlfr.fr/Boussole/", (Object)boussoleDescr.getWebsite());
        Assert.assertEquals((Object)"antoine@obs-vlfr.fr", (Object)boussoleDescr.getContact());
        Assert.assertTrue((boolean)boussoleDescr.getPolicy().startsWith("The BOUSSOLE insitu dataset"));
        Assert.assertTrue((boolean)boussoleDescr.getDescription().startsWith("The BOUSSOLE project provides"));
    }

    @Test
    public void testParseParametersResponse() {
        InputStream jsonStream = JsonDeserializationTest.class.getResourceAsStream("ParametersResponse.json");
        MermaidResponse response = (MermaidResponse)this.gson.fromJson((Reader)new InputStreamReader(jsonStream), MermaidResponse.class);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertNull((Object)response.getFailureReasons());
        List parameters = response.getParameters();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((long)23L, (long)parameters.size());
        MermaidParameter parameter = (MermaidParameter)parameters.get(4);
        Assert.assertEquals((Object)"es_510", (Object)parameter.getName());
        Assert.assertEquals((Object)"radiance", (Object)parameter.getType());
        Assert.assertEquals((Object)"mW.m-2.nm-1", (Object)parameter.getUnit());
        Assert.assertEquals((Object)"Sea-level solar illumination at 510nm", (Object)parameter.getDescription());
    }

    @Test
    public void testParseObservationsResponse() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        InputStream jsonStream = JsonDeserializationTest.class.getResourceAsStream("ObservationsResponse.json");
        MermaidResponse response = (MermaidResponse)this.gson.fromJson((Reader)new InputStreamReader(jsonStream), MermaidResponse.class);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.OK, (Object)response.getStatus());
        Assert.assertNull((Object)response.getFailureReasons());
        Assert.assertEquals((long)484L, (long)response.getObservationCount());
        List campaignList = response.getDatasets();
        Assert.assertNotNull((Object)campaignList);
        Assert.assertEquals((long)2L, (long)campaignList.size());
        Campaign aeronetCampaign = (Campaign)campaignList.get(0);
        Assert.assertEquals((Object)"AERONET", (Object)aeronetCampaign.getName());
        List aeronetObservations = aeronetCampaign.getObservations();
        Assert.assertEquals((long)200L, (long)aeronetObservations.size());
        InsituObservation aeronetObs = (InsituObservation)aeronetObservations.get(12);
        Assert.assertEquals((Object)"es_412", (Object)aeronetObs.getParam());
        Assert.assertEquals((double)45.314, (double)aeronetObs.getLon(), (double)1.0E-6);
        Assert.assertEquals((double)12.508, (double)aeronetObs.getLat(), (double)1.0E-6);
        Assert.assertEquals((double)1043.825711, (double)aeronetObs.getValue(), (double)1.0E-6);
        Assert.assertEquals((Object)dateFormat.parse("22-APR-2002 12:21:56"), (Object)aeronetObs.getDate());
        Campaign boussoleCampaign = (Campaign)campaignList.get(1);
        Assert.assertEquals((Object)"BOUSSOLE", (Object)boussoleCampaign.getName());
        List boussoleObservations = boussoleCampaign.getObservations();
        Assert.assertEquals((long)284L, (long)boussoleObservations.size());
        InsituObservation boussoleObs = (InsituObservation)boussoleObservations.get(0);
        Assert.assertEquals((Object)"es_412", (Object)boussoleObs.getParam());
        Assert.assertEquals((double)43.367, (double)boussoleObs.getLon(), (double)1.0E-6);
        Assert.assertEquals((double)7.9, (double)boussoleObs.getLat(), (double)1.0E-6);
        Assert.assertEquals((double)748.971558, (double)boussoleObs.getValue(), (double)1.0E-6);
        Assert.assertEquals((Object)dateFormat.parse("23-SEP-2003 10:15:35"), (Object)boussoleObs.getDate());
    }

    @Test
    public void testParseFailureResponse() throws Exception {
        InputStream jsonStream = JsonDeserializationTest.class.getResourceAsStream("FailureResponse.json");
        MermaidResponse response = (MermaidResponse)this.gson.fromJson((Reader)new InputStreamReader(jsonStream), MermaidResponse.class);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)InsituResponse.STATUS_CODE.NOK, (Object)response.getStatus());
        Assert.assertNotNull((Object)response.getFailureReasons());
        Assert.assertEquals((Object)"Non-existent vars in URL for: lon_min & stop_date", response.getFailureReasons().get(0));
    }
}

