/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.ui;

import com.bc.ceres.swing.TableLayout;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.s3tbx.insitu.server.InsituDataset;
import org.esa.s3tbx.insitu.server.InsituObservation;
import org.esa.s3tbx.insitu.server.InsituParameter;
import org.esa.s3tbx.insitu.server.InsituQuery;
import org.esa.s3tbx.insitu.server.InsituResponse;
import org.esa.s3tbx.insitu.server.InsituServer;
import org.esa.s3tbx.insitu.server.InsituServerException;
import org.esa.s3tbx.insitu.server.InsituServerRunnable;
import org.esa.s3tbx.insitu.server.InsituServerSpi;
import org.esa.s3tbx.insitu.ui.Bundle;
import org.esa.s3tbx.insitu.ui.DataPolicyPanel;
import org.esa.s3tbx.insitu.ui.InsituClientForm;
import org.esa.s3tbx.insitu.ui.InsituClientModel;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptorRegistry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.help.HelpAction;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jdesktop.swingx.VerticalLayout;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="InsituClientTopComponent", iconBase="org/esa/s3tbx/insitu/insitu.png", persistenceType=0)
public class InsituClientTopComponent
extends TopComponent
implements HelpCtx.Provider {
    private static final String HELP_ID = "insituClientTool";
    private InsituClientModel insituModel;
    private AbstractButton refreshButton;

    public InsituClientTopComponent() {
        this.setName(Bundle.CTL_InsituClientTopComponent_Name());
    }

    private Component createStatusPanel(HelpCtx helpCtx) {
        TableLayout layout = new TableLayout(4);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableWeightX(Double.valueOf(0.5));
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTablePadding(4, 4);
        JPanel contentPanel = new JPanel((LayoutManager)layout);
        this.refreshButton = ToolButtonFactory.createButton((Icon)TangoIcons.actions_view_refresh((TangoIcons.Res)TangoIcons.Res.R22), (boolean)false);
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addActionListener(new ServerButtonActionListener(() -> this.createObservationQuery().countOnly(true), response -> this.setNumObs(response.getObservationCount())));
        contentPanel.add(this.refreshButton);
        AbstractButton downloadButton = ToolButtonFactory.createButton((Icon)TangoIcons.actions_document_save((TangoIcons.Res)TangoIcons.Res.R22), (boolean)false);
        downloadButton.setText("Download");
        downloadButton.setName("downloadButton");
        downloadButton.addActionListener(new ServerButtonActionListener(this::createObservationQuery, new DownloadResponseHandler()));
        contentPanel.add(downloadButton);
        contentPanel.add(layout.createHorizontalSpacer());
        AbstractButton helpButton = ToolButtonFactory.createButton((Action)new HelpAction(helpCtx), (boolean)false);
        helpButton.setName("helpButton");
        contentPanel.add(helpButton);
        return contentPanel;
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatureCollection(String datasetName, InsituObservation observation, SimpleFeatureType featureType, TreeMap<String, FeatureCollection<SimpleFeatureType, SimpleFeature>> map) {
        String fcKey = datasetName + "_" + observation.getParam();
        ListFeatureCollection fc = map.get(fcKey);
        if (fc == null) {
            fc = new ListFeatureCollection(featureType);
            map.put(fcKey, (FeatureCollection<SimpleFeatureType, SimpleFeature>)fc);
        }
        return fc;
    }

    private static SimpleFeatureType createInsituFeatureType(GeoCoding geoCoding) {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("org.esa.snap.Insitu");
        ftb.add("parameter", String.class);
        ftb.add("pixelPos", Point.class, geoCoding.getImageCRS());
        ftb.add("geoPos", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ftb.add("date", Date.class);
        ftb.add("value", Double.class);
        ftb.setDefaultGeometry(geoCoding instanceof CrsGeoCoding ? "geoPos" : "pixelPos");
        return ftb.buildFeatureType();
    }

    private static SimpleFeature createFeature(SimpleFeatureType type, GeoCoding geoCoding, int pointIndex, InsituObservation observation) {
        double lon;
        double lat = observation.getLat();
        PixelPos pixelPos = geoCoding.getPixelPos(new GeoPos(lat, lon = observation.getLon()), null);
        if (!pixelPos.isValid()) {
            return null;
        }
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(type);
        GeometryFactory gf = new GeometryFactory();
        fb.add((Object)observation.getParam());
        fb.add((Object)gf.createPoint(new Coordinate(pixelPos.x, pixelPos.y)));
        fb.add((Object)gf.createPoint(new Coordinate(lon, lat)));
        fb.add((Object)observation.getDate());
        fb.add((Object)observation.getValue());
        return fb.buildFeature(String.format("ID%08d", pointIndex));
    }

    private InsituQuery createObservationQuery() {
        InsituQuery query = new InsituQuery();
        query.subject(InsituQuery.SUBJECT.OBSERVATIONS);
        query.latMin(this.insituModel.getMinLat()).latMax(this.insituModel.getMaxLat());
        query.lonMin(this.insituModel.getMinLon()).lonMax(this.insituModel.getMaxLon());
        query.startDate(this.insituModel.getStartDate()).stopDate(this.insituModel.getStopDate());
        String[] datasetNames = this.insituModel.getSelectedDatasetNames();
        if (datasetNames.length > 0) {
            query.datasets(datasetNames);
        }
        Stream stream = this.insituModel.getSelectedParameters().stream();
        String[] parameterNames = (String[])stream.map(InsituParameter::getName).toArray(String[]::new);
        query.param(parameterNames);
        return query;
    }

    private InsituServer getServer() {
        try {
            InsituServerSpi serverSpi = this.insituModel.getSelectedServerSpi();
            return serverSpi.createServer();
        }
        catch (InsituServerException ise) {
            SnapApp.getDefault().handleError("Could not contact server.", (Throwable)ise);
            return null;
        }
    }

    private void setNumObs(long observationCount) {
        if (observationCount < 0L) {
            this.refreshButton.setText("#Obs: UNKNOWN");
        } else {
            this.refreshButton.setText("#Obs: " + observationCount);
        }
    }

    protected void componentOpened() {
        super.componentOpened();
        this.insituModel = new InsituClientModel();
        this.setLayout(new BorderLayout());
        this.add(new InsituClientForm(this.insituModel), "Center");
        this.add(this.createStatusPanel(new HelpCtx(HELP_ID)), "South");
        this.setNumObs(-1L);
    }

    protected void componentClosed() {
        super.componentClosed();
        this.insituModel.dispose();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private class DownloadResponseHandler
    implements ResponseHandler {
        private DownloadResponseHandler() {
        }

        @Override
        public void handle(InsituResponse response) {
            if (response.getObservationCount() <= 0L || response.getDatasets() == null) {
                return;
            }
            if (InsituResponse.STATUS_CODE.OK.equals((Object)response.getStatus())) {
                List<? extends InsituDataset> datasetList = response.getDatasets();
                JPanel content = new JPanel((LayoutManager)new VerticalLayout(4));
                ArrayList<DataPolicyPanel> policyPanels = new ArrayList<DataPolicyPanel>();
                for (InsituDataset insituDataset : datasetList) {
                    String policy = insituDataset.getPolicy();
                    if (!StringUtils.isNotNullAndNotEmpty((String)policy)) continue;
                    DataPolicyPanel datasetPolicyPanel = new DataPolicyPanel(insituDataset);
                    content.add(datasetPolicyPanel);
                    policyPanels.add(datasetPolicyPanel);
                }
                if (!policyPanels.isEmpty()) {
                    ModalDialog modalDialog = new ModalDialog(null, "In-Situ Data", (Object)new JScrollPane(content), 33, null);
                    JPanel jPanel = modalDialog.getButtonPanel();
                    JCheckBox acceptAll = new JCheckBox("Accept All");
                    acceptAll.addActionListener(e -> {
                        for (DataPolicyPanel policyPanel : policyPanels) {
                            policyPanel.setAccepted(acceptAll.isSelected());
                        }
                    });
                    jPanel.add((Component)acceptAll, 0);
                    JButton saveButton = new JButton("Save data policies");
                    saveButton.addActionListener(e -> {
                        File file = Dialogs.requestFileForSave((String)"Save Data Policy File", (boolean)false, null, (String)".txt", (String)"insitu-policy", null, (String)"s3tbx.insitu.policyExport");
                        if (file == null) {
                            return;
                        }
                        Path path = file.toPath();
                        try (PrintWriter w = new PrintWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]), false);){
                            for (InsituDataset insituDataset : datasetList) {
                                w.printf("Name: %s%n", insituDataset.getName());
                                w.printf("Pi: %s%n", insituDataset.getPi());
                                w.printf("Contact: %s%n", insituDataset.getContact());
                                w.printf("Website: %s%n", insituDataset.getWebsite());
                                w.printf("Data Policy: %s%n", insituDataset.getPolicy());
                                w.println();
                                w.flush();
                            }
                        }
                        catch (IOException ioe) {
                            SnapApp.getDefault().handleError("Could not write data policy file.", (Throwable)ioe);
                        }
                    });
                    jPanel.add((Component)saveButton, 0);
                    if (32 == modalDialog.show()) {
                        return;
                    }
                    for (DataPolicyPanel policyPanel : policyPanels) {
                        if (policyPanel.isAccepted()) continue;
                        Dialogs.showWarning((String)"In-Situ Data", (String)"Not all data policies have been accepted.", null);
                        return;
                    }
                }
            }
            List<Product> selectedProducts = InsituClientTopComponent.this.insituModel.getSelectedProducts();
            List<? extends InsituDataset> datasetList = response.getDatasets();
            for (InsituDataset insituDataset : datasetList) {
                List<? extends InsituObservation> list = insituDataset.getObservations();
                String datasetName = insituDataset.getName();
                for (Product product : selectedProducts) {
                    SimpleFeatureType featureType = InsituClientTopComponent.createInsituFeatureType(product.getSceneGeoCoding());
                    TreeMap fcMap = new TreeMap();
                    for (int i = 0; i < list.size(); ++i) {
                        InsituObservation observation = list.get(i);
                        SimpleFeature feature = InsituClientTopComponent.createFeature(featureType, product.getSceneGeoCoding(), i, observation);
                        if (feature == null) continue;
                        FeatureCollection fc = InsituClientTopComponent.this.getFeatureCollection(datasetName, observation, featureType, fcMap);
                        fc.add((Feature)feature);
                    }
                    for (Map.Entry entry : fcMap.entrySet()) {
                        FeatureCollection fc = (FeatureCollection)entry.getValue();
                        String name = (String)entry.getKey();
                        PlacemarkDescriptor placemarkDescriptor = PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptor((SimpleFeatureType)fc.getSchema());
                        placemarkDescriptor.setUserDataOf((SimpleFeatureType)fc.getSchema());
                        ProductNodeGroup vectorDataGroup = product.getVectorDataGroup();
                        String nodeName = ProductUtils.getAvailableNodeName((String)name, (ProductNodeGroup)vectorDataGroup);
                        VectorDataNode vectorDataNode = new VectorDataNode(nodeName, fc, placemarkDescriptor);
                        vectorDataGroup.add((ProductNode)vectorDataNode);
                    }
                }
            }
        }
    }

    @FunctionalInterface
    private static interface ResponseHandler {
        public void handle(InsituResponse var1);
    }

    @FunctionalInterface
    private static interface QueryFactory {
        public InsituQuery create();
    }

    private class ServerButtonActionListener
    implements ActionListener {
        private final QueryFactory factory;
        private final ResponseHandler handler;

        public ServerButtonActionListener(QueryFactory factory, ResponseHandler handler) {
            this.factory = factory;
            this.handler = handler;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InsituServer server = InsituClientTopComponent.this.getServer();
            if (server == null) {
                return;
            }
            InsituServerRunnable runnable = new InsituServerRunnable(server, this.factory.create());
            try {
                InsituServer.runWithProgress(runnable);
                this.handler.handle(runnable.getResponse());
            }
            catch (InsituServerException ise) {
                SnapApp.getDefault().handleError("Failed to contact server", (Throwable)ise);
            }
        }
    }
}

