/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.ui;

import com.bc.ceres.swing.TableLayout;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import org.esa.s3tbx.insitu.server.InsituDataset;
import org.esa.s3tbx.insitu.server.InsituParameter;
import org.esa.s3tbx.insitu.server.InsituServerSpi;
import org.esa.s3tbx.insitu.ui.InsituClientModel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.util.DateTimePicker;
import org.esa.snap.ui.DecimalFormatter;
import org.esa.snap.ui.UIUtils;

class InsituClientForm
extends JPanel {
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final DecimalFormatter DECIMAL_FORMATTER = new DecimalFormatter("###0.0##");
    private final InsituClientModel model;

    public InsituClientForm(InsituClientModel model) {
        this.model = model;
        this.initForm();
    }

    private void initForm() {
        TableLayout layout = new TableLayout(4);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTablePadding(4, 4);
        layout.setTableWeightX(Double.valueOf(0.1));
        layout.setTableWeightY(Double.valueOf(0.0));
        this.setLayout((LayoutManager)layout);
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        layout.setCellWeightX(0, 1, Double.valueOf(1.0));
        layout.setCellColspan(0, 1, Integer.valueOf(3));
        this.add(new JLabel("In-Situ Database:"));
        JComboBox<InsituServerSpi> insituServerComboBox = new JComboBox<InsituServerSpi>(this.model.getInsituServerModel());
        insituServerComboBox.setPrototypeDisplayValue(InsituClientModel.NO_SELECTION_SERVER_SPI);
        insituServerComboBox.setRenderer(new InsituServerListCellRenderer());
        this.add(insituServerComboBox);
        layout.setCellWeightX(1, 1, Double.valueOf(1.0));
        layout.setCellWeightX(1, 3, Double.valueOf(1.0));
        layout.setCellFill(1, 1, TableLayout.Fill.BOTH);
        layout.setCellAnchor(1, 0, TableLayout.Anchor.NORTHWEST);
        layout.setCellFill(1, 3, TableLayout.Fill.BOTH);
        layout.setCellAnchor(1, 2, TableLayout.Anchor.NORTHWEST);
        layout.setRowWeightY(1, Double.valueOf(0.6));
        this.add(new JLabel("Dataset:"));
        JList<InsituDataset> datasetList = new JList<InsituDataset>(this.model.getDatasetModel());
        datasetList.setSelectionModel(this.model.getDatasetSelectionModel());
        datasetList.setCellRenderer(new DatasetListCellRenderer());
        datasetList.setVisibleRowCount(6);
        this.add(new JScrollPane(datasetList));
        this.add(new JLabel("Parameter:"));
        JList<InsituParameter> paramList = new JList<InsituParameter>(this.model.getParameterModel());
        paramList.setSelectionModel(this.model.getParameterSelectionModel());
        paramList.setCellRenderer(new ParameterListCellRenderer());
        paramList.setVisibleRowCount(6);
        this.add(new JScrollPane(paramList));
        layout.setCellWeightX(2, 1, Double.valueOf(1.0));
        layout.setCellColspan(2, 1, Integer.valueOf(3));
        layout.setCellFill(2, 1, TableLayout.Fill.BOTH);
        layout.setCellAnchor(2, 0, TableLayout.Anchor.NORTHWEST);
        layout.setCellWeightY(2, 1, Double.valueOf(1.0));
        this.add(new JLabel("Product:"));
        JList<Product> productList = new JList<Product>(this.model.getProductListModel());
        productList.setSelectionModel(this.model.getProductSelectionModel());
        productList.setCellRenderer(new ProductListCellRenderer());
        productList.setVisibleRowCount(6);
        this.add(new JScrollPane(productList));
        layout.setCellWeightX(3, 1, Double.valueOf(1.0));
        layout.setCellWeightX(3, 3, Double.valueOf(1.0));
        this.add(new JLabel("Start time:"));
        DateTimePicker startDatePicker = new DateTimePicker(this.model.getStartDate(), Locale.getDefault(), (DateFormat)DEFAULT_DATE_FORMAT, (DateFormat)TIME_FORMAT);
        startDatePicker.addPropertyChangeListener("date", evt -> this.model.setStartDate((Date)evt.getNewValue()));
        this.model.getChangeSupport().addPropertyChangeListener("startDate", evt -> startDatePicker.setDateTime(this.model.getStartDate()));
        this.add((Component)startDatePicker);
        this.add(new JLabel("Stop time:"));
        DateTimePicker stopDatePicker = new DateTimePicker(this.model.getStopDate(), Locale.getDefault(), (DateFormat)DEFAULT_DATE_FORMAT, (DateFormat)TIME_FORMAT);
        stopDatePicker.addPropertyChangeListener("date", evt -> this.model.setStopDate((Date)evt.getNewValue()));
        this.model.getChangeSupport().addPropertyChangeListener("stopDate", evt -> stopDatePicker.setDateTime(this.model.getStopDate()));
        this.add((Component)stopDatePicker);
        layout.setCellWeightX(4, 1, Double.valueOf(1.0));
        layout.setCellWeightX(4, 3, Double.valueOf(1.0));
        this.add(new JLabel("Min longitude:"));
        JFormattedTextField minLonField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)DECIMAL_FORMATTER);
        minLonField.setValue(this.model.getMinLon());
        minLonField.addPropertyChangeListener("value", e -> this.model.setMinLon((Double)minLonField.getValue()));
        this.model.getChangeSupport().addPropertyChangeListener("minLon", new JFormattedTextFieldChangeListener(minLonField));
        this.add(minLonField);
        this.add(new JLabel("Max longitude:"));
        JFormattedTextField maxLonField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)DECIMAL_FORMATTER);
        maxLonField.setValue(this.model.getMaxLon());
        maxLonField.addPropertyChangeListener("value", e -> this.model.setMaxLon((Double)maxLonField.getValue()));
        this.model.getChangeSupport().addPropertyChangeListener("maxLon", new JFormattedTextFieldChangeListener(maxLonField));
        this.add(maxLonField);
        layout.setCellWeightX(5, 1, Double.valueOf(1.0));
        layout.setCellWeightX(5, 3, Double.valueOf(1.0));
        this.add(new JLabel("Min latitude:"));
        JFormattedTextField minLatField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)DECIMAL_FORMATTER);
        minLatField.setValue(this.model.getMinLat());
        minLatField.addPropertyChangeListener("value", e -> this.model.setMinLat((Double)minLatField.getValue()));
        this.model.getChangeSupport().addPropertyChangeListener("minLat", new JFormattedTextFieldChangeListener(minLatField));
        this.add(minLatField);
        this.add(new JLabel("Max latitude:"));
        JFormattedTextField maxLatField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)DECIMAL_FORMATTER);
        maxLatField.setValue(this.model.getMaxLat());
        maxLatField.addPropertyChangeListener("value", e -> this.model.setMaxLat((Double)maxLatField.getValue()));
        this.model.getChangeSupport().addPropertyChangeListener("maxLat", new JFormattedTextFieldChangeListener(maxLatField));
        this.add(maxLatField);
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
        Locale.setDefault(Locale.ENGLISH);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame();
            ImageIcon imageIcon = UIUtils.loadImageIcon((String)"/org/esa/s3tbx/insitu/insitu24.png", InsituClientForm.class);
            if (imageIcon != null) {
                frame.setIconImage(imageIcon.getImage());
            }
            frame.setTitle("In-Situ Data Access");
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().add(new InsituClientForm(new InsituClientModel()));
            frame.pack();
            frame.setVisible(true);
        });
    }

    private class ProductListCellRenderer
    extends DefaultListCellRenderer {
        private ProductListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Product product = (Product)value;
            label.setText(product.getDisplayName());
            label.setToolTipText(product.getDescription());
            return label;
        }
    }

    private static class JFormattedTextFieldChangeListener
    implements PropertyChangeListener {
        private final JFormattedTextField textField;

        public JFormattedTextFieldChangeListener(JFormattedTextField textField) {
            this.textField = textField;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.textField.getValue().equals(evt.getNewValue())) {
                this.textField.setValue(evt.getNewValue());
            }
        }
    }

    private static class ParameterListCellRenderer
    extends DefaultListCellRenderer {
        private ParameterListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            InsituParameter insituParameter = (InsituParameter)value;
            label.setText(insituParameter.getName());
            label.setToolTipText(insituParameter.getDescription());
            String text = String.format("<html><b>Type: </b>%s<br><b>Unit: </b>%s<br><b>Description: </b>%s", insituParameter.getType(), insituParameter.getUnit(), insituParameter.getDescription());
            label.setToolTipText(text);
            return label;
        }
    }

    private static class DatasetListCellRenderer
    extends DefaultListCellRenderer {
        private DatasetListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            InsituDataset datasetDescr = (InsituDataset)value;
            label.setText(datasetDescr.getName());
            label.setToolTipText(datasetDescr.getDescription());
            String text = String.format("<html><b>PI: </b>%s<br><b>Contact: </b>%s<br><b>Website: </b>%s<br><b>Description: </b>%s", datasetDescr.getPi(), datasetDescr.getContact(), datasetDescr.getWebsite(), datasetDescr.getDescription());
            label.setToolTipText(text);
            return label;
        }
    }

    private static class InsituServerListCellRenderer
    extends DefaultListCellRenderer {
        private InsituServerListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            InsituServerSpi server = (InsituServerSpi)value;
            label.setText(server.getName());
            label.setToolTipText(server.getDescription());
            return label;
        }
    }
}

