/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.s3tbx.idepix.core.util.SunPosition;

public class SunPositionCalculator {
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double SEC_PER_DAY = 86400.0;
    private static final double DAY_PER_YEAR = 365.25;
    private static final double DAY_PER_LYEAR = 366.0;
    private static final int SUMSOL = 172;
    private static final int[] dpm = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] ldpm = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final double[] gha = new double[]{179.23, 176.63, 176.88, 179.0, 180.72, 180.56, 179.06, 178.4, 179.98, 182.56, 184.91, 182.75};

    public static SunPosition calculate(Calendar calendar) {
        double sungha;
        double sunlng;
        int i;
        Calendar utc = SunPositionCalculator.toUTC(calendar);
        int year = utc.get(1);
        int month = utc.get(2) + 1;
        int date = utc.get(5);
        int day = utc.get(5);
        int hour = utc.get(11);
        int minute = utc.get(12);
        int second = utc.get(13);
        double h = (double)hour + (double)minute / 60.0 + (double)second / 3600.0;
        long jdate = utc.get(6);
        double tsec = (double)hour * 3600.0 + (double)minute * 60.0 + (double)second;
        double we = 7.27220719468286E-5;
        double fjd = (double)jdate + tsec / 86400.0;
        if (fjd > 365.25) {
            fjd = IdepixUtils.isLeapYear(year) && fjd > 366.0 ? (fjd -= 366.0) : (fjd -= 365.25);
        }
        double djd = fjd - 1.0;
        double dmo = 0.0;
        if (IdepixUtils.isLeapYear(year)) {
            for (i = 0; i < 12; ++i) {
                if (!((djd -= (double)ldpm[i]) < 0.0)) continue;
                month = i + 1;
                dmo = ((double)ldpm[i] + djd) / (double)ldpm[i];
                break;
            }
        } else {
            for (i = 0; i < 12; ++i) {
                if (!((djd -= (double)dpm[i]) < 0.0)) continue;
                month = i + 1;
                dmo = ((double)dpm[i] + djd) / (double)dpm[i];
                break;
            }
        }
        int ist = month;
        int iend = month + 1;
        if (month == 12) {
            ist = 12;
            iend = 1;
        }
        if ((sunlng = Math.PI * 2 - (sungha = ((gha[iend - 1] - gha[ist - 1]) * dmo + gha[ist - 1]) * (Math.PI / 180)) - 7.27220719468286E-5 * tsec) < 0.0) {
            sunlng += Math.PI * 2;
        }
        double earc = (fjd - 172.0) / 365.25 * 2.0 * Math.PI;
        double sunlat = 23.5 * Math.cos(earc * (Math.PI / 180)) * (Math.PI / 180);
        return new SunPosition(Math.toDegrees(sunlat), Math.toDegrees(sunlng));
    }

    private static Calendar toUTC(Calendar calendar) {
        GregorianCalendar utc = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        utc.setTimeInMillis(calendar.getTimeInMillis());
        return utc;
    }

    static long toJulianDay(int year, int month, int dayOfMonth) {
        double millisPerDay = 8.64E7;
        double epochJulianDate = -2440587.5;
        GregorianCalendar utc = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        utc.clear();
        utc.set(year, month, dayOfMonth, 0, 0, 0);
        utc.set(14, 0);
        return (long)((double)utc.getTimeInMillis() / 8.64E7 - -2440587.5);
    }
}

