/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.nn.NNffbpAlphaTabFast;
import org.esa.snap.core.util.io.FileUtils;

public class SchillerNeuralNetWrapper {
    private final NNffbpAlphaTabFast neuralNet;
    private final double[] nnIn;

    private SchillerNeuralNetWrapper(NNffbpAlphaTabFast neuralNet, int in) {
        this.neuralNet = neuralNet;
        this.nnIn = new double[in];
    }

    public NNffbpAlphaTabFast getNeuralNet() {
        return this.neuralNet;
    }

    public double[] getInputVector() {
        return this.nnIn;
    }

    public static ThreadLocal<SchillerNeuralNetWrapper> create(InputStream inputStream) {
        final String netAsString = SchillerNeuralNetWrapper.readNeuralNetFromStream(inputStream);
        return new ThreadLocal<SchillerNeuralNetWrapper>(){

            @Override
            protected SchillerNeuralNetWrapper initialValue() {
                try {
                    NNffbpAlphaTabFast nNffbpAlphaTabFast = new NNffbpAlphaTabFast(netAsString);
                    int numIn = nNffbpAlphaTabFast.getInmin().length;
                    return new SchillerNeuralNetWrapper(nNffbpAlphaTabFast, numIn);
                }
                catch (IOException e) {
                    throw new OperatorException("Cannot initialize neural nets: " + e.getMessage());
                }
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readNeuralNetFromStream(InputStream neuralNetStream) {
        try (InputStreamReader reader = new InputStreamReader(neuralNetStream);){
            String string = FileUtils.readText((Reader)reader);
            return string;
        }
        catch (IOException ioe) {
            throw new OperatorException("Could not initialize neural net", (Throwable)ioe);
        }
    }
}

