/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core.util;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.ProductUtils;

public class OperatorUtils {
    private OperatorUtils() {
    }

    public static Product createCompatibleProduct(Product sourceProduct, String name, String type) {
        return OperatorUtils.createCompatibleProduct(sourceProduct, name, type, false);
    }

    public static Product createCompatibleProduct(Product sourceProduct, String name, String type, boolean includeTiepoints) {
        int sceneWidth = sourceProduct.getSceneRasterWidth();
        int sceneHeight = sourceProduct.getSceneRasterHeight();
        Product targetProduct = new Product(name, type, sceneWidth, sceneHeight);
        if (includeTiepoints) {
            ProductUtils.copyTiePointGrids((Product)sourceProduct, (Product)targetProduct);
        }
        OperatorUtils.copyProductBase(sourceProduct, targetProduct);
        return targetProduct;
    }

    public static void copyProductBase(Product sourceProduct, Product targetProduct) {
        ProductUtils.copyGeoCoding((Product)sourceProduct, (Product)targetProduct);
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
    }
}

