/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core.util;

import com.bc.jnn.Jnn;
import com.bc.jnn.JnnException;
import com.bc.jnn.JnnNet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.esa.snap.core.gpf.OperatorException;

public class NeuralNetWrapper {
    private final JnnNet neuralNet;
    private final double[] nnIn;
    private final double[] nnOut;

    private NeuralNetWrapper(JnnNet neuralNet, int in, int out) {
        this.neuralNet = neuralNet;
        this.nnIn = new double[in];
        this.nnOut = new double[out];
    }

    public JnnNet getNeuralNet() {
        return this.neuralNet;
    }

    public double[] getInputVector() {
        return this.nnIn;
    }

    public double[] getOutputVector() {
        return this.nnOut;
    }

    public static ThreadLocal<NeuralNetWrapper> create(InputStream inputStream, final int in, final int out) {
        final JnnNet jnnNet = NeuralNetWrapper.loadNeuralNet(inputStream);
        return new ThreadLocal<NeuralNetWrapper>(){

            @Override
            protected NeuralNetWrapper initialValue() {
                return new NeuralNetWrapper(jnnNet.clone(), in, out);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JnnNet loadNeuralNet(InputStream inputStream) {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            Jnn.setOptimizing((boolean)true);
            JnnNet jnnNet = Jnn.readNna((Reader)reader);
            return jnnNet;
        }
        catch (JnnException | IOException jnne) {
            throw new OperatorException(jnne);
        }
    }
}

