/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core.util;

import java.util.Calendar;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.gpf.Tile;

public class IdepixUtils {
    private static Logger logger = Logger.getLogger("idepix");

    public static void logErrorMessage(String msg) {
        if (System.getProperty("gpfMode") != null && "GUI".equals(System.getProperty("gpfMode"))) {
            JOptionPane.showOptionDialog(null, msg, "IDEPIX - Error Message", -1, 0, null, null, null);
        } else {
            IdepixUtils.info(msg);
        }
    }

    public static void info(String msg) {
        logger.info(msg);
    }

    public static float spectralSlope(float ch1, float ch2, float wl1, float wl2) {
        return (ch2 - ch1) / (wl2 - wl1);
    }

    public static float[] correctSaturatedReflectances(float[] reflectance) {
        int i;
        if (IdepixUtils.isNoReflectanceValid(reflectance)) {
            return reflectance;
        }
        float[] correctedReflectance = new float[reflectance.length];
        correctedReflectance[reflectance.length - 1] = Float.NaN;
        for (i = reflectance.length - 1; i >= 0; --i) {
            if (Float.isNaN(reflectance[i])) continue;
            correctedReflectance[reflectance.length - 1] = reflectance[i];
            break;
        }
        for (i = reflectance.length - 1; i > 0; --i) {
            correctedReflectance[i - 1] = Float.isNaN(reflectance[i - 1]) ? correctedReflectance[i] : reflectance[i - 1];
        }
        return correctedReflectance;
    }

    public static double convertGeophysicalToMathematicalAngle(double inAngle) {
        if (0.0 <= inAngle && inAngle < 90.0) {
            return 90.0 - inAngle;
        }
        if (90.0 <= inAngle && inAngle < 360.0) {
            return 90.0 - inAngle + 360.0;
        }
        return Double.NaN;
    }

    public static boolean isNoReflectanceValid(float[] reflectance) {
        for (float aReflectance : reflectance) {
            if (Float.isNaN(aReflectance) || !(aReflectance > 0.0f)) continue;
            return false;
        }
        return true;
    }

    public static int getDoyFromYYMMDD(String yymmdd) {
        Calendar cal = Calendar.getInstance();
        int doy = -1;
        try {
            int year = Integer.parseInt(yymmdd.substring(0, 2));
            int month = Integer.parseInt(yymmdd.substring(2, 4)) - 1;
            int day = Integer.parseInt(yymmdd.substring(4, 6));
            cal.set(year, month, day);
            doy = cal.get(6);
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return doy;
    }

    public static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public static void combineFlags(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        int sourceFlags = sourceFlagTile.getSampleInt(x, y);
        int computedFlags = targetTile.getSampleInt(x, y);
        targetTile.setSample(x, y, sourceFlags | computedFlags);
    }

    public static void consolidateCloudAndBuffer(Tile targetTile, int x, int y) {
        if (targetTile.getSampleBit(x, y, 1)) {
            targetTile.setSample(x, y, 4, false);
        }
    }

    public static boolean isLandPixel(int x, int y, GeoCoding geoCoding, boolean isL1Land, int waterFraction) {
        if (IdepixUtils.getGeoPos((GeoCoding)geoCoding, (int)x, (int)y).lat > -58.0) {
            if (waterFraction <= 100) {
                return waterFraction == 0;
            }
            return isL1Land;
        }
        return isL1Land;
    }

    public static GeoPos getGeoPos(GeoCoding geoCoding, int x, int y) {
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    public static double computeAzimuthDifference(double vaa, double saa) {
        return 57.29577951308232 * Math.acos(Math.cos(Math.PI / 180 * (vaa - saa)));
    }
}

