/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core.util;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.PixelPos;

public class Bresenham {
    private int dx;
    private int dy;
    private int error;
    private int x_inc;
    private int y_inc;
    private int xx;
    private int yy;
    private int length;
    private int count;

    public int plot(int x1, int y1, int x2, int y2) {
        this.dx = x2 - x1;
        this.dy = y2 - y1;
        if (this.dx >= 0) {
            this.x_inc = 1;
        } else {
            this.x_inc = -1;
            this.dx = -this.dx;
        }
        if (this.dy >= 0) {
            this.y_inc = 1;
        } else {
            this.y_inc = -1;
            this.dy = -this.dy;
        }
        this.xx = x1;
        this.yy = y1;
        this.error = this.dx > 0 ? this.dx >> 1 : this.dy >> 1;
        this.count = 0;
        this.length = Math.max(this.dx, this.dy) + 1;
        return this.length;
    }

    public boolean next() {
        if (this.dx > this.dy) {
            this.error += this.dy;
            if (this.error >= this.dx) {
                this.error -= this.dx;
                this.yy += this.y_inc;
            }
            this.xx += this.x_inc;
        } else {
            this.error += this.dx;
            if (this.error >= this.dy) {
                this.error -= this.dy;
                this.xx += this.x_inc;
            }
            this.yy += this.y_inc;
        }
        ++this.count;
        return this.count < this.length;
    }

    public int getX() {
        return this.xx;
    }

    public int getY() {
        return this.yy;
    }

    public static List<PixelPos> getPathPixels(int x1, int y1, int x2, int y2, Rectangle rect) {
        ArrayList<PixelPos> path = new ArrayList<PixelPos>();
        Bresenham bresenham = new Bresenham();
        int length = bresenham.plot(x1, y1, x2, y2);
        for (int i = 0; i < length; ++i) {
            bresenham.next();
            PixelPos pos = new PixelPos((double)bresenham.getX(), (double)bresenham.getY());
            if (!rect.contains(bresenham.getX(), bresenham.getY())) continue;
            path.add(pos);
        }
        return path;
    }

    public static PixelPos findBorderPixel(int x, int y, Rectangle rect, double angle) {
        PixelPos pos2 = Bresenham.findBorderPixel(x - rect.x, y - rect.y, rect.width, rect.height, angle);
        int xpos = (int)pos2.getX() + rect.x;
        int ypos = (int)pos2.getY() + rect.y;
        return new PixelPos((double)xpos, (double)ypos);
    }

    private static PixelPos findBorderPixel(int x, int y, int width, int height, double angle) {
        int w = width - 1;
        int h = height - 1;
        int xPos = -1;
        int yPos = -1;
        double urAngle = 57.29577951308232 * Math.atan((double)y * 1.0 / (double)(w - x));
        if (angle <= urAngle) {
            xPos = w;
            yPos = (int)Math.round((double)y - (double)(w - x) * Math.tan(Math.PI / 180 * angle));
        } else if (angle > urAngle && angle < 90.0) {
            xPos = (int)Math.round((double)x + (double)y / Math.tan(Math.PI / 180 * angle));
            yPos = 0;
        } else {
            double ulAngle = 90.0 + 57.29577951308232 * Math.atan((double)x * 1.0 / (double)y);
            if (angle > 90.0 && angle <= ulAngle) {
                xPos = (int)Math.round((double)x - (double)y * Math.tan(Math.PI / 180 * (angle - 90.0)));
                yPos = 0;
            } else if (angle > ulAngle && angle < 180.0) {
                xPos = 0;
                yPos = (int)Math.round((double)y - (double)x / Math.tan(Math.PI / 180 * (angle - 90.0)));
            } else {
                double llAngle = 180.0 + 57.29577951308232 * Math.atan((double)(h - y) * 1.0 / (double)x);
                if (angle > 180.0 && angle <= llAngle) {
                    xPos = 0;
                    yPos = (int)Math.round((double)y + (double)x * Math.tan(Math.PI / 180 * (angle - 180.0)));
                } else if (angle > llAngle && angle < 270.0) {
                    xPos = (int)Math.round((double)x + (double)(y - h) / Math.tan(Math.PI / 180 * (angle - 180.0)));
                    yPos = h;
                } else {
                    double lrAngle = 270.0 + 57.29577951308232 * Math.atan((double)(w - x) * 1.0 / (double)(h - y));
                    if (angle > 270.0 && angle <= lrAngle) {
                        xPos = (int)Math.round((double)x + (double)(h - y) * Math.tan(Math.PI / 180 * (angle - 270.0)));
                        yPos = h;
                    } else if (angle > lrAngle && angle < 360.0) {
                        xPos = w;
                        yPos = (int)Math.round((double)y + (double)(w - x) / Math.tan(Math.PI / 180 * (angle - 270.0)));
                    } else if (angle == 90.0) {
                        xPos = x;
                        yPos = 0;
                    } else if (angle == 180.0) {
                        xPos = 0;
                        yPos = y;
                    } else if (angle == 270.0) {
                        xPos = x;
                        yPos = h;
                    } else if (angle == 360.0 || angle == 0.0) {
                        xPos = w;
                        yPos = y;
                    }
                }
            }
        }
        return new PixelPos((double)xPos, (double)yPos);
    }
}

