/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core.operators;

import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.util.ProductUtils;

public abstract class BasisOp
extends Operator {
    public Product createCompatibleProduct(Product sourceProduct, String name, String type) {
        int sceneWidth = sourceProduct.getSceneRasterWidth();
        int sceneHeight = sourceProduct.getSceneRasterHeight();
        Product targetProduct = new Product(name, type, sceneWidth, sceneHeight);
        this.copyProductTrunk(sourceProduct, targetProduct);
        return targetProduct;
    }

    public void copyProductTrunk(Product sourceProduct, Product targetProduct) {
        ProductUtils.copyTiePointGrids((Product)sourceProduct, (Product)targetProduct);
        ProductUtils.copyGeoCoding((Product)sourceProduct, (Product)targetProduct);
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
    }

    public void renameL1bMaskNames(Product product) {
        this.prefixMask("coastline", product);
        this.prefixMask("land", product);
        this.prefixMask("water", product);
        this.prefixMask("cosmetic", product);
        this.prefixMask("duplicated", product);
        this.prefixMask("glint_risk", product);
        this.prefixMask("suspect", product);
        this.prefixMask("bright", product);
        this.prefixMask("invalid", product);
    }

    public void prefixMask(String maskName, Product product) {
        Mask mask = (Mask)product.getMaskGroup().get(maskName);
        if (mask != null) {
            mask.setName("l1b_" + mask.getName());
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(BasisOp.class);
        }
    }
}

