/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core;

import java.awt.Color;
import java.util.Random;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.BitSetter;

public class IdepixFlagCoding {
    public static FlagCoding createDefaultFlagCoding(String flagId) {
        FlagCoding flagCoding = new FlagCoding(flagId);
        flagCoding.addFlag("IDEPIX_INVALID", BitSetter.setFlag((int)0, (int)0), "Invalid pixels");
        flagCoding.addFlag("IDEPIX_CLOUD", BitSetter.setFlag((int)0, (int)1), "Pixels which are either cloud_sure or cloud_ambiguous");
        flagCoding.addFlag("IDEPIX_CLOUD_AMBIGUOUS", BitSetter.setFlag((int)0, (int)2), "Semi transparent clouds, or clouds where the detection level is uncertain");
        flagCoding.addFlag("IDEPIX_CLOUD_SURE", BitSetter.setFlag((int)0, (int)3), "Fully opaque clouds with full confidence of their detection");
        flagCoding.addFlag("IDEPIX_CLOUD_BUFFER", BitSetter.setFlag((int)0, (int)4), "A buffer of n pixels around a cloud. n is a user supplied parameter. Applied to pixels masked as 'cloud'");
        flagCoding.addFlag("IDEPIX_CLOUD_SHADOW", BitSetter.setFlag((int)0, (int)5), "Pixels is affect by a cloud shadow");
        flagCoding.addFlag("IDEPIX_SNOW_ICE", BitSetter.setFlag((int)0, (int)6), "Clear snow/ice pixels");
        flagCoding.addFlag("IDEPIX_BRIGHT", BitSetter.setFlag((int)0, (int)7), "Bright pixels");
        flagCoding.addFlag("IDEPIX_WHITE", BitSetter.setFlag((int)0, (int)8), "White pixels");
        flagCoding.addFlag("IDEPIX_COASTLINE", BitSetter.setFlag((int)0, (int)9), "Pixels at a coastline");
        flagCoding.addFlag("IDEPIX_LAND", BitSetter.setFlag((int)0, (int)10), "Land pixels");
        return flagCoding;
    }

    public static int setupDefaultClassifBitmask(Product classifProduct) {
        int index = 0;
        int w = classifProduct.getSceneRasterWidth();
        int h = classifProduct.getSceneRasterHeight();
        Random r = new Random();
        Mask mask = Mask.BandMathsType.create((String)"IDEPIX_INVALID", (String)"Invalid pixels", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_INVALID", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD", (String)"Pixels which are either cloud_sure or cloud_ambiguous", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD", (Color)Color.yellow, (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_AMBIGUOUS", (String)"Semi transparent clouds, or clouds where the detection level is uncertain", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_AMBIGUOUS", (Color)Color.blue, (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_SURE", (String)"Fully opaque clouds with full confidence of their detection", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_SURE", (Color)Color.red, (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_BUFFER", (String)"A buffer of n pixels around a cloud. n is a user supplied parameter. Applied to pixels masked as 'cloud'", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_BUFFER", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_SHADOW", (String)"Pixels is affect by a cloud shadow", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_SHADOW", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_SNOW_ICE", (String)"Clear snow/ice pixels", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_SNOW_ICE", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_BRIGHT", (String)"Bright pixels", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_BRIGHT", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_WHITE", (String)"White pixels", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_WHITE", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_COASTLINE", (String)"Pixels at a coastline", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_COASTLINE", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_LAND", (String)"Land pixels", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_LAND", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        return index;
    }

    public static Color getRandomColour(Random random) {
        int rColor = random.nextInt(256);
        int gColor = random.nextInt(256);
        int bColor = random.nextInt(256);
        return new Color(rColor, gColor, bColor);
    }
}

