/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core;

import java.awt.Rectangle;
import java.util.List;
import org.esa.s3tbx.idepix.core.util.Bresenham;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.gpf.Tile;

public abstract class CloudShadowFronts {
    private static final int MEAN_EARTH_RADIUS = 6372000;
    private final GeoCoding geoCoding;
    private final Rectangle sourceRectangle;
    private final Rectangle targetRectangle;
    private final Tile szaTile;
    private final Tile saaTile;
    private final Tile ctpTile;
    private final Tile altTile;

    public CloudShadowFronts(GeoCoding geoCoding, Rectangle sourceRectangle, Rectangle targetRectangle, Tile szaTile, Tile saaTile, Tile ctpTile, Tile altTile) {
        this.geoCoding = geoCoding;
        this.sourceRectangle = sourceRectangle;
        this.targetRectangle = targetRectangle;
        this.szaTile = szaTile;
        this.saaTile = saaTile;
        this.ctpTile = ctpTile;
        this.altTile = altTile;
    }

    protected abstract boolean isCloudForShadow(int var1, int var2);

    protected abstract boolean isCloudFree(int var1, int var2);

    protected abstract boolean isSurroundedByCloud(int var1, int var2);

    protected abstract void setCloudShadow(int var1, int var2);

    public void computeCloudShadow() {
        int x;
        int y;
        int h = this.targetRectangle.height;
        int w = this.targetRectangle.width;
        int x0 = this.targetRectangle.x;
        int y0 = this.targetRectangle.y;
        boolean[][] isCloudShadow = new boolean[w][h];
        for (y = y0; y < y0 + h; ++y) {
            for (x = x0; x < x0 + w; ++x) {
                if (!this.isCloudFree(x, y)) continue;
                isCloudShadow[x - x0][y - y0] = this.getCloudShadow(x, y);
                if (!isCloudShadow[x - x0][y - y0]) continue;
                this.setCloudShadow(x, y);
            }
        }
        for (y = this.targetRectangle.y; y < this.targetRectangle.y + this.targetRectangle.height; ++y) {
            for (x = this.targetRectangle.x; x < this.targetRectangle.x + this.targetRectangle.width; ++x) {
                if (!this.isCloudFree(x, y)) continue;
                boolean pixelSurroundedByClouds = this.isSurroundedByCloud(x, y);
                boolean pixelSurroundedByCloudShadow = this.isPixelSurroundedByCloudShadow(x, y, isCloudShadow);
                if (!pixelSurroundedByClouds && !pixelSurroundedByCloudShadow) continue;
                this.setCloudShadow(x, y);
            }
        }
        for (y = y0; y < y0 + h; ++y) {
            for (x = x0; x < x0 + w; ++x) {
                if (!this.isCloudFree(x, y)) continue;
                this.performCloudShadowBeltCorrection(x, y, isCloudShadow);
            }
        }
    }

    private boolean isPixelSurroundedByCloudShadow(int x, int y, boolean[][] isCloudShadow) {
        int surroundingPixelCount = 0;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                if (!this.targetRectangle.contains(i, j) || !isCloudShadow[i - this.targetRectangle.x][j - this.targetRectangle.y]) continue;
                ++surroundingPixelCount;
            }
        }
        return (double)surroundingPixelCount * 1.0 / 9.0 >= 0.7;
    }

    private void performCloudShadowBeltCorrection(int x, int y, boolean[][] isCloudShadow) {
        block0: for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                if (!this.targetRectangle.contains(i, j) || !isCloudShadow[i - this.targetRectangle.x][j - this.targetRectangle.y]) continue;
                this.setCloudShadow(x, y);
                continue block0;
            }
        }
    }

    public static boolean isPixelSurrounded(int x, int y, Tile sourceFlagTile, int pixelFlag) {
        int surroundingPixelCount = 0;
        Rectangle rectangle = sourceFlagTile.getRectangle();
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                if (!rectangle.contains(i, j) || !sourceFlagTile.getSampleBit(i, j, pixelFlag)) continue;
                ++surroundingPixelCount;
            }
        }
        return (double)surroundingPixelCount * 1.0 / 9.0 >= 0.7;
    }

    private boolean getCloudShadow(int x, int y) {
        double sza = this.szaTile.getSampleDouble(x, y);
        double saa = this.saaTile.getSampleDouble(x, y);
        double alt = 0.0;
        if (this.altTile != null && (alt = this.altTile.getSampleDouble(x, y)) < 0.0) {
            alt = 0.0;
        }
        double saaRad = Math.toRadians(saa);
        PixelPos pixelPos = new PixelPos((double)((float)x + 0.5f), (double)((float)y + 0.5f));
        GeoPos geoPos = this.geoCoding.getGeoPos(pixelPos, null);
        double tanSza = Math.tan(Math.toRadians(90.0 - sza));
        double cloudHeightMax = 12000.0;
        double cloudDistanceMax = 12000.0 / tanSza;
        GeoPos endGeoPoint = CloudShadowFronts.lineWithAngle(geoPos, cloudDistanceMax, saaRad + Math.PI);
        PixelPos endPixPoint = this.geoCoding.getPixelPos(endGeoPoint, null);
        if (endPixPoint.x == -1.0 || endPixPoint.y == -1.0) {
            return false;
        }
        int endPointX = (int)Math.round(endPixPoint.x);
        int endPointY = (int)Math.round(endPixPoint.y);
        List<PixelPos> pathPixels = Bresenham.getPathPixels(x, y, endPointX, endPointY, this.sourceRectangle);
        GeoPos geoPosCurrent = new GeoPos();
        for (PixelPos pathPixel : pathPixels) {
            float cloudHeight;
            int yCurrent;
            int xCurrent = (int)pathPixel.getX();
            if (!this.sourceRectangle.contains(xCurrent, yCurrent = (int)pathPixel.getY()) || !this.isCloudForShadow(xCurrent, yCurrent)) continue;
            pixelPos.setLocation((double)((float)xCurrent + 0.5f), (double)((float)yCurrent + 0.5f));
            this.geoCoding.getGeoPos(pixelPos, geoPosCurrent);
            double cloudSearchHeight = this.computeDistance(geoPos, geoPosCurrent) * tanSza + alt;
            if (!(cloudSearchHeight <= (double)((cloudHeight = this.computeHeightFromPressure(this.ctpTile.getSampleFloat(xCurrent, yCurrent))) + 300.0f))) continue;
            float cloudBase = this.getCloudBase(xCurrent, yCurrent);
            cloudBase = (float)Math.min((double)cloudHeight - 300.0, (double)cloudBase);
            if (!(cloudSearchHeight >= (double)((cloudBase = (float)Math.max(300.0, (double)cloudBase)) - 300.0f))) continue;
            return true;
        }
        return false;
    }

    private float getCloudBase(int x, int y) {
        float cb;
        if (this.ctpTile == null) {
            cb = 0.0f;
        } else {
            cb = this.computeHeightFromPressure(this.ctpTile.getSampleFloat(x, y));
            for (int i = x - 1; i <= x + 1; ++i) {
                for (int j = y - 1; j <= y + 1; ++j) {
                    if (!this.sourceRectangle.contains(i, j)) continue;
                    float neighbourCloudBase = this.computeHeightFromPressure(this.ctpTile.getSampleFloat(i, j));
                    cb = Math.min(cb, neighbourCloudBase);
                }
            }
        }
        return cb;
    }

    public static GeoPos lineWithAngle(GeoPos startPoint, double lengthInMeters, double azimuthAngleInRadiance) {
        double deltaX = lengthInMeters * Math.sin(azimuthAngleInRadiance);
        double deltaY = lengthInMeters * Math.cos(azimuthAngleInRadiance);
        float distLat = (float)(-(deltaY / 6372000.0) * 57.29577951308232);
        float distLon = (float)(-(deltaX / (6372000.0 * Math.cos(startPoint.lat * (Math.PI / 180)))) * 57.29577951308232);
        return new GeoPos(startPoint.lat + (double)distLat, startPoint.lon + (double)distLon);
    }

    private float computeHeightFromPressure(float pressure) {
        return (float)(-8000.0 * Math.log(pressure / 1013.0f));
    }

    private double computeDistance(GeoPos geoPos1, GeoPos geoPos2) {
        float lon1 = (float)geoPos1.getLon();
        float lon2 = (float)geoPos2.getLon();
        float lat1 = (float)geoPos1.getLat();
        float lat2 = (float)geoPos2.getLat();
        double cosLat1 = Math.cos(Math.PI / 180 * (double)lat1);
        double cosLat2 = Math.cos(Math.PI / 180 * (double)lat2);
        double sinLat1 = Math.sin(Math.PI / 180 * (double)lat1);
        double sinLat2 = Math.sin(Math.PI / 180 * (double)lat2);
        double delta = Math.PI / 180 * (double)(lon2 - lon1);
        double cosDelta = Math.cos(delta);
        double sinDelta = Math.sin(delta);
        double y = Math.sqrt(Math.pow(cosLat2 * sinDelta, 2.0) + Math.pow(cosLat1 * sinLat2 - sinLat1 * cosLat2 * cosDelta, 2.0));
        double x = sinLat1 * sinLat2 + cosLat1 * cosLat2 * cosDelta;
        double ad = Math.atan2(y, x);
        return ad * 6372000.0;
    }
}

