/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.viirs;

import java.awt.Color;
import java.util.Random;
import org.esa.s3tbx.idepix.core.IdepixFlagCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.BitSetter;

public class ViirsUtils {
    public static FlagCoding createViirsFlagCoding(String flagId) {
        FlagCoding flagCoding = IdepixFlagCoding.createDefaultFlagCoding(flagId);
        flagCoding.addFlag("IDEPIX_MIXED_PIXEL", BitSetter.setFlag((int)0, (int)12), "Mixed pixel");
        return flagCoding;
    }

    public static void setupViirsClassifBitmask(Product classifProduct) {
        int index = IdepixFlagCoding.setupDefaultClassifBitmask(classifProduct);
        int w = classifProduct.getSceneRasterWidth();
        int h = classifProduct.getSceneRasterHeight();
        Random r = new Random();
        Mask mask = Mask.BandMathsType.create((String)"IDEPIX_MIXED_PIXEL", (String)"Mixed pixel", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_MIXED_PIXEL", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index, (ProductNode)mask);
    }
}

