/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.viirs;

import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.viirs.ViirsClassificationOp;
import org.esa.s3tbx.idepix.algorithms.viirs.ViirsPostProcessOp;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.SuomiNpp.Viirs", category="Optical/Pre-Processing", version="2.2", authors="Olaf Danne, Marco Zuehlke", copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for VIIRS.")
public class ViirsOp
extends Operator {
    @Parameter(defaultValue="false", label=" Write TOA reflectances to the target product", description="Write TOA reflectances to the target product.")
    private boolean outputViirsRhoToa = false;
    private boolean outputDebug = false;
    @Parameter(defaultValue="1", label=" Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="50", valueSet={"50", "150"}, label=" Resolution of used land-water mask in m/pixel", description="Resolution in m/pixel")
    private int waterMaskResolution;
    @SourceProduct(alias="sourceProduct", label="Name (VIIRS L1b product)", description="The source product.")
    private Product sourceProduct;
    private Product classifProduct;
    private Product waterMaskProduct;
    private Map<String, Object> classificationParameters;

    public void initialize() throws OperatorException {
        boolean inputProductIsValid = IdepixIO.validateInputProduct(this.sourceProduct, AlgorithmSelector.VIIRS);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.processViirs(this.createViirsClassificationParameters());
    }

    private void processViirs(Map<String, Object> viirsClassificationParameters) {
        HashMap<String, Product> viirsClassifInput = new HashMap<String, Product>(4);
        this.computeAlgorithmInputProducts(viirsClassifInput);
        HashMap<String, Integer> postProcessParameters = new HashMap<String, Integer>();
        postProcessParameters.put("cloudBufferWidth", this.cloudBufferWidth);
        HashMap<String, Product> postProcessInput = new HashMap<String, Product>();
        postProcessInput.put("waterMask", this.waterMaskProduct);
        postProcessInput.put("refl", this.sourceProduct);
        this.classifProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(ViirsClassificationOp.class), viirsClassificationParameters, viirsClassifInput);
        postProcessInput.put("classif", this.classifProduct);
        Product postProcessProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(ViirsPostProcessOp.class), postProcessParameters, postProcessInput);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)postProcessProduct);
        this.setTargetProduct(postProcessProduct);
        this.addBandsToTargetProduct(postProcessProduct);
    }

    private void computeAlgorithmInputProducts(Map<String, Product> viirsClassifInput) {
        this.createWaterMaskProduct();
        viirsClassifInput.put("waterMask", this.waterMaskProduct);
        viirsClassifInput.put("refl", this.sourceProduct);
    }

    private void createWaterMaskProduct() {
        HashMap<String, Integer> waterParameters = new HashMap<String, Integer>();
        waterParameters.put("resolution", this.waterMaskResolution);
        waterParameters.put("subSamplingFactorX", 3);
        waterParameters.put("subSamplingFactorY", 3);
        this.waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterParameters, (Product)this.sourceProduct);
    }

    private Map<String, Object> createViirsClassificationParameters() {
        HashMap<String, Object> viirsCloudClassificationParameters = new HashMap<String, Object>(1);
        viirsCloudClassificationParameters.put("cloudBufferWidth", this.cloudBufferWidth);
        viirsCloudClassificationParameters.put("waterMaskResolution", this.waterMaskResolution);
        viirsCloudClassificationParameters.put("outputDebug", this.outputDebug);
        return viirsCloudClassificationParameters;
    }

    private void addBandsToTargetProduct(Product targetProduct) {
        if (this.outputViirsRhoToa) {
            ViirsOp.copySourceBands(this.sourceProduct, targetProduct, "rhot");
        }
        if (this.outputDebug) {
            ViirsOp.copySourceBands(this.classifProduct, targetProduct, "_value");
        }
    }

    private static void copySourceBands(Product rad2reflProduct, Product targetProduct, String bandNameSubstring) {
        for (String bandname : rad2reflProduct.getBandNames()) {
            if (!bandname.contains(bandNameSubstring) || targetProduct.containsBand(bandname)) continue;
            ProductUtils.copyBand((String)bandname, (Product)rad2reflProduct, (Product)targetProduct, (boolean)true);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ViirsOp.class);
        }
    }
}

