/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.vgt;

import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.vgt.VgtClassificationOp;
import org.esa.s3tbx.idepix.algorithms.vgt.VgtPostProcessOp;
import org.esa.s3tbx.idepix.algorithms.vgt.VgtUtils;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.operators.BasisOp;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.Spot.Vegetation", category="Optical/Pre-Processing", version="1.0", authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for SPOT-VGT.")
public class VgtOp
extends BasisOp {
    @Parameter(defaultValue="true", label=" Write TOA reflectances to the target product", description=" Write TOA reflectances to the target product")
    boolean copyToaReflectances = true;
    @Parameter(defaultValue="false", label=" Write input annotation bands to the target product", description=" Write input annotation bands to the target product")
    boolean copyAnnotations;
    @Parameter(defaultValue="false", label=" Write feature values to the target product", description=" Write all feature values to the target product")
    boolean copyFeatureValues = false;
    @Parameter(defaultValue="false", label=" Write NN value to the target product.", description=" If applied, write NN value to the target product ")
    private boolean outputSchillerNNValue;
    @Parameter(defaultValue="1.1", label=" NN cloud ambiguous lower boundary", description=" NN cloud ambiguous lower boundary")
    private double nnCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="2.7", label=" NN cloud ambiguous/sure separation value", description=" NN cloud ambiguous cloud ambiguous/sure separation value")
    private double nnCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.6", label=" NN cloud sure/snow separation value", description=" NN cloud ambiguous cloud sure/snow separation value")
    private double nnCloudSureSnowSeparationValue;
    @Parameter(defaultValue="true", label=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    @Parameter(defaultValue="2", interval="[0,100]", description="The width of a cloud 'safety buffer' around a pixel which was classified as cloudy.", label="Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="50", valueSet={"50", "150"}, label=" Resolution of used land-water mask in m/pixel", description="Resolution of the used SRTM land-water mask in m/pixel")
    private int wmResolution;
    @Parameter(defaultValue="false", label=" Use land-water flag from L1b product instead", description="Use land-water flag from L1b product instead of SRTM mask")
    private boolean useL1bLandWaterFlag;
    @SourceProduct(alias="sourceProduct", label="L1b product", description="The SPOT-VGT L1b product.")
    private Product sourceProduct;
    @TargetProduct(description="The target product.")
    private Product targetProduct;
    private Product cloudProduct;
    private Product postProcessingProduct;

    public void initialize() throws OperatorException {
        boolean inputProductIsValid = IdepixIO.validateInputProduct(this.sourceProduct, AlgorithmSelector.VGT);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.processGlobAlbedoVgt();
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        VgtUtils.setupVgtBitmasks(this.targetProduct);
    }

    private void processGlobAlbedoVgt() {
        HashMap<String, Integer> waterMaskParameters = new HashMap<String, Integer>();
        waterMaskParameters.put("resolution", 50);
        waterMaskParameters.put("subSamplingFactorX", 3);
        waterMaskParameters.put("subSamplingFactorY", 3);
        Product waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterMaskParameters, (Product)this.sourceProduct);
        HashMap<String, Product> classificationInputProducts = new HashMap<String, Product>(4);
        classificationInputProducts.put("l1b", this.sourceProduct);
        classificationInputProducts.put("waterMask", waterMaskProduct);
        Map<String, Object> cloudClassificationParameters = this.createVgtCloudClassificationParameters();
        this.cloudProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(VgtClassificationOp.class), cloudClassificationParameters, classificationInputProducts);
        this.computeVgtPostProcessProduct();
        this.targetProduct = IdepixIO.cloneProduct(this.cloudProduct, true);
        Band cloudFlagBand = this.targetProduct.getBand("pixel_classif_flags");
        cloudFlagBand.setSourceImage(this.postProcessingProduct.getBand("pixel_classif_flags").getSourceImage());
    }

    private Map<String, Object> createVgtCloudClassificationParameters() {
        HashMap<String, Object> cloudClassificationParameters = new HashMap<String, Object>(1);
        cloudClassificationParameters.put("copyToaReflectances", this.copyToaReflectances);
        cloudClassificationParameters.put("copyAnnotations", this.copyAnnotations);
        cloudClassificationParameters.put("copyFeatureValues", this.copyFeatureValues);
        cloudClassificationParameters.put("outputSchillerNNValue", this.outputSchillerNNValue);
        cloudClassificationParameters.put("useL1bLandWaterFlag", this.useL1bLandWaterFlag);
        cloudClassificationParameters.put("nnCloudAmbiguousLowerBoundaryValue", this.nnCloudAmbiguousLowerBoundaryValue);
        cloudClassificationParameters.put("nnCloudAmbiguousSureSeparationValue", this.nnCloudAmbiguousSureSeparationValue);
        cloudClassificationParameters.put("nnCloudSureSnowSeparationValue", this.nnCloudSureSnowSeparationValue);
        return cloudClassificationParameters;
    }

    private void computeVgtPostProcessProduct() {
        HashMap<String, Product> input = new HashMap<String, Product>();
        input.put("l1b", this.sourceProduct);
        input.put("vgtCloud", this.cloudProduct);
        HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>();
        params.put("computeCloudBuffer", Boolean.valueOf(this.computeCloudBuffer));
        params.put("cloudBufferWidth", Integer.valueOf(this.cloudBufferWidth));
        this.postProcessingProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(VgtPostProcessOp.class), params, input);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(VgtOp.class);
        }
    }
}

