/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.seawifs;

import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.seawifs.SeaWifsClassificationOp;
import org.esa.s3tbx.idepix.algorithms.seawifs.SeaWifsPostProcessOp;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.operators.BasisOp;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.OrbView2.Seawifs", category="Optical/Pre-Processing", version="2.2", authors="Olaf Danne, Marco Zuehlke", copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for SeaWiFS.")
public class SeaWifsOp
extends BasisOp {
    @Parameter(defaultValue="true", label=" Write TOA radiances/reflectance bands to target product", description="Write TOA radiances/reflectance bands to target product.")
    private boolean outputRadRefl = true;
    @Parameter(defaultValue="1", label=" Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="50", valueSet={"50", "150"}, label=" Resolution of used land-water mask in m/pixel", description="Resolution in m/pixel")
    private int waterMaskResolution;
    @SourceProduct(alias="sourceProduct", label="Name (SeaWiFS L1b product)", description="The source product.")
    private Product sourceProduct;
    private Product waterMaskProduct;
    private Product classifProduct;
    private Map<String, Object> waterClassificationParameters;
    private String radianceBandPrefix;

    public void initialize() throws OperatorException {
        boolean inputProductIsValid = IdepixIO.validateInputProduct(this.sourceProduct, AlgorithmSelector.SEAWIFS);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.radianceBandPrefix = this.sourceProduct.getName().endsWith(".L1C") ? "rhot_" : "Lt_";
        this.processSeawifs(this.createSeawifsClassificationParameters());
    }

    private void processSeawifs(Map<String, Object> seawifsClassificationParameters) {
        HashMap<String, Product> seawifsClassifInput = new HashMap<String, Product>(4);
        this.computeAlgorithmInputProducts(seawifsClassifInput);
        HashMap<String, Integer> postProcessParameters = new HashMap<String, Integer>();
        postProcessParameters.put("cloudBufferWidth", this.cloudBufferWidth);
        HashMap<String, Product> postProcessInput = new HashMap<String, Product>();
        postProcessInput.put("waterMask", this.waterMaskProduct);
        postProcessInput.put("refl", this.sourceProduct);
        this.classifProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(SeaWifsClassificationOp.class), seawifsClassificationParameters, seawifsClassifInput);
        postProcessInput.put("classif", this.classifProduct);
        Product postProcessProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(SeaWifsPostProcessOp.class), postProcessParameters, postProcessInput);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)postProcessProduct);
        this.setTargetProduct(postProcessProduct);
        this.addBandsToTargetProduct(postProcessProduct);
    }

    private void computeAlgorithmInputProducts(Map<String, Product> occciClassifInput) {
        this.createWaterMaskProduct();
        occciClassifInput.put("waterMask", this.waterMaskProduct);
        occciClassifInput.put("refl", this.sourceProduct);
    }

    private void createWaterMaskProduct() {
        HashMap<String, Integer> waterParameters = new HashMap<String, Integer>();
        waterParameters.put("resolution", this.waterMaskResolution);
        waterParameters.put("subSamplingFactorX", 3);
        waterParameters.put("subSamplingFactorY", 3);
        this.waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterParameters, (Product)this.sourceProduct);
    }

    private Map<String, Object> createSeawifsClassificationParameters() {
        HashMap<String, Object> seawifsClassificationParameters = new HashMap<String, Object>(1);
        seawifsClassificationParameters.put("cloudBufferWidth", this.cloudBufferWidth);
        seawifsClassificationParameters.put("wmResolution", this.waterMaskResolution);
        seawifsClassificationParameters.put("radianceBandPrefix", this.radianceBandPrefix);
        return seawifsClassificationParameters;
    }

    private void addBandsToTargetProduct(Product targetProduct) {
        if (this.outputRadRefl) {
            IdepixIO.copySourceBands(this.sourceProduct, targetProduct, this.radianceBandPrefix);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SeaWifsOp.class);
        }
    }
}

