/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.seawifs;

import java.io.IOException;
import java.io.InputStream;
import org.esa.s3tbx.idepix.algorithms.seawifs.SeaWifsAlgorithm;
import org.esa.s3tbx.idepix.algorithms.seawifs.SeaWifsConstants;
import org.esa.s3tbx.idepix.algorithms.seawifs.SeaWifsUtils;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;

@OperatorMetadata(alias="Idepix.SeaWifs.Classification", version="2.2", copyright="(c) 2016 by Brockmann Consult", description="SeaWiFS pixel classification operator.", internal=true)
public class SeaWifsClassificationOp
extends PixelOperator {
    @Parameter(defaultValue="L_", valueSet={"L_", "Lt_", "rhot_"}, label=" Prefix of input spectral bands.", description="Prefix of input radiance or reflectance bands")
    private String radianceBandPrefix;
    @Parameter(defaultValue="1", label=" Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="50", valueSet={"50", "150"}, label=" Resolution of used land-water mask in m/pixel", description="Resolution in m/pixel")
    private int waterMaskResolution;
    @SourceProduct(alias="refl", description="MODIS L1b reflectance product")
    private Product reflProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    public static final String SEAWIFS_NET_NAME = "6x3_166.0.net";
    private static final int earthSunDistance = 1;
    private static final double[] nasaSolarFluxes = new double[]{1735.518167, 1858.404314, 1981.076667, 1881.566829, 1874.005, 1537.254783, 1230.04, 957.6122143};
    ThreadLocal<SchillerNeuralNetWrapper> seawifsNeuralNet;

    public Product getSourceProduct() {
        return this.reflProduct;
    }

    protected void prepareInputs() throws OperatorException {
        this.readSchillerNets();
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        SeaWifsAlgorithm algorithm = this.createSeawifsAlgorithm(x, y, sourceSamples, targetSamples);
        this.setClassifFlag(targetSamples, algorithm);
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "solz", this.getSourceProduct());
        sampleConfigurer.defineSample(1, "sola", this.getSourceProduct());
        sampleConfigurer.defineSample(2, "senz", this.getSourceProduct());
        sampleConfigurer.defineSample(3, "sena", this.getSourceProduct());
        for (int i = 0; i < SeaWifsConstants.SEAWIFS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            sampleConfigurer.defineSample(8 + i, this.radianceBandPrefix + SeaWifsConstants.SEAWIFS_L1B_SPECTRAL_BAND_NAMES[i], this.getSourceProduct());
        }
        int index = 8 + SeaWifsConstants.SEAWIFS_L1B_NUM_SPECTRAL_BANDS + 1;
        sampleConfigurer.defineSample(index, "land_water_fraction", this.waterMaskProduct);
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "pixel_classif_flags");
        sampleConfigurer.defineSample(1, "nn_value");
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        productConfigurer.copyTimeCoding();
        productConfigurer.copyTiePointGrids(new String[0]);
        Band classifFlagBand = productConfigurer.addBand("pixel_classif_flags", 11);
        classifFlagBand.setDescription("Pixel classification flag");
        classifFlagBand.setUnit("dl");
        FlagCoding flagCoding = SeaWifsUtils.createSeawifsFlagCoding("pixel_classif_flags");
        classifFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.getTargetProduct().getFlagCodingGroup().add((ProductNode)flagCoding);
        this.getTargetProduct().setSceneGeoCoding(this.reflProduct.getSceneGeoCoding());
        SeaWifsUtils.setupSeawifsClassifBitmask(this.getTargetProduct());
        Band nnValueBand = productConfigurer.addBand("nn_value", 30);
        nnValueBand.setDescription("NN output value");
        nnValueBand.setUnit("dl");
    }

    private void readSchillerNets() {
        try (InputStream isSW = ((Object)((Object)this)).getClass().getResourceAsStream(SEAWIFS_NET_NAME);){
            this.seawifsNeuralNet = SchillerNeuralNetWrapper.create(isSW);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot read Schiller neural nets: " + e.getMessage());
        }
    }

    private void setClassifFlag(WritableSample[] targetSamples, SeaWifsAlgorithm algorithm) {
        targetSamples[0].set(0, algorithm.isInvalid());
        targetSamples[0].set(1, algorithm.isCloud());
        targetSamples[0].set(2, algorithm.isCloudAmbiguous());
        targetSamples[0].set(3, algorithm.isCloudSure());
        targetSamples[0].set(4, algorithm.isCloudBuffer());
        targetSamples[0].set(5, algorithm.isCloudShadow());
        targetSamples[0].set(6, algorithm.isSnowIce());
        targetSamples[0].set(12, algorithm.isMixedPixel());
        targetSamples[0].set(9, algorithm.isCoastline());
        targetSamples[0].set(10, algorithm.isLand());
        targetSamples[0].set(7, algorithm.isBright());
    }

    private SeaWifsAlgorithm createSeawifsAlgorithm(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        double[] reflectance = new double[SeaWifsConstants.SEAWIFS_L1B_NUM_SPECTRAL_BANDS];
        float waterFraction = Float.NaN;
        SeaWifsAlgorithm occciAlgorithm = new SeaWifsAlgorithm();
        double[] seawifsNeuralNetInput = this.seawifsNeuralNet.get().getInputVector();
        for (int i = 0; i < SeaWifsConstants.SEAWIFS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            reflectance[i] = sourceSamples[8 + i].getFloat();
            if (!this.radianceBandPrefix.equals("rhot_")) {
                this.scaleInputSpectralDataToReflectance(reflectance, 0);
            }
            seawifsNeuralNetInput[i] = Math.sqrt(reflectance[i]);
        }
        occciAlgorithm.setRefl(reflectance);
        if (this.getGeoPos((int)x, (int)y).lat > -58.0) {
            waterFraction = sourceSamples[8 + SeaWifsConstants.SEAWIFS_L1B_NUM_SPECTRAL_BANDS + 1].getFloat();
        }
        occciAlgorithm.setWaterFraction(waterFraction);
        double[] neuralNetOutput = this.seawifsNeuralNet.get().getNeuralNet().calc(seawifsNeuralNetInput);
        occciAlgorithm.setNnOutput(neuralNetOutput);
        targetSamples[1].set(neuralNetOutput[0]);
        return occciAlgorithm;
    }

    private void scaleInputSpectralDataToReflectance(double[] inputs, int offset) {
        this.scaleInputSpectralDataToRadiance(inputs, offset);
        double oneDivEarthSunDistanceSquare = 1.0;
        for (int i = 0; i < SeaWifsConstants.SEAWIFS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            int index = offset + i;
            inputs[index] = inputs[index] * Math.PI / (nasaSolarFluxes[i] * 1.0);
        }
    }

    public void scaleInputSpectralDataToRadiance(double[] inputs, int offset) {
        for (int i = 0; i < SeaWifsConstants.SEAWIFS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            int index;
            int n = index = offset + i;
            inputs[n] = inputs[n] * 10.0;
        }
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        GeoCoding geoCoding = this.reflProduct.getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SeaWifsClassificationOp.class);
        }
    }
}

