/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.probav;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.idepix.core.operators.CloudBuffer;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;

@OperatorMetadata(alias="Idepix.Probav.Postprocess", version="1.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Refines the Proba-V pixel classification over both land and water.")
public class ProbaVPostProcessOp
extends Operator {
    @Parameter(defaultValue="true", label=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    @Parameter(defaultValue="2", interval="[0,100]", label=" Width of cloud buffer (# of pixels)", description=" The width of the 'safety buffer' around a pixel identified as cloudy.")
    private int cloudBufferWidth;
    @SourceProduct(alias="l1b")
    private Product l1bProduct;
    @SourceProduct(alias="probavCloud")
    private Product probavCloudProduct;
    private Band origCloudFlagBand;
    private Band origSmFlagBand;
    private RectangleExtender rectCalculator;

    public void initialize() throws OperatorException {
        Product postProcessedCloudProduct = this.createTargetProduct(this.probavCloudProduct, "postProcessedCloud", "postProcessedCloud");
        this.origCloudFlagBand = this.probavCloudProduct.getBand("pixel_classif_flags");
        this.origSmFlagBand = this.l1bProduct.getBand("SM_FLAGS");
        if (this.computeCloudBuffer) {
            this.rectCalculator = new RectangleExtender(new Rectangle(this.l1bProduct.getSceneRasterWidth(), this.l1bProduct.getSceneRasterHeight()), this.cloudBufferWidth, this.cloudBufferWidth);
        }
        ProductUtils.copyBand((String)"pixel_classif_flags", (Product)this.probavCloudProduct, (Product)postProcessedCloudProduct, (boolean)false);
        this.setTargetProduct(postProcessedCloudProduct);
    }

    private Product createTargetProduct(Product sourceProduct, String name, String type) {
        int sceneWidth = sourceProduct.getSceneRasterWidth();
        int sceneHeight = sourceProduct.getSceneRasterHeight();
        Product targetProduct = new Product(name, type, sceneWidth, sceneHeight);
        ProductUtils.copyGeoCoding((Product)sourceProduct, (Product)targetProduct);
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
        return targetProduct;
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        int x;
        int y;
        Rectangle targetRectangle = targetTile.getRectangle();
        Rectangle extendedRectangle = null;
        if (this.computeCloudBuffer) {
            extendedRectangle = this.rectCalculator.extend(targetRectangle);
        }
        Tile cloudFlagTile = this.getSourceTile((RasterDataNode)this.origCloudFlagBand, targetRectangle);
        Tile smFlagTile = this.getSourceTile((RasterDataNode)this.origSmFlagBand, targetRectangle);
        for (y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
            this.checkForCancellation();
            for (x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                boolean isInvalid = targetTile.getSampleBit(x, y, 0);
                if (isInvalid) continue;
                this.combineFlags(x, y, cloudFlagTile, targetTile);
                this.consolidateFlagging(x, y, smFlagTile, targetTile);
                this.setCloudShadow(x, y, smFlagTile, targetTile);
            }
        }
        if (this.computeCloudBuffer) {
            for (y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                this.checkForCancellation();
                for (x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    boolean isCloud = targetTile.getSampleBit(x, y, 1);
                    if (!isCloud) continue;
                    CloudBuffer.computeSimpleCloudBuffer(x, y, targetTile, extendedRectangle, this.cloudBufferWidth, 4);
                }
            }
            for (y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                this.checkForCancellation();
                for (x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    IdepixUtils.consolidateCloudAndBuffer(targetTile, x, y);
                }
            }
        }
    }

    private void setCloudShadow(int x, int y, Tile smFlagTile, Tile targetTile) {
        boolean smCloudShadow = smFlagTile.getSampleBit(x, y, 4);
        boolean safeCloudFinal = targetTile.getSampleBit(x, y, 1);
        boolean isLand = targetTile.getSampleBit(x, y, 10);
        boolean isCloudShadow = smCloudShadow && !safeCloudFinal && isLand;
        targetTile.setSample(x, y, 5, isCloudShadow);
    }

    private void combineFlags(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        int sourceFlags = sourceFlagTile.getSampleInt(x, y);
        int computedFlags = targetTile.getSampleInt(x, y);
        targetTile.setSample(x, y, sourceFlags | computedFlags);
    }

    private void consolidateFlagging(int x, int y, Tile smFlagTile, Tile targetTile) {
        boolean smClear = smFlagTile.getSampleBit(x, y, 0);
        boolean idepixLand = targetTile.getSampleBit(x, y, 10);
        boolean idepixClearLand = targetTile.getSampleBit(x, y, 13);
        boolean idepixWater = targetTile.getSampleBit(x, y, 12);
        boolean idepixClearWater = targetTile.getSampleBit(x, y, 14);
        boolean idepixClearSnow = targetTile.getSampleBit(x, y, 6);
        boolean idepixCloud = targetTile.getSampleBit(x, y, 1);
        boolean safeClearLand = smClear && idepixLand && idepixClearLand && !idepixClearSnow;
        boolean safeClearWater = smClear && idepixWater && idepixClearWater && !idepixClearSnow;
        boolean potentialCloudSnow = !safeClearLand && idepixLand;
        boolean safeSnowIce = potentialCloudSnow && idepixClearSnow;
        boolean smCloud = smFlagTile.getSampleBit(x, y, 2);
        boolean safeCloud = idepixCloud || potentialCloudSnow && !safeSnowIce && !safeClearWater;
        boolean safeClearWaterFinal = !safeClearLand && !safeSnowIce && !safeCloud && !smCloud && idepixWater || safeClearWater;
        boolean safeClearLandFinal = !safeSnowIce && !idepixCloud && !smCloud && !safeClearWaterFinal && idepixLand || safeClearLand;
        boolean safeCloudFinal = safeCloud && !safeClearLandFinal && !safeClearWaterFinal;
        targetTile.setSample(x, y, 13, safeClearLandFinal);
        targetTile.setSample(x, y, 14, safeClearWaterFinal);
        targetTile.setSample(x, y, 1, safeCloudFinal);
        targetTile.setSample(x, y, 6, safeSnowIce);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ProbaVPostProcessOp.class);
        }
    }
}

