/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.probav;

import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.probav.ProbaVClassificationOp;
import org.esa.s3tbx.idepix.algorithms.probav.ProbaVPostProcessOp;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.operators.BasisOp;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;

@OperatorMetadata(alias="Idepix.Probav.Vegetation", category="Optical/Pre-Processing", version="2.2", authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for PROBA-V.")
public class ProbaVOp
extends BasisOp {
    @Parameter(defaultValue="false", label=" Write TOA reflectances to the target product", description=" Write TOA reflectances to the target product")
    private boolean copyToaReflectances = false;
    @Parameter(defaultValue="false", label=" Write input annotation bands to the target product", description=" Write input annotation bands to the target product")
    private boolean copyAnnotations;
    @Parameter(defaultValue="false", label=" Write feature values to the target product", description=" Write all feature values to the target product")
    private boolean copyFeatureValues = false;
    @Parameter(defaultValue="false", label=" Apply NN for cloud classification", description=" Apply NN for cloud classification")
    private boolean applySchillerNN;
    @Parameter(defaultValue="1.1", label=" NN cloud ambiguous lower boundary", description=" NN cloud ambiguous lower boundary")
    private double schillerNNCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="2.7", label=" NN cloud ambiguous/sure separation value", description=" NN cloud ambiguous cloud ambiguous/sure separation value")
    private double schillerNNCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.6", label=" NN cloud sure/snow separation value", description=" NN cloud ambiguous cloud sure/snow separation value")
    private double schillerNNCloudSureSnowSeparationValue;
    @Parameter(defaultValue="true", label=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    @Parameter(defaultValue="2", interval="[0,100]", label=" Width of cloud buffer (# of pixels)", description=" The width of the 'safety buffer' around a pixel identified as cloudy.")
    private int cloudBufferWidth;
    @Parameter(defaultValue="false", label=" Use land-water flag from L1b product instead of SRTM mask", description="Use land-water flag from L1b product instead of SRTM mask")
    private boolean useL1bLandWaterFlag;
    @SourceProduct(alias="sourceProduct", label="Proba-V L1b product", description="The Proba-V L1b source product.")
    private Product sourceProduct;
    private Product cloudProduct;
    private Product postProcessingProduct;

    public void initialize() throws OperatorException {
        boolean inputProductIsValid = IdepixIO.validateInputProduct(this.sourceProduct, AlgorithmSelector.PROBAV);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.processProbav();
    }

    private void processProbav() {
        HashMap<String, Integer> waterMaskParameters = new HashMap<String, Integer>();
        waterMaskParameters.put("resolution", 50);
        waterMaskParameters.put("subSamplingFactorX", 3);
        waterMaskParameters.put("subSamplingFactorY", 3);
        Product waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterMaskParameters, (Product)this.sourceProduct);
        HashMap<String, Product> cloudInput = new HashMap<String, Product>(4);
        cloudInput.put("l1b", this.sourceProduct);
        cloudInput.put("waterMask", waterMaskProduct);
        Map<String, Object> cloudClassificationParameters = this.createCloudClassificationParameters();
        this.cloudProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(ProbaVClassificationOp.class), cloudClassificationParameters, cloudInput);
        this.computePostProcessProduct();
        Product targetProduct = IdepixIO.cloneProduct(this.cloudProduct, true);
        Band cloudFlagBand = targetProduct.getBand("pixel_classif_flags");
        cloudFlagBand.setSourceImage(this.postProcessingProduct.getBand("pixel_classif_flags").getSourceImage());
        this.setTargetProduct(targetProduct);
    }

    private void computePostProcessProduct() {
        HashMap<String, Product> input = new HashMap<String, Product>();
        input.put("l1b", this.sourceProduct);
        input.put("probavCloud", this.cloudProduct);
        HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>();
        params.put("computeCloudBuffer", Boolean.valueOf(this.computeCloudBuffer));
        params.put("cloudBufferWidth", Integer.valueOf(this.cloudBufferWidth));
        this.postProcessingProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(ProbaVPostProcessOp.class), params, input);
    }

    private Map<String, Object> createCloudClassificationParameters() {
        HashMap<String, Object> cloudClassificationParameters = new HashMap<String, Object>(1);
        cloudClassificationParameters.put("copyToaReflectances", this.copyToaReflectances);
        cloudClassificationParameters.put("copyFeatureValues", this.copyFeatureValues);
        cloudClassificationParameters.put("useL1bLandWaterFlag", this.useL1bLandWaterFlag);
        cloudClassificationParameters.put("copyAnnotations", this.copyAnnotations);
        cloudClassificationParameters.put("applySchillerNN", this.applySchillerNN);
        cloudClassificationParameters.put("schillerNNCloudAmbiguousLowerBoundaryValue", this.schillerNNCloudAmbiguousLowerBoundaryValue);
        cloudClassificationParameters.put("schillerNNCloudAmbiguousSureSeparationValue", this.schillerNNCloudAmbiguousSureSeparationValue);
        cloudClassificationParameters.put("schillerNNCloudSureSnowSeparationValue", this.schillerNNCloudSureSnowSeparationValue);
        return cloudClassificationParameters;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ProbaVOp.class);
        }
    }
}

