/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.probav;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.probav.ProbaVAlgorithm;
import org.esa.s3tbx.idepix.algorithms.probav.ProbaVUtils;
import org.esa.s3tbx.idepix.core.IdepixConstants;
import org.esa.s3tbx.idepix.core.pixel.AbstractPixelProperties;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.Probav.Classification", version="1.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Idepix land pixel classification operator for Proba-V.")
public class ProbaVClassificationOp
extends Operator {
    @Parameter(defaultValue="false", label=" Write TOA Reflectances to the target product", description=" Write TOA Reflectances to the target product")
    private boolean copyToaReflectances = false;
    @Parameter(defaultValue="false", label=" Write Feature Values to the target product", description=" Write all Feature Values to the target product")
    private boolean copyFeatureValues = false;
    @Parameter(defaultValue="false", label=" Write input annotation bands to the target product", description=" Write input annotation bands to the target product")
    private boolean copyAnnotations;
    @Parameter(defaultValue="false", label=" Apply NN for cloud classification", description=" Apply NN for cloud classification")
    private boolean applySchillerNN;
    @Parameter(defaultValue="1.1", label=" NN cloud ambiguous lower boundary", description=" NN cloud ambiguous lower boundary")
    private double schillerNNCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="2.7", label=" NN cloud ambiguous/sure separation value", description=" NN cloud ambiguous cloud ambiguous/sure separation value")
    private double schillerNNCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.6", label=" NN cloud sure/snow separation value", description=" NN cloud ambiguous cloud sure/snow separation value")
    private double schillerNNCloudSureSnowSeparationValue;
    @Parameter(defaultValue="false", label=" Use land-water flag from L1b product instead", description="Use land-water flag from L1b product instead of SRTM mask")
    private boolean useL1bLandWaterFlag;
    @SourceProduct(alias="l1b", description="The source product.")
    Product sourceProduct;
    @TargetProduct(description="The target product.")
    Product targetProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    private Band[] probavReflectanceBands;
    private Band landWaterBand;
    protected static final int SM_F_CLEAR = 0;
    protected static final int SM_F_CLOUD = 2;
    protected static final int SM_F_CLOUDSHADOW = 4;
    protected static final int SM_F_LAND = 5;
    protected static final int SM_F_SWIR_GOOD = 6;
    protected static final int SM_F_NIR_GOOD = 7;
    protected static final int SM_F_RED_GOOD = 8;
    protected static final int SM_F_BLUE_GOOD = 9;
    static final byte WATERMASK_FRACTION_THRESH = 23;
    ElevationModel getasseElevationModel;
    Band cloudFlagBand;
    Band temperatureBand;
    Band brightBand;
    Band whiteBand;
    Band brightWhiteBand;
    Band spectralFlatnessBand;
    Band ndviBand;
    Band ndsiBand;
    Band glintRiskBand;
    Band radioLandBand;
    Band radioWaterBand;
    public static final String VGT_NET_NAME = "3x2x2_341.8.net";
    ThreadLocal<SchillerNeuralNetWrapper> vgtNeuralNet;

    public void initialize() throws OperatorException {
        this.setBands();
        this.readSchillerNeuralNets();
        this.createTargetProduct();
        this.extendTargetProduct();
        String demName = "GETASSE30";
        ElevationModelDescriptor demDescriptor = ElevationModelRegistry.getInstance().getDescriptor("GETASSE30");
        if (demDescriptor == null || !demDescriptor.canBeDownloaded()) {
            throw new OperatorException("DEM not installed: GETASSE30. Please install with Module Manager.");
        }
        this.getasseElevationModel = demDescriptor.createDem(Resampling.BILINEAR_INTERPOLATION);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        Band smFlagBand = this.sourceProduct.getBand("SM_FLAGS");
        Tile smFlagTile = this.getSourceTile((RasterDataNode)smFlagBand, rectangle);
        Tile waterFractionTile = this.getSourceTile((RasterDataNode)this.landWaterBand, rectangle);
        Tile[] probavReflectanceTiles = new Tile[IdepixConstants.PROBAV_REFLECTANCE_BAND_NAMES.length];
        float[] probavReflectance = new float[IdepixConstants.PROBAV_REFLECTANCE_BAND_NAMES.length];
        for (int i = 0; i < IdepixConstants.PROBAV_REFLECTANCE_BAND_NAMES.length; ++i) {
            probavReflectanceTiles[i] = this.getSourceTile((RasterDataNode)this.probavReflectanceBands[i], rectangle);
        }
        Band cloudFlagTargetBand = this.targetProduct.getBand("pixel_classif_flags");
        Tile cloudFlagTargetTile = targetTiles.get(cloudFlagTargetBand);
        Band nnTargetBand = this.targetProduct.getBand("probav_nn_value");
        Tile nnTargetTile = targetTiles.get(nnTargetBand);
        try {
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                this.checkForCancellation();
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    byte waterMaskFraction = 127;
                    if (!this.useL1bLandWaterFlag) {
                        waterMaskFraction = (byte)waterFractionTile.getSampleInt(x, y);
                    }
                    ProbaVAlgorithm probaVAlgorithm = this.createProbavAlgorithm(smFlagTile, probavReflectanceTiles, probavReflectance, waterMaskFraction, y, x);
                    this.setCloudFlag(cloudFlagTargetTile, y, x, probaVAlgorithm);
                    double[] nnOutput = probaVAlgorithm.getNnOutput();
                    if (this.applySchillerNN) {
                        if (!cloudFlagTargetTile.getSampleBit(x, y, 0)) {
                            cloudFlagTargetTile.setSample(x, y, 2, false);
                            cloudFlagTargetTile.setSample(x, y, 3, false);
                            cloudFlagTargetTile.setSample(x, y, 1, false);
                            cloudFlagTargetTile.setSample(x, y, 6, false);
                            if (nnOutput[0] > this.schillerNNCloudAmbiguousLowerBoundaryValue && nnOutput[0] <= this.schillerNNCloudAmbiguousSureSeparationValue) {
                                cloudFlagTargetTile.setSample(x, y, 2, true);
                                cloudFlagTargetTile.setSample(x, y, 1, true);
                            }
                            if (nnOutput[0] > this.schillerNNCloudAmbiguousSureSeparationValue && nnOutput[0] <= this.schillerNNCloudSureSnowSeparationValue) {
                                cloudFlagTargetTile.setSample(x, y, 3, true);
                                cloudFlagTargetTile.setSample(x, y, 1, true);
                            }
                            if (nnOutput[0] > this.schillerNNCloudSureSnowSeparationValue) {
                                cloudFlagTargetTile.setSample(x, y, 6, true);
                            }
                        }
                        nnTargetTile.setSample(x, y, nnOutput[0]);
                    }
                    for (Band band : this.targetProduct.getBands()) {
                        Tile targetTile = targetTiles.get(band);
                        this.setPixelSamples(band, targetTile, y, x, probaVAlgorithm);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException("Failed to provide Proba-V cloud screening:\n" + e.getMessage(), (Throwable)e);
        }
    }

    private void setBands() {
        this.probavReflectanceBands = new Band[IdepixConstants.PROBAV_REFLECTANCE_BAND_NAMES.length];
        for (int i = 0; i < IdepixConstants.PROBAV_REFLECTANCE_BAND_NAMES.length; ++i) {
            this.probavReflectanceBands[i] = this.sourceProduct.getBand(IdepixConstants.PROBAV_REFLECTANCE_BAND_NAMES[i]);
        }
        this.landWaterBand = this.waterMaskProduct.getBand("land_water_fraction");
    }

    private void extendTargetProduct() throws OperatorException {
        if (this.copyToaReflectances) {
            this.copyProbavReflectances();
            ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
        if (this.copyAnnotations) {
            this.copyProbavAnnotations();
        }
        if (this.applySchillerNN) {
            this.targetProduct.addBand("probav_nn_value", 30);
        }
    }

    private void copyProbavAnnotations() {
        for (String bandName : IdepixConstants.PROBAV_ANNOTATION_BAND_NAMES) {
            ProductUtils.copyBand((String)bandName, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
    }

    private void copyProbavReflectances() {
        for (int i = 0; i < IdepixConstants.PROBAV_REFLECTANCE_BAND_NAMES.length; ++i) {
            ProductUtils.copyBand((String)IdepixConstants.PROBAV_REFLECTANCE_BAND_NAMES[i], (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
    }

    private ProbaVAlgorithm createProbavAlgorithm(Tile smFlagTile, Tile[] probavReflectanceTiles, float[] probavReflectance, byte watermaskFraction, int y, int x) {
        boolean isLand;
        ProbaVAlgorithm probaVAlgorithm = new ProbaVAlgorithm();
        for (int i = 0; i < IdepixConstants.PROBAV_REFLECTANCE_BAND_NAMES.length; ++i) {
            probavReflectance[i] = probavReflectanceTiles[i].getSampleFloat(x, y);
        }
        double altitude = this.computeGetasseAltitude(x, y);
        probaVAlgorithm.setElevation(altitude);
        this.checkProbavReflectanceQuality(probaVAlgorithm, probavReflectance, smFlagTile, x, y);
        probaVAlgorithm.setRefl(probavReflectance);
        SchillerNeuralNetWrapper nnWrapper = this.vgtNeuralNet.get();
        double[] inputVector = nnWrapper.getInputVector();
        for (int i = 0; i < inputVector.length; ++i) {
            inputVector[i] = Math.sqrt(probavReflectance[i]);
        }
        probaVAlgorithm.setNnOutput(nnWrapper.getNeuralNet().calc(inputVector));
        if (this.useL1bLandWaterFlag) {
            isLand = smFlagTile.getSampleBit(x, y, 5);
            probaVAlgorithm.setL1bLand(isLand);
            probaVAlgorithm.setIsWater(!isLand);
        } else {
            isLand = smFlagTile.getSampleBit(x, y, 5) && watermaskFraction < 23;
            probaVAlgorithm.setL1bLand(isLand);
            this.setIsWaterByFraction(watermaskFraction, probaVAlgorithm);
        }
        return probaVAlgorithm;
    }

    private void readSchillerNeuralNets() {
        try (InputStream vgtLandIS = ((Object)((Object)this)).getClass().getResourceAsStream(VGT_NET_NAME);){
            this.vgtNeuralNet = SchillerNeuralNetWrapper.create(vgtLandIS);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot read Neural Nets: " + e.getMessage());
        }
    }

    void createTargetProduct() throws OperatorException {
        int sceneWidth = this.sourceProduct.getSceneRasterWidth();
        int sceneHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), sceneWidth, sceneHeight);
        this.cloudFlagBand = this.targetProduct.addBand("pixel_classif_flags", 12);
        FlagCoding flagCoding = ProbaVUtils.createProbavFlagCoding("pixel_classif_flags");
        this.cloudFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.copyFeatureValues) {
            this.brightBand = this.targetProduct.addBand("bright_value", 30);
            IdepixIO.setNewBandProperties(this.brightBand, "Brightness", "dl", -1.0, true);
            this.whiteBand = this.targetProduct.addBand("white_value", 30);
            IdepixIO.setNewBandProperties(this.whiteBand, "Whiteness", "dl", -1.0, true);
            this.brightWhiteBand = this.targetProduct.addBand("bright_white_value", 30);
            IdepixIO.setNewBandProperties(this.brightWhiteBand, "Brightwhiteness", "dl", -1.0, true);
            this.temperatureBand = this.targetProduct.addBand("temperature_value", 30);
            IdepixIO.setNewBandProperties(this.temperatureBand, "Temperature", "K", -1.0, true);
            this.spectralFlatnessBand = this.targetProduct.addBand("spectral_flatness_value", 30);
            IdepixIO.setNewBandProperties(this.spectralFlatnessBand, "Spectral Flatness", "dl", -1.0, true);
            this.ndviBand = this.targetProduct.addBand("ndvi_value", 30);
            IdepixIO.setNewBandProperties(this.ndviBand, "NDVI", "dl", -1.0, true);
            this.ndsiBand = this.targetProduct.addBand("ndsi_value", 30);
            IdepixIO.setNewBandProperties(this.ndsiBand, "NDSI", "dl", -1.0, true);
            this.glintRiskBand = this.targetProduct.addBand("glint_risk_value", 30);
            IdepixIO.setNewBandProperties(this.glintRiskBand, "GLINT_RISK", "dl", -1.0, true);
            this.radioLandBand = this.targetProduct.addBand("radiometric_land_value", 30);
            IdepixIO.setNewBandProperties(this.radioLandBand, "Radiometric Land Value", "", -1.0, true);
            this.radioWaterBand = this.targetProduct.addBand("radiometric_water_value", 30);
            IdepixIO.setNewBandProperties(this.radioWaterBand, "Radiometric Water Value", "", -1.0, true);
        }
        ProbaVUtils.setupProbavClassifBitmask(this.targetProduct);
    }

    void setPixelSamples(Band band, Tile targetTile, int y, int x, ProbaVAlgorithm probaVAlgorithm) {
        if (band == this.brightBand) {
            targetTile.setSample(x, y, probaVAlgorithm.brightValue());
        } else if (band == this.whiteBand) {
            targetTile.setSample(x, y, probaVAlgorithm.whiteValue());
        } else if (band == this.brightWhiteBand) {
            targetTile.setSample(x, y, probaVAlgorithm.brightValue() + probaVAlgorithm.whiteValue());
        } else if (band == this.temperatureBand) {
            targetTile.setSample(x, y, probaVAlgorithm.temperatureValue());
        } else if (band == this.spectralFlatnessBand) {
            targetTile.setSample(x, y, probaVAlgorithm.spectralFlatnessValue());
        } else if (band == this.ndviBand) {
            targetTile.setSample(x, y, probaVAlgorithm.ndviValue());
        } else if (band == this.ndsiBand) {
            targetTile.setSample(x, y, probaVAlgorithm.ndsiValue());
        } else if (band == this.glintRiskBand) {
            targetTile.setSample(x, y, probaVAlgorithm.glintRiskValue());
        } else if (band == this.radioLandBand) {
            targetTile.setSample(x, y, probaVAlgorithm.radiometricLandValue());
        } else if (band == this.radioWaterBand) {
            targetTile.setSample(x, y, probaVAlgorithm.radiometricWaterValue());
        }
    }

    void setCloudFlag(Tile targetTile, int y, int x, ProbaVAlgorithm probaVAlgorithm) {
        targetTile.setSample(x, y, 0, probaVAlgorithm.isInvalid());
        targetTile.setSample(x, y, 1, probaVAlgorithm.isCloud());
        targetTile.setSample(x, y, 3, probaVAlgorithm.isCloud());
        targetTile.setSample(x, y, 5, false);
        targetTile.setSample(x, y, 13, probaVAlgorithm.isClearLand());
        targetTile.setSample(x, y, 14, probaVAlgorithm.isClearWater());
        targetTile.setSample(x, y, 6, probaVAlgorithm.isClearSnow());
        targetTile.setSample(x, y, 10, probaVAlgorithm.isLand());
        targetTile.setSample(x, y, 12, probaVAlgorithm.isWater());
        targetTile.setSample(x, y, 7, probaVAlgorithm.isBright());
        targetTile.setSample(x, y, 8, probaVAlgorithm.isWhite());
    }

    void setIsWaterByFraction(byte watermaskFraction, AbstractPixelProperties pixelProperties) {
        boolean isWater = watermaskFraction == 127 ? pixelProperties.isL1Water() : watermaskFraction >= 23;
        pixelProperties.setIsWater(isWater);
    }

    private double computeGetasseAltitude(float x, float y) {
        double altitude;
        PixelPos pixelPos = new PixelPos((double)(x + 0.5f), (double)(y + 0.5f));
        GeoPos geoPos = this.sourceProduct.getSceneGeoCoding().getGeoPos(pixelPos, null);
        try {
            altitude = this.getasseElevationModel.getElevation(geoPos);
        }
        catch (Exception e) {
            e.printStackTrace();
            altitude = 0.0;
        }
        return altitude;
    }

    private void checkProbavReflectanceQuality(ProbaVAlgorithm probaVAlgorithm, float[] probavReflectance, Tile smFlagTile, int x, int y) {
        boolean isBlueGood = smFlagTile.getSampleBit(x, y, 9);
        boolean isRedGood = smFlagTile.getSampleBit(x, y, 8);
        boolean isNirGood = smFlagTile.getSampleBit(x, y, 7);
        boolean isSwirGood = smFlagTile.getSampleBit(x, y, 6);
        boolean isProcessingLand = smFlagTile.getSampleBit(x, y, 5);
        probaVAlgorithm.setIsBlueGood(isBlueGood);
        probaVAlgorithm.setIsRedGood(isRedGood);
        probaVAlgorithm.setIsNirGood(isNirGood);
        probaVAlgorithm.setIsSwirGood(isSwirGood);
        probaVAlgorithm.setProcessingLand(isProcessingLand);
        if (!(isBlueGood && isRedGood && isNirGood && isSwirGood && isProcessingLand)) {
            for (int i = 0; i < probavReflectance.length; ++i) {
                probavReflectance[i] = Float.NaN;
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ProbaVClassificationOp.class);
        }
    }
}

