/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.olcislstr;

import java.util.HashMap;
import org.esa.s3tbx.idepix.core.IdepixFlagCoding;
import org.esa.s3tbx.processor.rad2refl.Rad2ReflConstants;
import org.esa.s3tbx.processor.rad2refl.Rad2ReflOp;
import org.esa.s3tbx.processor.rad2refl.Sensor;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.util.ProductUtils;

public class OlciSlstrUtils {
    public static FlagCoding createOlciFlagCoding(String flagId) {
        return IdepixFlagCoding.createDefaultFlagCoding(flagId);
    }

    public static void setupOlciClassifBitmask(Product classifProduct) {
        IdepixFlagCoding.setupDefaultClassifBitmask(classifProduct);
    }

    public static void addOlciRadiance2ReflectanceBands(Product rad2reflProduct, Product targetProduct, String[] reflBandsToCopy) {
        for (int i = 1; i <= Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length; ++i) {
            for (String bandname : reflBandsToCopy) {
                if (targetProduct.containsBand(bandname) || !bandname.equals("Oa" + String.format("%02d", i) + "_reflectance")) continue;
                ProductUtils.copyBand((String)bandname, (Product)rad2reflProduct, (Product)targetProduct, (boolean)true);
                targetProduct.getBand(bandname).setUnit("dl");
            }
        }
    }

    public static void addSlstrRadiance2ReflectanceBands(Product rad2reflProduct, Product targetProduct, String[] reflBandsToCopy) {
        for (int i = 1; i <= Rad2ReflConstants.SLSTR_REFL_BAND_NAMES.length; ++i) {
            for (String bandname : reflBandsToCopy) {
                if (targetProduct.containsBand(bandname) || !bandname.startsWith("S" + String.format("%01d", i) + "_reflectance")) continue;
                ProductUtils.copyBand((String)bandname, (Product)rad2reflProduct, (Product)targetProduct, (boolean)true);
                targetProduct.getBand(bandname).setUnit("dl");
            }
        }
    }

    public static Product computeRadiance2ReflectanceProduct(Product sourceProduct, Sensor sensor) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("sensor", sensor);
        params.put("copyNonSpectralBands", false);
        return GPF.createProduct((String)OperatorSpi.getOperatorAlias(Rad2ReflOp.class), params, (Product)sourceProduct);
    }
}

