/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.olcislstr;

import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.olcislstr.OlciSlstrClassificationOp;
import org.esa.s3tbx.idepix.algorithms.olcislstr.OlciSlstrPostProcessOp;
import org.esa.s3tbx.idepix.algorithms.olcislstr.OlciSlstrUtils;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.operators.BasisOp;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.processor.rad2refl.Sensor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.Sentinel3.OlciSlstr", category="Optical/Pre-Processing", version="1.0", authors="Olaf Danne", internal=true, copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for OLCI/SLSTR synergy products.")
public class OlciSlstrOp
extends BasisOp {
    @SourceProduct(alias="sourceProduct", label="OLCI/SLSTR Synergy product", description="The OLCI/SLSTR Synergy source product.")
    private Product sourceProduct;
    @TargetProduct(description="The target product.")
    private Product targetProduct;
    private boolean outputOlciRadiance;
    private boolean outputOlciRad2Refl;
    private boolean outputSlstrRadiance;
    private boolean outputSlstrRad2Refl;
    @Parameter(description="The list of OLCI radiance bands to write to target product.", label="Select OLCI TOA radiances to write to the target product", valueSet={"Oa01_radiance", "Oa02_radiance", "Oa03_radiance", "Oa04_radiance", "Oa05_radiance", "Oa06_radiance", "Oa07_radiance", "Oa08_radiance", "Oa09_radiance", "Oa10_radiance", "Oa11_radiance", "Oa12_radiance", "Oa13_radiance", "Oa14_radiance", "Oa15_radiance", "Oa16_radiance", "Oa17_radiance", "Oa18_radiance", "Oa19_radiance", "Oa20_radiance", "Oa21_radiance"}, defaultValue="")
    String[] olciRadianceBandsToCopy;
    @Parameter(description="The list of OLCI reflectance bands to write to target product.", label="Select OLCI TOA reflectances to write to the target product", valueSet={"Oa01_reflectance", "Oa02_reflectance", "Oa03_reflectance", "Oa04_reflectance", "Oa05_reflectance", "Oa06_reflectance", "Oa07_reflectance", "Oa08_reflectance", "Oa09_reflectance", "Oa10_reflectance", "Oa11_reflectance", "Oa12_reflectance", "Oa13_reflectance", "Oa14_reflectance", "Oa15_reflectance", "Oa16_reflectance", "Oa17_reflectance", "Oa18_reflectance", "Oa19_reflectance", "Oa20_reflectance", "Oa21_reflectance"}, defaultValue="")
    String[] olciReflBandsToCopy;
    @Parameter(description="The list of SLSTR radiance bands to write to target product.", label="Select SLSTR TOA radiances to write to the target product", valueSet={"S1_radiance_an", "S2_radiance_an", "S3_radiance_an", "S4_radiance_an", "S5_radiance_an", "S6_radiance_an", "S4_radiance_bn", "S5_radiance_bn", "S6_radiance_bn", "S4_radiance_cn", "S5_radiance_cn", "S6_radiance_cn"}, defaultValue="")
    String[] slstrRadianceBandsToCopy;
    @Parameter(description="The list of SLSTR reflectance bands to write to target product.", label="Select SLSTR TOA reflectances to write to the target product", valueSet={"S1_reflectance_an", "S2_reflectance_an", "S3_reflectance_an", "S4_reflectance_an", "S5_reflectance_an", "S6_reflectance_an", "S4_reflectance_bn", "S5_reflectance_bn", "S6_reflectance_bn", "S4_reflectance_cn", "S5_reflectance_cn", "S6_reflectance_cn"}, defaultValue="")
    String[] slstrReflBandsToCopy;
    @Parameter(defaultValue="false", label=" Write NN value to the target product", description=" If applied, write NN value to the target product ")
    private boolean outputSchillerNNValue;
    @Parameter(defaultValue="true", label=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    @Parameter(defaultValue="2", interval="[0,100]", description="The width of a cloud 'safety buffer' around a pixel which was classified as cloudy.", label="Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    private Product postProcessingProduct;
    private Product olciRad2reflProduct;
    private Product slstrRad2reflProduct;
    private Product waterMaskProduct;
    private Map<String, Product> classificationInputProducts;
    private Map<String, Object> classificationParameters;

    public void initialize() throws OperatorException {
        boolean inputProductIsValid = IdepixIO.validateInputProduct(this.sourceProduct, AlgorithmSelector.OLCISLSTR);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.outputOlciRadiance = this.olciRadianceBandsToCopy != null && this.olciRadianceBandsToCopy.length > 0;
        this.outputOlciRad2Refl = this.olciReflBandsToCopy != null && this.olciReflBandsToCopy.length > 0;
        this.outputSlstrRadiance = this.slstrRadianceBandsToCopy != null && this.slstrRadianceBandsToCopy.length > 0;
        this.outputSlstrRad2Refl = this.slstrReflBandsToCopy != null && this.slstrReflBandsToCopy.length > 0;
        this.preProcess();
        this.setClassificationInputProducts();
        Product olciSlstrIdepixProduct = this.computeClassificationProduct();
        olciSlstrIdepixProduct.setName(this.sourceProduct.getName() + "_IDEPIX");
        olciSlstrIdepixProduct.setAutoGrouping("Oa*_radiance:Oa*_reflectance:S*_radiance:S*_reflectance");
        if (this.computeCloudBuffer) {
            this.postProcess(olciSlstrIdepixProduct);
        }
        this.targetProduct = this.createTargetProduct(olciSlstrIdepixProduct);
        this.targetProduct.setAutoGrouping(olciSlstrIdepixProduct.getAutoGrouping());
        if (this.postProcessingProduct != null) {
            Band cloudFlagBand = this.targetProduct.getBand("pixel_classif_flags");
            cloudFlagBand.setSourceImage(this.postProcessingProduct.getBand("pixel_classif_flags").getSourceImage());
        }
    }

    private Product createTargetProduct(Product idepixProduct) {
        Product targetProduct = new Product(idepixProduct.getName(), idepixProduct.getProductType(), idepixProduct.getSceneRasterWidth(), idepixProduct.getSceneRasterHeight());
        ProductUtils.copyMetadata((Product)idepixProduct, (Product)targetProduct);
        ProductUtils.copyGeoCoding((Product)idepixProduct, (Product)targetProduct);
        ProductUtils.copyFlagCodings((Product)idepixProduct, (Product)targetProduct);
        ProductUtils.copyFlagBands((Product)idepixProduct, (Product)targetProduct, (boolean)true);
        ProductUtils.copyMasks((Product)idepixProduct, (Product)targetProduct);
        ProductUtils.copyTiePointGrids((Product)idepixProduct, (Product)targetProduct);
        targetProduct.setStartTime(idepixProduct.getStartTime());
        targetProduct.setEndTime(idepixProduct.getEndTime());
        OlciSlstrUtils.setupOlciClassifBitmask(targetProduct);
        if (this.outputOlciRadiance) {
            IdepixIO.addRadianceBands(this.sourceProduct, targetProduct, this.olciRadianceBandsToCopy);
        }
        if (this.outputOlciRad2Refl) {
            OlciSlstrUtils.addOlciRadiance2ReflectanceBands(this.olciRad2reflProduct, targetProduct, this.olciReflBandsToCopy);
        }
        if (this.outputSlstrRadiance) {
            IdepixIO.addRadianceBands(this.sourceProduct, targetProduct, this.slstrRadianceBandsToCopy);
        }
        if (this.outputSlstrRad2Refl) {
            OlciSlstrUtils.addSlstrRadiance2ReflectanceBands(this.slstrRad2reflProduct, targetProduct, this.slstrReflBandsToCopy);
        }
        if (this.outputSchillerNNValue) {
            ProductUtils.copyBand((String)"nn_value", (Product)idepixProduct, (Product)targetProduct, (boolean)true);
        }
        return targetProduct;
    }

    private void preProcess() {
        this.olciRad2reflProduct = OlciSlstrUtils.computeRadiance2ReflectanceProduct(this.sourceProduct, Sensor.OLCI);
        this.slstrRad2reflProduct = OlciSlstrUtils.computeRadiance2ReflectanceProduct(this.sourceProduct, Sensor.SLSTR_500m);
        HashMap<String, Integer> waterMaskParameters = new HashMap<String, Integer>();
        waterMaskParameters.put("resolution", 50);
        waterMaskParameters.put("subSamplingFactorX", 3);
        waterMaskParameters.put("subSamplingFactorY", 3);
        this.waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterMaskParameters, (Product)this.sourceProduct);
    }

    private void setClassificationParameters() {
        this.classificationParameters = new HashMap<String, Object>();
        this.classificationParameters.put("copyAllTiePoints", true);
        this.classificationParameters.put("outputSchillerNNValue", this.outputSchillerNNValue);
    }

    private void setClassificationInputProducts() {
        this.classificationInputProducts = new HashMap<String, Product>();
        this.classificationInputProducts.put("l1b", this.sourceProduct);
        this.classificationInputProducts.put("reflOlci", this.olciRad2reflProduct);
        this.classificationInputProducts.put("reflSlstr", this.slstrRad2reflProduct);
        this.classificationInputProducts.put("waterMask", this.waterMaskProduct);
    }

    private Product computeClassificationProduct() {
        this.setClassificationParameters();
        return GPF.createProduct((String)OperatorSpi.getOperatorAlias(OlciSlstrClassificationOp.class), this.classificationParameters, this.classificationInputProducts);
    }

    private void postProcess(Product olciIdepixProduct) {
        HashMap<String, Product> input = new HashMap<String, Product>();
        input.put("olciSlstrCloud", olciIdepixProduct);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("cloudBufferWidth", this.cloudBufferWidth);
        this.postProcessingProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(OlciSlstrPostProcessOp.class), params, input);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OlciSlstrOp.class);
        }
    }
}

