/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.olcislstr;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.InputStream;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.olcislstr.OlciSlstrCloudNNInterpreter;
import org.esa.s3tbx.idepix.algorithms.olcislstr.OlciSlstrConstants;
import org.esa.s3tbx.idepix.algorithms.olcislstr.OlciSlstrUtils;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.s3tbx.processor.rad2refl.Rad2ReflConstants;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.OlciSlstr.Classification", version="1.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Idepix pixel classification operator for OLCI/SLSTR synergy.")
public class OlciSlstrClassificationOp
extends Operator {
    @Parameter(defaultValue="false", label=" Write NN value to the target product.", description=" If applied, write Schiller NN value to the target product ")
    private boolean outputSchillerNNValue;
    @SourceProduct(alias="l1b", description="The source product.")
    Product sourceProduct;
    @SourceProduct(alias="reflOlci")
    private Product olciRad2reflProduct;
    @SourceProduct(alias="reflSlstr")
    private Product slstrRad2reflProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    @TargetProduct(description="The target product.")
    Product targetProduct;
    Band cloudFlagBand;
    private Band[] olciReflBands;
    private Band[] slstrReflBands;
    private Band landWaterBand;
    public static final String OLCISLSTR_ALL_NET_NAME = "11x9x6x4x3x2_57.8.net";
    private static final double THRESH_LAND_MINBRIGHT1 = 0.3;
    private static final double THRESH_LAND_MINBRIGHT2 = 0.25;
    ThreadLocal<SchillerNeuralNetWrapper> olciSlstrAllNeuralNet;
    private OlciSlstrCloudNNInterpreter nnInterpreter;

    public void initialize() throws OperatorException {
        this.setBands();
        this.nnInterpreter = OlciSlstrCloudNNInterpreter.create();
        this.readSchillerNeuralNets();
        this.createTargetProduct();
    }

    private void readSchillerNeuralNets() {
        InputStream olciAllIS = ((Object)((Object)this)).getClass().getResourceAsStream(OLCISLSTR_ALL_NET_NAME);
        this.olciSlstrAllNeuralNet = SchillerNeuralNetWrapper.create(olciAllIS);
    }

    public void setBands() {
        String reflBandname;
        int suffixStart;
        int i;
        this.olciReflBands = new Band[Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length];
        for (i = 0; i < Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length; ++i) {
            suffixStart = Rad2ReflConstants.OLCI_REFL_BAND_NAMES[i].indexOf("_");
            reflBandname = Rad2ReflConstants.OLCI_REFL_BAND_NAMES[i].substring(0, suffixStart);
            this.olciReflBands[i] = this.olciRad2reflProduct.getBand(reflBandname + "_reflectance");
        }
        this.slstrReflBands = new Band[OlciSlstrConstants.SLSTR_REFL_AN_BAND_NAMES.length];
        for (i = 0; i < OlciSlstrConstants.SLSTR_REFL_AN_BAND_NAMES.length; ++i) {
            suffixStart = OlciSlstrConstants.SLSTR_REFL_AN_BAND_NAMES[i].indexOf("_");
            reflBandname = OlciSlstrConstants.SLSTR_REFL_AN_BAND_NAMES[i].substring(0, suffixStart);
            int length = OlciSlstrConstants.SLSTR_REFL_AN_BAND_NAMES[i].length();
            this.slstrReflBands[i] = this.slstrRad2reflProduct.getBand(reflBandname + "_reflectance_an");
        }
        this.landWaterBand = this.waterMaskProduct.getBand("land_water_fraction");
    }

    void createTargetProduct() throws OperatorException {
        int sceneWidth = this.sourceProduct.getSceneRasterWidth();
        int sceneHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), sceneWidth, sceneHeight);
        this.cloudFlagBand = this.targetProduct.addBand("pixel_classif_flags", 11);
        FlagCoding flagCoding = OlciSlstrUtils.createOlciFlagCoding("pixel_classif_flags");
        this.cloudFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.outputSchillerNNValue) {
            Band nnValueBand = this.targetProduct.addBand("nn_value", 30);
            nnValueBand.setNoDataValue(0.0);
            nnValueBand.setNoDataValueUsed(true);
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        Tile waterFractionTile = this.getSourceTile((RasterDataNode)this.landWaterBand, rectangle);
        Band olciQualityFlagBand = this.sourceProduct.getBand("quality_flags");
        Tile olciQualityFlagTile = this.getSourceTile((RasterDataNode)olciQualityFlagBand, rectangle);
        Tile[] olciReflectanceTiles = new Tile[Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length];
        float[] olciReflectance = new float[Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length];
        for (int i = 0; i < Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length; ++i) {
            olciReflectanceTiles[i] = this.getSourceTile((RasterDataNode)this.olciReflBands[i], rectangle);
        }
        Tile[] slstrReflectanceTiles = new Tile[OlciSlstrConstants.SLSTR_REFL_AN_BAND_NAMES.length];
        float[] slstrReflectance = new float[OlciSlstrConstants.SLSTR_REFL_AN_BAND_NAMES.length];
        for (int i = 0; i < OlciSlstrConstants.SLSTR_REFL_AN_BAND_NAMES.length; ++i) {
            slstrReflectanceTiles[i] = this.getSourceTile((RasterDataNode)this.slstrReflBands[i], rectangle);
        }
        Band cloudFlagTargetBand = this.targetProduct.getBand("pixel_classif_flags");
        Tile cloudFlagTargetTile = targetTiles.get(cloudFlagTargetBand);
        Tile nnTargetTile = null;
        if (this.outputSchillerNNValue) {
            Band nnTargetBand = this.targetProduct.getBand("nn_value");
            nnTargetTile = targetTiles.get(nnTargetBand);
        }
        try {
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                this.checkForCancellation();
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    int i;
                    int i2;
                    this.initCloudFlag(targetTiles.get(cloudFlagTargetBand), y, x);
                    int waterFraction = waterFractionTile.getSampleInt(x, y);
                    boolean isL1bLand = olciQualityFlagTile.getSampleBit(x, y, 31);
                    boolean isLand = IdepixUtils.isLandPixel(x, y, this.sourceProduct.getSceneGeoCoding(), isL1bLand, waterFraction);
                    cloudFlagTargetTile.setSample(x, y, 10, isLand);
                    for (i2 = 0; i2 < Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length; ++i2) {
                        olciReflectance[i2] = olciReflectanceTiles[i2].getSampleFloat(x, y);
                    }
                    for (i2 = 0; i2 < OlciSlstrConstants.SLSTR_REFL_AN_BAND_NAMES.length; ++i2) {
                        slstrReflectance[i2] = slstrReflectanceTiles[i2].getSampleFloat(x, y);
                    }
                    boolean l1Invalid = olciQualityFlagTile.getSampleBit(x, y, 25);
                    boolean reflectancesValid = IdepixIO.areAllReflectancesValid(olciReflectance);
                    cloudFlagTargetTile.setSample(x, y, 0, l1Invalid || !(reflectancesValid &= IdepixIO.areAllReflectancesValid(slstrReflectance)));
                    if (!reflectancesValid) continue;
                    SchillerNeuralNetWrapper nnWrapper = this.olciSlstrAllNeuralNet.get();
                    double[] inputVector = nnWrapper.getInputVector();
                    for (i = 0; i < inputVector.length - 6; ++i) {
                        inputVector[i] = Math.sqrt(olciReflectance[i]);
                    }
                    for (i = inputVector.length - slstrReflectance.length; i < inputVector.length; ++i) {
                        inputVector[i] = Math.sqrt(slstrReflectance[i - olciReflectance.length]);
                    }
                    double nnOutput = nnWrapper.getNeuralNet().calc(inputVector)[0];
                    if (!cloudFlagTargetTile.getSampleBit(x, y, 0)) {
                        cloudFlagTargetTile.setSample(x, y, 2, false);
                        cloudFlagTargetTile.setSample(x, y, 3, false);
                        cloudFlagTargetTile.setSample(x, y, 1, false);
                        cloudFlagTargetTile.setSample(x, y, 6, false);
                        boolean cloudSure = (double)olciReflectance[2] > 0.3 && this.nnInterpreter.isCloudSure(nnOutput);
                        boolean cloudAmbiguous = (double)olciReflectance[2] > 0.25 && this.nnInterpreter.isCloudAmbiguous(nnOutput, true, false);
                        cloudFlagTargetTile.setSample(x, y, 2, cloudAmbiguous);
                        cloudFlagTargetTile.setSample(x, y, 3, cloudSure);
                        cloudFlagTargetTile.setSample(x, y, 1, cloudAmbiguous || cloudSure);
                        cloudFlagTargetTile.setSample(x, y, 6, this.nnInterpreter.isSnowIce(nnOutput));
                    }
                    if (nnTargetTile == null) continue;
                    nnTargetTile.setSample(x, y, nnOutput);
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException("Failed to provide GA cloud screening:\n" + e.getMessage(), (Throwable)e);
        }
    }

    void initCloudFlag(Tile targetTile, int y, int x) {
        targetTile.setSample(x, y, 1, false);
        targetTile.setSample(x, y, 3, false);
        targetTile.setSample(x, y, 2, false);
        targetTile.setSample(x, y, 6, false);
        targetTile.setSample(x, y, 4, false);
        targetTile.setSample(x, y, 5, false);
        targetTile.setSample(x, y, 9, false);
        targetTile.setSample(x, y, 10, true);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OlciSlstrClassificationOp.class);
        }
    }
}

