/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.olci;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.idepix.core.CloudShadowFronts;
import org.esa.s3tbx.idepix.core.operators.CloudBuffer;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;

@OperatorMetadata(alias="Idepix.Olci.Postprocess", version="1.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Refines the OLCI pixel classification over both land and water.")
public class OlciPostProcessOp
extends Operator {
    @Parameter(defaultValue="true", label=" Compute a cloud buffer", description=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    @Parameter(defaultValue="2", interval="[0,100]", description="The width of a cloud 'safety buffer' around a pixel which was classified as cloudy.", label="Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="false", label=" Compute cloud shadow", description=" Compute cloud shadow with latest 'fronts' algorithm. Requires CTP.")
    private boolean computeCloudShadow;
    @SourceProduct(alias="l1b")
    private Product l1bProduct;
    @SourceProduct(alias="olciCloud")
    private Product olciCloudProduct;
    private Band origCloudFlagBand;
    private Band ctpBand;
    private TiePointGrid szaTPG;
    private TiePointGrid saaTPG;
    private Band altBand;
    private GeoCoding geoCoding;
    private RectangleExtender rectCalculator;

    public void initialize() throws OperatorException {
        Product postProcessedCloudProduct = IdepixIO.createCompatibleTargetProduct(this.olciCloudProduct, "postProcessedCloud", "postProcessedCloud", true);
        this.geoCoding = this.l1bProduct.getSceneGeoCoding();
        this.origCloudFlagBand = this.olciCloudProduct.getBand("pixel_classif_flags");
        this.szaTPG = this.l1bProduct.getTiePointGrid("SZA");
        this.saaTPG = this.l1bProduct.getTiePointGrid("SAA");
        this.altBand = this.l1bProduct.getBand("altitude");
        if (this.computeCloudBuffer) {
            this.rectCalculator = new RectangleExtender(new Rectangle(this.l1bProduct.getSceneRasterWidth(), this.l1bProduct.getSceneRasterHeight()), this.cloudBufferWidth, this.cloudBufferWidth);
        }
        if (this.computeCloudShadow) {
            int extendedHeight;
            int extendedWidth;
            this.ctpBand = this.olciCloudProduct.getBand("ctp");
            if (this.l1bProduct.getName().contains("FR____")) {
                extendedWidth = 64;
                extendedHeight = 64;
            } else {
                extendedWidth = 16;
                extendedHeight = 16;
            }
            this.rectCalculator = new RectangleExtender(new Rectangle(this.l1bProduct.getSceneRasterWidth(), this.l1bProduct.getSceneRasterHeight()), extendedWidth, extendedHeight);
        }
        ProductUtils.copyBand((String)"pixel_classif_flags", (Product)this.olciCloudProduct, (Product)postProcessedCloudProduct, (boolean)false);
        this.setTargetProduct(postProcessedCloudProduct);
    }

    public void computeTile(Band targetBand, final Tile targetTile, ProgressMonitor pm) throws OperatorException {
        boolean isCloud;
        int x;
        int y;
        Rectangle targetRectangle = targetTile.getRectangle();
        Rectangle srcRectangle = this.rectCalculator.extend(targetRectangle);
        final Tile sourceFlagTile = this.getSourceTile((RasterDataNode)this.origCloudFlagBand, srcRectangle);
        for (y = srcRectangle.y; y < srcRectangle.y + srcRectangle.height; ++y) {
            this.checkForCancellation();
            for (x = srcRectangle.x; x < srcRectangle.x + srcRectangle.width; ++x) {
                if (!targetRectangle.contains(x, y)) continue;
                isCloud = sourceFlagTile.getSampleBit(x, y, 1);
                this.combineFlags(x, y, sourceFlagTile, targetTile);
                if (!isCloud) continue;
                targetTile.setSample(x, y, 6, false);
            }
        }
        if (this.computeCloudBuffer) {
            for (y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                this.checkForCancellation();
                for (x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    if (!targetRectangle.contains(x, y) || !(isCloud = targetTile.getSampleBit(x, y, 1))) continue;
                    CloudBuffer.computeSimpleCloudBuffer(x, y, targetTile, srcRectangle, this.cloudBufferWidth, 4);
                }
            }
            for (y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                this.checkForCancellation();
                for (x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    IdepixUtils.consolidateCloudAndBuffer(targetTile, x, y);
                }
            }
        }
        if (this.computeCloudShadow) {
            Tile szaTile = this.getSourceTile((RasterDataNode)this.szaTPG, srcRectangle);
            Tile saaTile = this.getSourceTile((RasterDataNode)this.saaTPG, srcRectangle);
            Tile ctpTile = this.getSourceTile((RasterDataNode)this.ctpBand, srcRectangle);
            Tile altTile = this.getSourceTile((RasterDataNode)this.altBand, targetRectangle);
            CloudShadowFronts cloudShadowFronts = new CloudShadowFronts(this.geoCoding, srcRectangle, targetRectangle, szaTile, saaTile, ctpTile, altTile){

                @Override
                protected boolean isCloudForShadow(int x, int y) {
                    if (!targetTile.getRectangle().contains(x, y)) {
                        return sourceFlagTile.getSampleBit(x, y, 1);
                    }
                    return targetTile.getSampleBit(x, y, 1);
                }

                @Override
                protected boolean isCloudFree(int x, int y) {
                    return !sourceFlagTile.getSampleBit(x, y, 1);
                }

                @Override
                protected boolean isSurroundedByCloud(int x, int y) {
                    return 1.isPixelSurrounded(x, y, sourceFlagTile, 1);
                }

                @Override
                protected void setCloudShadow(int x, int y) {
                    targetTile.setSample(x, y, 5, true);
                }
            };
            cloudShadowFronts.computeCloudShadow();
        }
    }

    private void combineFlags(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        int sourceFlags = sourceFlagTile.getSampleInt(x, y);
        int computedFlags = targetTile.getSampleInt(x, y);
        targetTile.setSample(x, y, sourceFlags | computedFlags);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OlciPostProcessOp.class);
        }
    }
}

