/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.modis;

import java.io.IOException;
import java.io.InputStream;
import org.esa.s3tbx.idepix.algorithms.modis.ModisAlgorithm;
import org.esa.s3tbx.idepix.algorithms.modis.ModisConstants;
import org.esa.s3tbx.idepix.algorithms.modis.ModisUtils;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;

@OperatorMetadata(alias="Idepix.Modis.Classification", version="2.2", copyright="(c) 2016 by Brockmann Consult", description="MODIS pixel classification operator.", internal=true)
public class ModisClassificationOp
extends PixelOperator {
    @Parameter(defaultValue="true", label=" Apply brightness test", description="Apply brightness test: EV_250_Aggr1km_RefSB_1 > THRESH.")
    private boolean applyBrightnessTest;
    @Parameter(defaultValue="true", label=" Apply 'OR' logic in cloud test", description="Apply 'OR' logic instead of 'AND' logic in cloud test.")
    private boolean applyOrLogicInCloudTest;
    @Parameter(defaultValue="0.15", label=" 'Dark glint' threshold at 859nm", description="'Dark glint' threshold: Cloud possible only if EV_250_Aggr1km_RefSB_2 > THRESH.")
    private double modisGlintThresh859 = 0.15;
    @Parameter(defaultValue="1", label=" Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="150", valueSet={"1000", "150", "50"}, label=" Resolution of land-water mask (m/pixel)", description="Resolution of used land-water mask in meters per pixel")
    private int waterMaskResolution;
    @Parameter(defaultValue="true", label=" Write reflective solar bands", description="Write TOA reflective solar bands (RefSB) to target product.")
    private boolean outputRad2Refl = true;
    @Parameter(defaultValue="false", label=" Write emissive bands", description="Write 'Emissive' bands to target product.")
    private boolean outputEmissive = false;
    @Parameter(defaultValue="2.0", label=" NN cloud ambiguous lower boundary", description=" NN cloud ambiguous lower boundary")
    double nnCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.35", label=" NN cloud ambiguous/sure separation value", description=" NN cloud ambiguous cloud ambiguous/sure separation value")
    double nnCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.2", label=" NN cloud sure/snow separation value", description=" NN cloud ambiguous cloud sure/snow separation value")
    double nnCloudSureSnowSeparationValue;
    @Parameter(defaultValue="0.08", label=" 'B_NIR' threshold at 859nm (MODIS)", description="'B_NIR' threshold: 'Cloud B_NIR' set if EV_250_Aggr1km_RefSB_2 > THRESH.")
    private double bNirThresh859 = 0.08;
    @Parameter(defaultValue="0.15", label=" 'Dark glint' threshold at 859nm for 'cloud sure' (MODIS)", description="'Dark glint' threshold: 'Cloud sure' possible only if EV_250_Aggr1km_RefSB_2 > THRESH.")
    private double glintThresh859forCloudSure = 0.15;
    @Parameter(defaultValue="0.06", label=" 'Dark glint' threshold at 859nm for 'cloud ambiguous' (MODIS)", description="'Dark glint' threshold: 'Cloud ambiguous' possible only if EV_250_Aggr1km_RefSB_2 > THRESH.")
    private double glintThresh859forCloudAmbiguous = 0.06;
    @Parameter(defaultValue="0.125", label=" Brightness test 'cloud ambiguous' threshold (MODIS)", description="Brightness test 'cloud ambiguous' threshold: EV_250_Aggr1km_RefSB_1 > THRESH (MODIS).")
    private double brightnessThreshCloudAmbiguous = 0.125;
    @SourceProduct(alias="refl", description="MODIS L1b reflectance product")
    private Product reflProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    public static final String MODIS_WATER_NET_NAME = "9x7x5x3_130.3_water.net";
    public static final String MODIS_LAND_NET_NAME = "8x6x4x2_290.4_land.net";
    public static final String MODIS_ALL_NET_NAME = "9x7x5x3_319.7_all.net";
    ThreadLocal<SchillerNeuralNetWrapper> modisWaterNeuralNet;
    ThreadLocal<SchillerNeuralNetWrapper> modisLandNeuralNet;
    ThreadLocal<SchillerNeuralNetWrapper> modisAllNeuralNet;

    public Product getSourceProduct() {
        return this.reflProduct;
    }

    protected void prepareInputs() throws OperatorException {
        this.readSchillerNets();
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        ModisAlgorithm algorithm = this.createModisAlgorithm(x, y, sourceSamples, targetSamples);
        this.setClassifFlag(targetSamples, algorithm);
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        int i;
        for (i = 0; i < ModisConstants.MODIS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            if (this.reflProduct.containsBand(ModisConstants.MODIS_L1B_SPECTRAL_BAND_NAMES[i])) {
                sampleConfigurer.defineSample(i, ModisConstants.MODIS_L1B_SPECTRAL_BAND_NAMES[i], this.reflProduct);
                continue;
            }
            sampleConfigurer.defineSample(i, ModisConstants.MODIS_L1B_SPECTRAL_BAND_NAMES[i].replace(".", "_"), this.reflProduct);
        }
        for (i = 0; i < ModisConstants.MODIS_L1B_NUM_EMISSIVE_BANDS; ++i) {
            if (this.reflProduct.containsBand(ModisConstants.MODIS_L1B_EMISSIVE_BAND_NAMES[i])) {
                sampleConfigurer.defineSample(22 + i, ModisConstants.MODIS_L1B_EMISSIVE_BAND_NAMES[i], this.reflProduct);
                continue;
            }
            String newEmissiveBandName = ModisConstants.MODIS_L1B_EMISSIVE_BAND_NAMES[i].replace(".", "_");
            Band emissiveBand = this.reflProduct.getBand(newEmissiveBandName);
            emissiveBand.setScalingFactor(1.0);
            emissiveBand.setScalingOffset(0.0);
            sampleConfigurer.defineSample(22 + i, newEmissiveBandName, this.reflProduct);
        }
        int index = 22 + ModisConstants.MODIS_L1B_NUM_SPECTRAL_BANDS + 1;
        sampleConfigurer.defineSample(index, "land_water_fraction", this.waterMaskProduct);
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "pixel_classif_flags");
        sampleConfigurer.defineSample(1, "nn_value");
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        productConfigurer.copyTimeCoding();
        productConfigurer.copyTiePointGrids(new String[0]);
        Band classifFlagBand = productConfigurer.addBand("pixel_classif_flags", 11);
        classifFlagBand.setDescription("Pixel classification flag");
        classifFlagBand.setUnit("dl");
        FlagCoding flagCoding = ModisUtils.createModisFlagCoding("pixel_classif_flags");
        classifFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.getTargetProduct().getFlagCodingGroup().add((ProductNode)flagCoding);
        this.getTargetProduct().setSceneGeoCoding(this.reflProduct.getSceneGeoCoding());
        ModisUtils.setupModisClassifBitmask(this.getTargetProduct());
        Band nnValueBand = productConfigurer.addBand("nn_value", 30);
        nnValueBand.setDescription("Schiller NN output value");
        nnValueBand.setUnit("dl");
    }

    private void readSchillerNets() {
        try (InputStream isMW = ((Object)((Object)this)).getClass().getResourceAsStream(MODIS_WATER_NET_NAME);
             InputStream isML = ((Object)((Object)this)).getClass().getResourceAsStream(MODIS_LAND_NET_NAME);
             InputStream isMA = ((Object)((Object)this)).getClass().getResourceAsStream(MODIS_ALL_NET_NAME);){
            this.modisWaterNeuralNet = SchillerNeuralNetWrapper.create(isMW);
            this.modisLandNeuralNet = SchillerNeuralNetWrapper.create(isML);
            this.modisAllNeuralNet = SchillerNeuralNetWrapper.create(isMA);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot read Schiller neural nets: " + e.getMessage());
        }
    }

    private void setClassifFlag(WritableSample[] targetSamples, ModisAlgorithm algorithm) {
        targetSamples[0].set(0, algorithm.isInvalid());
        targetSamples[0].set(1, algorithm.isCloud());
        targetSamples[0].set(2, algorithm.isCloudAmbiguous());
        targetSamples[0].set(3, algorithm.isCloudSure());
        targetSamples[0].set(4, algorithm.isCloudBuffer());
        targetSamples[0].set(5, algorithm.isCloudShadow());
        targetSamples[0].set(6, algorithm.isSnowIce());
        targetSamples[0].set(11, algorithm.isMixedPixel());
        targetSamples[0].set(9, algorithm.isCoastline());
        targetSamples[0].set(10, algorithm.isLand());
        targetSamples[0].set(7, algorithm.isBright());
    }

    private ModisAlgorithm createModisAlgorithm(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        ModisAlgorithm modisAlgorithm = new ModisAlgorithm();
        double[] reflectance = new double[ModisConstants.MODIS_L1B_NUM_SPECTRAL_BANDS];
        float waterFraction = Float.NaN;
        for (int i = 0; i < ModisConstants.MODIS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            reflectance[i] = sourceSamples[i].getFloat();
        }
        modisAlgorithm.setRefl(reflectance);
        if (this.getGeoPos((int)x, (int)y).lat > -58.0) {
            waterFraction = sourceSamples[22 + ModisConstants.MODIS_L1B_NUM_SPECTRAL_BANDS + 1].getFloat();
        }
        modisAlgorithm.setWaterFraction(waterFraction);
        modisAlgorithm.setModisApplyBrightnessTest(this.applyBrightnessTest);
        double ocModisBrightnessThreshCloudSure = 0.15;
        modisAlgorithm.setModisBrightnessThreshCloudSure(0.15);
        double ocModisBrightnessThreshCloudAmbiguous = 0.125;
        modisAlgorithm.setModisBrightnessThreshCloudAmbiguous(0.125);
        modisAlgorithm.setModisGlintThresh859forCloudAmbiguous(this.glintThresh859forCloudAmbiguous);
        modisAlgorithm.setModisGlintThresh859forCloudSure(this.glintThresh859forCloudSure);
        modisAlgorithm.setModisBNirThresh859(this.bNirThresh859);
        modisAlgorithm.setModisApplyOrLogicInCloudTest(this.applyOrLogicInCloudTest);
        modisAlgorithm.setNnCloudAmbiguousLowerBoundaryValue(this.nnCloudAmbiguousLowerBoundaryValue);
        modisAlgorithm.setNnCloudAmbiguousSureSeparationValue(this.nnCloudAmbiguousSureSeparationValue);
        modisAlgorithm.setNnCloudSureSnowSeparationValue(this.nnCloudSureSnowSeparationValue);
        double[] modisNeuralNetInput = this.modisAllNeuralNet.get().getInputVector();
        modisNeuralNetInput[0] = Math.sqrt(sourceSamples[0].getFloat());
        modisNeuralNetInput[1] = Math.sqrt(sourceSamples[2].getFloat());
        modisNeuralNetInput[2] = Math.sqrt(sourceSamples[3].getFloat());
        modisNeuralNetInput[3] = Math.sqrt(sourceSamples[4].getFloat());
        modisNeuralNetInput[4] = Math.sqrt(sourceSamples[6].getFloat());
        float emissive23Rad = sourceSamples[25].getFloat();
        modisNeuralNetInput[5] = Math.sqrt(emissive23Rad);
        float emissive25Rad = sourceSamples[27].getFloat();
        modisNeuralNetInput[6] = Math.sqrt(emissive25Rad);
        modisNeuralNetInput[7] = Math.sqrt(sourceSamples[21].getFloat());
        float emissive31Rad = sourceSamples[32].getFloat();
        modisNeuralNetInput[8] = Math.sqrt(emissive31Rad);
        float emissive32Rad = sourceSamples[33].getFloat();
        modisNeuralNetInput[9] = Math.sqrt(emissive32Rad);
        double[] neuralNetOutput = this.modisAllNeuralNet.get().getNeuralNet().calc(modisNeuralNetInput);
        modisAlgorithm.setNnOutput(neuralNetOutput);
        targetSamples[1].set(neuralNetOutput[0]);
        targetSamples[0].set(12, modisAlgorithm.isCloudBNir());
        return modisAlgorithm;
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        GeoCoding geoCoding = this.reflProduct.getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ModisClassificationOp.class);
        }
    }
}

