/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.meris;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.esa.s3tbx.idepix.core.IdepixFlagCoding;
import org.esa.s3tbx.processor.rad2refl.Rad2ReflConstants;
import org.esa.s3tbx.processor.rad2refl.Rad2ReflOp;
import org.esa.s3tbx.processor.rad2refl.Sensor;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.util.BitSetter;
import org.esa.snap.core.util.ProductUtils;

public class MerisUtils {
    public static FlagCoding createMerisFlagCoding(String flagId) {
        FlagCoding flagCoding = IdepixFlagCoding.createDefaultFlagCoding(flagId);
        flagCoding.addFlag("IDEPIX_GLINT_RISK", BitSetter.setFlag((int)0, (int)12), "Glint risk pixel");
        return flagCoding;
    }

    public static void setupMerisClassifBitmask(Product classifProduct) {
        int index = IdepixFlagCoding.setupDefaultClassifBitmask(classifProduct);
        int w = classifProduct.getSceneRasterWidth();
        int h = classifProduct.getSceneRasterHeight();
        Random r = new Random();
        Mask mask = Mask.BandMathsType.create((String)"IDEPIX_GLINT_RISK", (String)"Glint risk pixel", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_GLINT_RISK", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index, (ProductNode)mask);
    }

    public static void addMerisRadiance2ReflectanceBands(Product rad2reflProduct, Product targetProduct, String[] reflBandsToCopy) {
        for (int i = 1; i <= Rad2ReflConstants.MERIS_REFL_BAND_NAMES.length; ++i) {
            for (String bandname : reflBandsToCopy) {
                if (targetProduct.containsBand(bandname) || !bandname.startsWith("reflectance") || !bandname.endsWith("_" + String.valueOf(i))) continue;
                ProductUtils.copyBand((String)bandname, (Product)rad2reflProduct, (Product)targetProduct, (boolean)true);
                targetProduct.getBand(bandname).setUnit("dl");
            }
        }
    }

    public static Product computeRadiance2ReflectanceProduct(Product sourceProduct) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("sensor", Sensor.MERIS);
        params.put("copyNonSpectralBands", false);
        return GPF.createProduct((String)OperatorSpi.getOperatorAlias(Rad2ReflOp.class), params, (Product)sourceProduct);
    }

    public static Product computeCloudTopPressureProduct(Product sourceProduct) {
        return GPF.createProduct((String)"Meris.CloudTopPressureOp", (Map)GPF.NO_PARAMS, (Product)sourceProduct);
    }
}

