/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.avhrr;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.idepix.core.CloudShadowFronts;
import org.esa.s3tbx.idepix.core.operators.CloudBuffer;
import org.esa.s3tbx.idepix.core.util.OperatorUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;

@OperatorMetadata(alias="Idepix.Avhrr.Postprocess", version="2.2", internal=true, authors="Marco Peters, Marco Zuehlke, Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Refines the AVHRR pixel classification.")
public class AvhrrPostProcessOp
extends Operator {
    @Parameter(defaultValue="2", label="Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="true", label=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    private boolean computeCloudShadow = false;
    @Parameter(defaultValue="true", label=" Refine pixel classification near coastlines", description="Refine pixel classification near coastlines. ")
    private boolean refineClassificationNearCoastlines;
    @SourceProduct(alias="l1b")
    private Product l1bProduct;
    @SourceProduct(alias="avhrrCloud")
    private Product avhrrCloudProduct;
    @SourceProduct(alias="waterMask", optional=true)
    private Product waterMaskProduct;
    private Band landWaterBand;
    private Band origCloudFlagBand;
    private Band rt3Band;
    private Band bt4Band;
    private Band refl1Band;
    private Band refl2Band;
    private GeoCoding geoCoding;
    private RectangleExtender rectCalculator;

    public void initialize() throws OperatorException {
        if (!(this.computeCloudBuffer || this.computeCloudShadow || this.refineClassificationNearCoastlines)) {
            this.setTargetProduct(this.avhrrCloudProduct);
        } else {
            Product postProcessedCloudProduct = OperatorUtils.createCompatibleProduct(this.avhrrCloudProduct, "postProcessedCloud", "postProcessedCloud");
            this.landWaterBand = this.waterMaskProduct.getBand("land_water_fraction");
            this.geoCoding = this.l1bProduct.getSceneGeoCoding();
            this.origCloudFlagBand = this.avhrrCloudProduct.getBand("pixel_classif_flags");
            this.rt3Band = this.avhrrCloudProduct.getBand("rt_3");
            this.bt4Band = this.avhrrCloudProduct.getBand("bt_4");
            this.refl1Band = this.avhrrCloudProduct.getBand("refl_1");
            this.refl2Band = this.avhrrCloudProduct.getBand("refl_2");
            int extendedWidth = 64;
            int extendedHeight = 64;
            this.rectCalculator = new RectangleExtender(new Rectangle(this.l1bProduct.getSceneRasterWidth(), this.l1bProduct.getSceneRasterHeight()), extendedWidth, extendedHeight);
            ProductUtils.copyBand((String)"pixel_classif_flags", (Product)this.avhrrCloudProduct, (Product)postProcessedCloudProduct, (boolean)false);
            this.setTargetProduct(postProcessedCloudProduct);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRectangle = targetTile.getRectangle();
        Rectangle srcRectangle = this.rectCalculator.extend(targetRectangle);
        Tile sourceFlagTile = this.getSourceTile((RasterDataNode)this.origCloudFlagBand, srcRectangle);
        Tile waterFractionTile = this.getSourceTile((RasterDataNode)this.landWaterBand, srcRectangle);
        Tile rt3Tile = this.getSourceTile((RasterDataNode)this.rt3Band, srcRectangle);
        Tile bt4Tile = this.getSourceTile((RasterDataNode)this.bt4Band, srcRectangle);
        Tile refl1Tile = this.getSourceTile((RasterDataNode)this.refl1Band, srcRectangle);
        Tile refl2Tile = this.getSourceTile((RasterDataNode)this.refl2Band, srcRectangle);
        for (int y = srcRectangle.y; y < srcRectangle.y + srcRectangle.height; ++y) {
            this.checkForCancellation();
            for (int x = srcRectangle.x; x < srcRectangle.x + srcRectangle.width; ++x) {
                boolean isCloudAfterRefinement;
                if (!targetRectangle.contains(x, y)) continue;
                boolean isCloud = sourceFlagTile.getSampleBit(x, y, 1);
                boolean isSnowIce = sourceFlagTile.getSampleBit(x, y, 6);
                this.combineFlags(x, y, sourceFlagTile, targetTile);
                if (this.refineClassificationNearCoastlines && this.isNearCoastline(x, y, waterFractionTile, srcRectangle)) {
                    targetTile.setSample(x, y, 9, true);
                    this.refineSnowIceFlaggingForCoastlines(x, y, sourceFlagTile, targetTile);
                    if (isCloud) {
                        this.refineCloudFlaggingForCoastlines(x, y, sourceFlagTile, waterFractionTile, targetTile, srcRectangle);
                    }
                }
                if (!(isCloudAfterRefinement = targetTile.getSampleBit(x, y, 1))) continue;
                targetTile.setSample(x, y, 6, false);
                if (!this.computeCloudBuffer) continue;
                CloudBuffer.computeSimpleCloudBuffer(x, y, targetTile, targetTile, this.cloudBufferWidth, 1, 4);
            }
        }
        if (this.computeCloudShadow) {
            // empty if block
        }
    }

    private void combineFlags(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        int sourceFlags = sourceFlagTile.getSampleInt(x, y);
        int computedFlags = targetTile.getSampleInt(x, y);
        targetTile.setSample(x, y, sourceFlags | computedFlags);
    }

    private boolean isCoastlinePixel(int x, int y, Tile waterFractionTile) {
        int waterFraction;
        boolean isCoastline = false;
        if (this.getGeoPos((int)x, (int)y).lat > -58.0 && (waterFraction = waterFractionTile.getSampleInt(x, y)) <= 100) {
            isCoastline = waterFraction < 100 && waterFraction > 0;
        }
        return isCoastline;
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        this.geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    private boolean isNearCoastline(int x, int y, Tile waterFractionTile, Rectangle rectangle) {
        boolean windowWidth = true;
        int LEFT_BORDER = Math.max(x - 1, rectangle.x);
        int RIGHT_BORDER = Math.min(x + 1, rectangle.x + rectangle.width - 1);
        int TOP_BORDER = Math.max(y - 1, rectangle.y);
        int BOTTOM_BORDER = Math.min(y + 1, rectangle.y + rectangle.height - 1);
        int waterFractionCenter = waterFractionTile.getSampleInt(x, y);
        for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
            for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                if (!rectangle.contains(i, j) || !(!(this.l1bProduct.getSceneGeoCoding() instanceof TiePointGeoCoding) && !(this.l1bProduct.getSceneGeoCoding() instanceof CrsGeoCoding) ? waterFractionTile.getSampleInt(i, j) != waterFractionCenter : this.isCoastlinePixel(i, j, waterFractionTile))) continue;
                return true;
            }
        }
        return false;
    }

    private void refineCloudFlaggingForCoastlines(int x, int y, Tile sourceFlagTile, Tile waterFractionTile, Tile targetTile, Rectangle srcRectangle) {
        boolean windowWidth = true;
        int LEFT_BORDER = Math.max(x - 1, srcRectangle.x);
        int RIGHT_BORDER = Math.min(x + 1, srcRectangle.x + srcRectangle.width - 1);
        int TOP_BORDER = Math.max(y - 1, srcRectangle.y);
        int BOTTOM_BORDER = Math.min(y + 1, srcRectangle.y + srcRectangle.height - 1);
        boolean removeCloudFlag = true;
        if (CloudShadowFronts.isPixelSurrounded(x, y, sourceFlagTile, 1)) {
            removeCloudFlag = false;
        } else {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            block0: for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
                for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                    boolean is_cloud = sourceFlagTile.getSampleBit(i, j, 1);
                    if (!is_cloud || !targetTileRectangle.contains(i, j) || this.isNearCoastline(i, j, waterFractionTile, srcRectangle)) continue;
                    removeCloudFlag = false;
                    continue block0;
                }
            }
        }
        if (removeCloudFlag) {
            targetTile.setSample(x, y, 1, false);
            targetTile.setSample(x, y, 3, false);
            targetTile.setSample(x, y, 2, false);
        }
    }

    private void refineSnowIceFlaggingForCoastlines(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        boolean isSnowIce = sourceFlagTile.getSampleBit(x, y, 6);
        if (isSnowIce) {
            targetTile.setSample(x, y, 6, false);
        }
    }

    private void refineSnowIceCloudFlagging(int x, int y, Tile rt3Tile, Tile bt4Tile, Tile refl1Tile, Tile refl2Tile, Tile targetTile) {
        boolean secondCrit;
        double rt3 = rt3Tile.getSampleDouble(x, y);
        double bt4 = bt4Tile.getSampleDouble(x, y);
        double refl1 = refl1Tile.getSampleDouble(x, y);
        double refl2 = refl2Tile.getSampleDouble(x, y);
        double ratio21 = refl2 / refl1;
        boolean firstCrit = rt3 > 0.08;
        boolean bl = secondCrit = -40.15 < bt4 && bt4 < 1.35 && refl1 > 0.25 && 0.85 < ratio21 && ratio21 < 1.15 && rt3 < 0.02;
        if (firstCrit || !secondCrit) {
            targetTile.setSample(x, y, 1, true);
            targetTile.setSample(x, y, 3, true);
            targetTile.setSample(x, y, 2, false);
            targetTile.setSample(x, y, 6, false);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AvhrrPostProcessOp.class);
        }
    }
}

