/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.avhrr;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrPostProcessOp;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrUSGSClassificationOp;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.operators.BasisOp;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;

@OperatorMetadata(alias="Idepix.Avhrr", internal=true, category="Optical/Pre-Processing", version="1.0", authors="Olaf Danne, Grit Kirches", copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for AVHRR.")
public class AvhrrOp
extends BasisOp {
    private static final int LAND_WATER_MASK_RESOLUTION = 50;
    private static final int OVERSAMPLING_FACTOR_X = 3;
    private static final int OVERSAMPLING_FACTOR_Y = 3;
    @SourceProduct(alias="sourceProduct", label="Landsat 8 product", description="The Landsat 8 source product.")
    private Product sourceProduct;
    @TargetProduct(description="The target product.")
    private Product targetProduct;
    private Product classificationProduct;
    private Product postProcessingProduct;
    private Product waterMaskProduct;
    @Parameter(defaultValue="false", label=" Copy input radiance/reflectance bands")
    private boolean aacCopyRadiances = false;
    @Parameter(defaultValue="true", label=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    @Parameter(defaultValue="2", label=" Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="true", label=" Refine pixel classification near coastlines", description="Refine pixel classification near coastlines. ")
    private boolean refineClassificationNearCoastlines;
    @Parameter(defaultValue="2.15", label=" Schiller NN cloud ambiguous lower boundary ", description=" Schiller NN cloud ambiguous lower boundary ")
    double avhrracSchillerNNCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.45", label=" Schiller NN cloud ambiguous/sure separation value ", description=" Schiller NN cloud ambiguous cloud ambiguous/sure separation value ")
    double avhrracSchillerNNCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.45", label=" Schiller NN cloud sure/snow separation value ", description=" Schiller NN cloud ambiguous cloud sure/snow separation value ")
    double avhrracSchillerNNCloudSureSnowSeparationValue;
    private Map<String, Object> aacCloudClassificationParameters;

    public void initialize() throws OperatorException {
        boolean inputProductIsValid = IdepixIO.validateInputProduct(this.sourceProduct, AlgorithmSelector.AVHRR);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.aacCloudClassificationParameters = this.createAacCloudClassificationParameters();
        this.processAvhrrAc();
    }

    private Map<String, Object> createAacCloudClassificationParameters() {
        HashMap<String, Object> aacCloudClassificationParameters = new HashMap<String, Object>(1);
        aacCloudClassificationParameters.put("aacCopyRadiances", this.aacCopyRadiances);
        aacCloudClassificationParameters.put("aacCloudBufferWidth", this.cloudBufferWidth);
        aacCloudClassificationParameters.put("avhrracSchillerNNCloudAmbiguousLowerBoundaryValue", this.avhrracSchillerNNCloudAmbiguousLowerBoundaryValue);
        aacCloudClassificationParameters.put("avhrracSchillerNNCloudAmbiguousSureSeparationValue", this.avhrracSchillerNNCloudAmbiguousSureSeparationValue);
        aacCloudClassificationParameters.put("avhrracSchillerNNCloudSureSnowSeparationValue", this.avhrracSchillerNNCloudSureSnowSeparationValue);
        return aacCloudClassificationParameters;
    }

    private void processAvhrrAc() {
        AvhrrUSGSClassificationOp acClassificationOp = new AvhrrUSGSClassificationOp();
        acClassificationOp.setParameterDefaultValues();
        for (String key : this.aacCloudClassificationParameters.keySet()) {
            acClassificationOp.setParameter(key, this.aacCloudClassificationParameters.get(key));
        }
        acClassificationOp.setSourceProduct("aacl1b", this.sourceProduct);
        this.createWaterMaskProduct();
        acClassificationOp.setSourceProduct("waterMask", this.waterMaskProduct);
        this.classificationProduct = acClassificationOp.getTargetProduct();
        this.postProcess();
        this.targetProduct = IdepixIO.cloneProduct(this.classificationProduct, true);
        this.targetProduct.setName(this.sourceProduct.getName() + ".idepix");
        Band cloudFlagBand = this.targetProduct.getBand("pixel_classif_flags");
        cloudFlagBand.setSourceImage(this.postProcessingProduct.getBand("pixel_classif_flags").getSourceImage());
    }

    private void postProcess() {
        HashMap<String, Product> input = new HashMap<String, Product>();
        input.put("l1b", this.sourceProduct);
        input.put("avhrrCloud", this.classificationProduct);
        input.put("waterMask", this.waterMaskProduct);
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("cloudBufferWidth", Integer.valueOf(this.cloudBufferWidth));
        params.put("computeCloudBuffer", Boolean.valueOf(this.computeCloudBuffer));
        params.put("computeCloudShadow", Boolean.valueOf(false));
        params.put("refineClassificationNearCoastlines", Boolean.valueOf(this.refineClassificationNearCoastlines));
        this.postProcessingProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(AvhrrPostProcessOp.class), params, input);
    }

    private void createWaterMaskProduct() {
        HashMap<String, Object> waterMaskParameters = new HashMap<String, Object>();
        String[] sourceBandNames = new String[]{"albedo_1"};
        waterMaskParameters.put("sourceBandNames", sourceBandNames);
        waterMaskParameters.put("landMask", false);
        this.waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterMaskParameters, (Product)this.sourceProduct);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AvhrrOp.class);
        }
    }
}

