/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.avhrr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.esa.snap.core.gpf.OperatorException;

public class AvhrrAuxdata {
    public static final int VZA_TABLE_LENGTH = 2048;
    public static final String VZA_FILE_NAME = "view_zenith.txt";
    public static final int RAD2BT_TABLE_LENGTH = 3;
    public static final String RAD2BT_FILE_NAME_PREFIX = "rad2bt_noaa";
    private static AvhrrAuxdata instance;

    public static AvhrrAuxdata getInstance() {
        if (instance == null) {
            instance = new AvhrrAuxdata();
        }
        return instance;
    }

    public Line2ViewZenithTable createLine2ViewZenithTable() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(VZA_FILE_NAME);
        Line2ViewZenithTable vzaTable = new Line2ViewZenithTable();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            for (int i = 0; (line = bufferedReader.readLine()) != null && i < 2048; ++i) {
                StringTokenizer st = new StringTokenizer(line = line.trim(), "\t", false);
                if (st.hasMoreTokens()) {
                    vzaTable.setxIndex(i, Integer.parseInt(st.nextToken()));
                }
                if (!st.hasMoreTokens()) continue;
                vzaTable.setVza(i, Double.parseDouble(st.nextToken()));
            }
        }
        catch (IOException | NumberFormatException e) {
            throw new OperatorException("Failed to load Line2ViewZenithTable: \n" + e.getMessage(), (Throwable)e);
        }
        finally {
            inputStream.close();
        }
        return vzaTable;
    }

    public Rad2BTTable createRad2BTTable(String noaaId) throws IOException {
        String filename = RAD2BT_FILE_NAME_PREFIX + noaaId + ".txt";
        InputStream inputStream = this.getClass().getResourceAsStream(filename);
        Rad2BTTable rad2BTTable = new Rad2BTTable();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            for (int i = 0; (line = bufferedReader.readLine()) != null && i < 3; ++i) {
                StringTokenizer st = new StringTokenizer(line = line.trim(), "\t", false);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    rad2BTTable.setA(i, Double.parseDouble(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    rad2BTTable.setB(i, Double.parseDouble(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    rad2BTTable.setD(i, Double.parseDouble(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    rad2BTTable.setNuLow(i, Double.parseDouble(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    rad2BTTable.setNuMid(i, Double.parseDouble(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    rad2BTTable.setNuHighland(i, Double.parseDouble(st.nextToken()));
                }
                if (!st.hasMoreTokens()) continue;
                rad2BTTable.setNuHighWater(i, Double.parseDouble(st.nextToken()));
            }
        }
        catch (IOException | NumberFormatException e) {
            throw new OperatorException("Failed to load Rad2BTTable: \n" + e.getMessage(), (Throwable)e);
        }
        finally {
            inputStream.close();
        }
        return rad2BTTable;
    }

    public class Rad2BTTable {
        private final int OFFSET = 3;
        private double[] A = new double[3];
        private double[] B = new double[3];
        private double[] D = new double[3];
        private double[] nuLow = new double[3];
        private double[] nuMid = new double[3];
        private double[] nuHighland = new double[3];
        private double[] nuHighWater = new double[3];

        public double getA(int index) {
            return this.A[index - 3];
        }

        public void setA(int index, double a) {
            this.A[index] = a;
        }

        public double getB(int index) {
            return this.B[index - 3];
        }

        public void setB(int index, double b) {
            this.B[index] = b;
        }

        public double getD(int index) {
            return this.D[index - 3];
        }

        public void setD(int index, double d) {
            this.D[index] = d;
        }

        public double getNuLow(int index) {
            return this.nuLow[index - 3];
        }

        public void setNuLow(int index, double nuLow) {
            this.nuLow[index] = nuLow;
        }

        public double getNuMid(int index) {
            return this.nuMid[index - 3];
        }

        public void setNuMid(int index, double nuMid) {
            this.nuMid[index] = nuMid;
        }

        public double getNuHighLand(int index) {
            return this.nuHighland[index - 3];
        }

        public void setNuHighland(int index, double nuHighland) {
            this.nuHighland[index] = nuHighland;
        }

        public double getNuHighWater(int index) {
            return this.nuHighWater[index - 3];
        }

        public void setNuHighWater(int index, double nuHighWater) {
            this.nuHighWater[index] = nuHighWater;
        }
    }

    public class Line2ViewZenithTable {
        private int[] xIndex = new int[2048];
        private double[] vza = new double[2048];

        public void setxIndex(int index, int xIndex) {
            this.xIndex[index] = xIndex;
        }

        public double getVza(int index) {
            return this.vza[index];
        }

        public void setVza(int index, double vza) {
            this.vza[index] = vza;
        }
    }
}

