/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.avhrr;

import java.awt.Color;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrAuxdata;
import org.esa.s3tbx.idepix.core.IdepixFlagCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.BitSetter;

public class AvhrrAcUtils {
    public static FlagCoding createAvhrrAcFlagCoding(String flagId) {
        FlagCoding flagCoding = IdepixFlagCoding.createDefaultFlagCoding(flagId);
        flagCoding.addFlag("F_REFL1_ABOVE_THRESH", BitSetter.setFlag((int)0, (int)12), null);
        flagCoding.addFlag("F_REFL2_ABOVE_THRESH", BitSetter.setFlag((int)0, (int)13), null);
        flagCoding.addFlag("F_RATIO_REFL21_ABOVE_THRESH", BitSetter.setFlag((int)0, (int)14), null);
        flagCoding.addFlag("F_RATIO_REFL31_ABOVE_THRESH", BitSetter.setFlag((int)0, (int)15), null);
        flagCoding.addFlag("F_BT4_ABOVE_THRESH", BitSetter.setFlag((int)0, (int)16), null);
        flagCoding.addFlag("F_BT5_ABOVE_THRESH", BitSetter.setFlag((int)0, (int)17), null);
        return flagCoding;
    }

    public static int setupAvhrrAcClassifBitmask(Product classifProduct) {
        int index = IdepixFlagCoding.setupDefaultClassifBitmask(classifProduct);
        int w = classifProduct.getSceneRasterWidth();
        int h = classifProduct.getSceneRasterHeight();
        Random r = new Random();
        Mask mask = Mask.BandMathsType.create((String)"F_REFL1_ABOVE_THRESH", (String)"TOA reflectance Channel 1 above threshold", (int)w, (int)h, (String)"pixel_classif_flags.F_REFL1_ABOVE_THRESH", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"F_REFL2_ABOVE_THRESH", (String)"TOA reflectance Channel 2 above threshold", (int)w, (int)h, (String)"pixel_classif_flags.F_REFL2_ABOVE_THRESH", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"F_RATIO_REFL21_ABOVE_THRESH", (String)"Ratio of TOA reflectance Channel 2/1 above threshold", (int)w, (int)h, (String)"pixel_classif_flags.F_RATIO_REFL21_ABOVE_THRESH", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"F_RATIO_REFL31_ABOVE_THRESH", (String)"Ratio of TOA reflectance Channel 3/1 above threshold", (int)w, (int)h, (String)"pixel_classif_flags.F_RATIO_REFL31_ABOVE_THRESH", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"F_BT4_ABOVE_THRESH", (String)"Brightness temperature Channel 4 above threshold", (int)w, (int)h, (String)"pixel_classif_flags.F_BT4_ABOVE_THRESH", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"F_BT5_ABOVE_THRESH", (String)"Brightness temperature Channel 5 above threshold", (int)w, (int)h, (String)"pixel_classif_flags.F_BT5_ABOVE_THRESH", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        return index;
    }

    public static Calendar getProductDateAsCalendar(String ddmmyy) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        int year = Integer.parseInt(ddmmyy.substring(4, 6));
        year = year < 50 ? 2000 + year : 1900 + year;
        int month = Integer.parseInt(ddmmyy.substring(2, 4)) - 1;
        int day = Integer.parseInt(ddmmyy.substring(0, 2));
        calendar.set(year, month, day, 12, 0, 0);
        return calendar;
    }

    public static boolean anglesInvalid(double sza, double vza, double saa, double vaa) {
        boolean szaInvalid = sza > 70.0;
        boolean vzaInvalid = Double.isNaN(vza);
        boolean saaInvalid = Double.isNaN(saa);
        boolean vaaInvalid = Double.isNaN(vaa);
        return szaInvalid || saaInvalid || vzaInvalid || vaaInvalid;
    }

    public static double convertRadianceToBt(String noaaId, AvhrrAuxdata.Rad2BTTable rad2BTTable, double radianceOrig, int ch, float waterFraction) {
        double c1 = 1.1910659E-5;
        double c2 = 1.438833;
        double rad = rad2BTTable.getA(ch) * radianceOrig + rad2BTTable.getB(ch) * radianceOrig * radianceOrig + rad2BTTable.getD(ch);
        double nuStart = rad2BTTable.getNuMid(ch);
        double tRef = 1.438833 * nuStart / Math.log(1.0 + 1.1910659E-5 * nuStart * nuStart * nuStart / rad);
        double nuFinal = nuStart;
        switch (noaaId) {
            case "11": {
                if (tRef < 225.0) {
                    nuFinal = rad2BTTable.getNuLow(ch);
                    break;
                }
                if (tRef >= 225.0 && tRef < 275.0) {
                    if (waterFraction == 100.0f && tRef > 270.0) {
                        nuFinal = rad2BTTable.getNuHighWater(ch);
                        break;
                    }
                    nuFinal = rad2BTTable.getNuMid(ch);
                    break;
                }
                if (!(tRef >= 275.0) || !(tRef < 320.0)) break;
                if (waterFraction == 100.0f && tRef < 310.0) {
                    nuFinal = rad2BTTable.getNuHighWater(ch);
                    break;
                }
                nuFinal = rad2BTTable.getNuHighLand(ch);
                break;
            }
            case "14": {
                if (tRef < 230.0) {
                    nuFinal = rad2BTTable.getNuLow(ch);
                    break;
                }
                if (tRef >= 230.0 && tRef < 270.0) {
                    nuFinal = rad2BTTable.getNuMid(ch);
                    break;
                }
                if (!(tRef >= 270.0) || !(tRef < 330.0)) break;
                if (waterFraction == 100.0f && tRef < 310.0) {
                    nuFinal = rad2BTTable.getNuHighWater(ch);
                    break;
                }
                nuFinal = rad2BTTable.getNuHighLand(ch);
                break;
            }
            default: {
                throw new OperatorException("AVHRR version " + noaaId + " not supported.");
            }
        }
        return 1.438833 * nuFinal / Math.log(1.0 + 1.1910659E-5 * nuFinal * nuFinal * nuFinal / rad);
    }
}

