/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.avhrr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrAcUtils;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrAlgorithm;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrAuxdata;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrConstants;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.s3tbx.idepix.core.util.SunPosition;
import org.esa.s3tbx.idepix.core.util.SunPositionCalculator;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.WritableSample;

@OperatorMetadata(alias="Idepix.Avhrr.Abstract.Classification", version="2.2", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Abstract basic operator for pixel classification from AVHRR L1b data.")
public abstract class AbstractAvhrrClassificationOp
extends PixelOperator {
    @SourceProduct(alias="aacl1b", description="The source product.")
    Product sourceProduct;
    @SourceProduct(alias="waterMask")
    Product waterMaskProduct;
    @TargetProduct(description="The target product.")
    Product targetProduct;
    @Parameter(defaultValue="false", label=" Copy input radiance bands (with albedo1/2 converted)")
    boolean aacCopyRadiances = false;
    @Parameter(defaultValue="2", label=" Width of cloud buffer (# of pixels)")
    int aacCloudBufferWidth;
    @Parameter(defaultValue="50", valueSet={"50", "150"}, label=" Resolution of used land-water mask in m/pixel", description="Resolution in m/pixel")
    int wmResolution;
    @Parameter(defaultValue="true", label=" Consider water mask fraction")
    boolean aacUseWaterMaskFraction = true;
    @Parameter(defaultValue="false", label=" Flip source images (check before if needed!)")
    boolean flipSourceImages;
    @Parameter(defaultValue="2.15", label=" Schiller NN cloud ambiguous lower boundary ", description=" Schiller NN cloud ambiguous lower boundary ")
    double avhrracSchillerNNCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.45", label=" Schiller NN cloud ambiguous/sure separation value ", description=" Schiller NN cloud ambiguous cloud ambiguous/sure separation value ")
    double avhrracSchillerNNCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.45", label=" Schiller NN cloud sure/snow separation value ", description=" Schiller NN cloud ambiguous cloud sure/snow separation value ")
    double avhrracSchillerNNCloudSureSnowSeparationValue;
    @Parameter(defaultValue="20.0", label=" Reflectance 1 'brightness' threshold ", description=" Reflectance 1 'brightness' threshold ")
    double reflCh1Thresh;
    @Parameter(defaultValue="20.0", label=" Reflectance 2 'brightness' threshold ", description=" Reflectance 2 'brightness' threshold ")
    double reflCh2Thresh;
    @Parameter(defaultValue="1.0", label=" Reflectance 2/1 ratio threshold ", description=" Reflectance 2/1 ratio threshold ")
    double r2r1RatioThresh;
    @Parameter(defaultValue="1.0", label=" Reflectance 3/1 ratio threshold ", description=" Reflectance 3/1 ratio threshold ")
    double r3r1RatioThresh;
    @Parameter(defaultValue="-30.0", label=" Channel 4 brightness temperature threshold (C)", description=" Channel 4 brightness temperature threshold (C)")
    double btCh4Thresh;
    @Parameter(defaultValue="-30.0", label=" Channel 5 brightness temperature threshold (C)", description=" Channel 5 brightness temperature threshold (C)")
    double btCh5Thresh;
    static final int ALBEDO_TO_RADIANCE = 0;
    static final int RADIANCE_TO_ALBEDO = 1;
    static final String AVHRRAC_NET_NAME = "6x3_114.1.net";
    ThreadLocal<SchillerNeuralNetWrapper> avhrracNeuralNet;
    AvhrrAuxdata.Line2ViewZenithTable vzaTable;
    AvhrrAuxdata.Rad2BTTable rad2BTTable;
    SunPosition sunPosition;
    String noaaId;

    public Product getSourceProduct() {
        return this.sourceProduct;
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        this.runAvhrrAcAlgorithm(x, y, sourceSamples, targetSamples);
    }

    void readSchillerNets() {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(AVHRRAC_NET_NAME);){
            this.avhrracNeuralNet = SchillerNeuralNetWrapper.create(is);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot read Schiller neural nets: " + e.getMessage());
        }
    }

    GeoPos computeSatPosition(int y) {
        return this.getGeoPos(this.sourceProduct.getSceneRasterWidth() / 2, y);
    }

    void computeSunPosition() {
        Calendar calendar = AvhrrAcUtils.getProductDateAsCalendar(this.getProductDatestring());
        this.sunPosition = SunPositionCalculator.calculate(calendar);
    }

    int getDoy() {
        return IdepixUtils.getDoyFromYYMMDD(this.getProductDatestring());
    }

    double getDistanceCorr() {
        return 1.0 + 0.033 * Math.cos(Math.PI * 2 * (double)this.getDoy() / 365.0);
    }

    GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        GeoCoding geoCoding = this.sourceProduct.getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    double calculateReflectancePartChannel3b(double radianceCh3b, double btCh4, double btch5, double sza) {
        double result;
        double frequenz;
        int sensorId;
        switch (this.noaaId) {
            case "11": {
                sensorId = 0;
                frequenz = 0.0;
                break;
            }
            case "14": {
                sensorId = 0;
                frequenz = 0.0;
                break;
            }
            default: {
                throw new OperatorException("Cannot parse source product name " + this.sourceProduct.getName() + " properly.");
            }
        }
        double t_3b_B0 = btCh4 - btch5 > 1.0 ? AvhrrConstants.A0[sensorId] + AvhrrConstants.B0[sensorId] * btCh4 + AvhrrConstants.C0[sensorId] * (btCh4 - btch5) : btCh4;
        double r_3b_em = btCh4 > 0.0 ? 1.1910659E-5 * Math.pow(frequenz, 3.0) / (Math.exp(1.438833 * frequenz / ((t_3b_B0 - AvhrrConstants.a1_3b[sensorId]) / AvhrrConstants.a2_3b[sensorId])) - 1.0) : 0.0;
        double emissivity_3b = btCh4 > 0.0 ? radianceCh3b / r_3b_em : 0.0;
        if (sza < 90.0 && r_3b_em > 0.0 && radianceCh3b > 0.0) {
            double b_0_3b = 4448.0 / AvhrrConstants.EW_3b[sensorId];
            result = Math.PI * (radianceCh3b - r_3b_em) / (b_0_3b * Math.cos(sza * (Math.PI / 180)) * this.getDistanceCorr() - Math.PI * r_3b_em);
        } else {
            result = sza > 90.0 && emissivity_3b > 0.0 ? 1.0 - emissivity_3b : Double.NaN;
        }
        return result;
    }

    double convertBetweenAlbedoAndRadiance(double input, double sza, int mode, int bandIndex) {
        double result;
        float[] integrSolarSpectralIrrad = new float[2];
        float[] spectralResponseWidth = new float[2];
        switch (this.noaaId) {
            case "11": {
                integrSolarSpectralIrrad[0] = 184.1f;
                integrSolarSpectralIrrad[1] = 241.1f;
                spectralResponseWidth[0] = 0.113f;
                spectralResponseWidth[1] = 0.229f;
                break;
            }
            case "14": {
                integrSolarSpectralIrrad[0] = 221.42f;
                integrSolarSpectralIrrad[1] = 252.29f;
                spectralResponseWidth[0] = 0.136f;
                spectralResponseWidth[1] = 0.245f;
                break;
            }
            default: {
                throw new OperatorException("Cannot parse source product name " + this.sourceProduct.getName() + " properly.");
            }
        }
        double conversionFactor = (double)integrSolarSpectralIrrad[bandIndex] / (314.1592653589793 * (double)spectralResponseWidth[bandIndex]);
        if (mode == 0) {
            result = input * conversionFactor;
        } else if (mode == 1) {
            result = input / (conversionFactor * Math.cos(sza * (Math.PI / 180)) * this.getDistanceCorr());
        } else {
            throw new IllegalArgumentException("wrong mode " + mode + " for albedo/radiance conversion");
        }
        return result;
    }

    abstract void setClassifFlag(WritableSample[] var1, AvhrrAlgorithm var2);

    abstract void runAvhrrAcAlgorithm(int var1, int var2, Sample[] var3, WritableSample[] var4);

    abstract void setNoaaId();

    abstract String getProductDatestring();

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AbstractAvhrrClassificationOp.class);
        }
    }
}

