/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.operators;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.idepix.algorithms.CloudBuffer;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;

@OperatorMetadata(alias="Idepix.Cloudbuffer", category="Optical/Pre-Processing", internal=true, version="1.0", authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Idepix cloud buffer operator.")
public class CloudBufferOp
extends Operator {
    @Parameter(defaultValue="2", label="Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="false", label=" Use the LandCover advanced cloud buffer algorithm")
    private boolean useLcCloudBuffer;
    @SourceProduct(alias="classifiedProduct")
    private Product classifiedProduct;
    private Band origClassifFlagBand;
    private RectangleExtender rectCalculator;

    public void initialize() throws OperatorException {
        Product cloudBufferProduct = this.createTargetProduct(this.classifiedProduct, "postProcessedCloudBuffer", "postProcessedCloudBuffer");
        this.rectCalculator = new RectangleExtender(new Rectangle(this.classifiedProduct.getSceneRasterWidth(), this.classifiedProduct.getSceneRasterHeight()), this.cloudBufferWidth, this.cloudBufferWidth);
        this.origClassifFlagBand = this.classifiedProduct.getBand("pixel_classif_flags");
        ProductUtils.copyBand((String)"pixel_classif_flags", (Product)this.classifiedProduct, (Product)cloudBufferProduct, (boolean)false);
        this.setTargetProduct(cloudBufferProduct);
    }

    private Product createTargetProduct(Product sourceProduct, String name, String type) {
        int sceneWidth = sourceProduct.getSceneRasterWidth();
        int sceneHeight = sourceProduct.getSceneRasterHeight();
        Product targetProduct = new Product(name, type, sceneWidth, sceneHeight);
        ProductUtils.copyGeoCoding((Product)sourceProduct, (Product)targetProduct);
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
        return targetProduct;
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        int x;
        int y;
        Rectangle targetRectangle = targetTile.getRectangle();
        Rectangle srcRectangle = this.rectCalculator.extend(targetRectangle);
        Tile sourceFlagTile = this.getSourceTile((RasterDataNode)this.origClassifFlagBand, srcRectangle);
        for (y = srcRectangle.y; y < srcRectangle.y + srcRectangle.height; ++y) {
            this.checkForCancellation();
            for (x = srcRectangle.x; x < srcRectangle.x + srcRectangle.width; ++x) {
                boolean isCloud;
                if (targetRectangle.contains(x, y)) {
                    IdepixUtils.combineFlags(x, y, sourceFlagTile, targetTile);
                }
                if (!(isCloud = sourceFlagTile.getSampleBit(x, y, 1))) continue;
                if (this.useLcCloudBuffer) {
                    CloudBuffer.computeCloudBufferLC(targetTile, 1, 4);
                    continue;
                }
                CloudBuffer.computeSimpleCloudBuffer(x, y, targetTile, srcRectangle, this.cloudBufferWidth, 4);
            }
        }
        for (y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
            this.checkForCancellation();
            for (x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                IdepixUtils.consolidateCloudAndBuffer(targetTile, x, y);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CloudBufferOp.class);
        }
    }
}

