/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core.util;

import org.esa.s3tbx.idepix.algorithms.viirs.ViirsConstants;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.IdepixConstants;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.s3tbx.processor.rad2refl.Rad2ReflConstants;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.SceneFactory;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dataio.envisat.EnvisatConstants;

public class IdepixIO {
    private IdepixIO() {
    }

    public static Product createCompatibleTargetProduct(Product sourceProduct, String name, String type, boolean copyAllTiePoints) {
        int sceneWidth = sourceProduct.getSceneRasterWidth();
        int sceneHeight = sourceProduct.getSceneRasterHeight();
        Product targetProduct = new Product(name, type, sceneWidth, sceneHeight);
        IdepixIO.copyTiePoints(sourceProduct, targetProduct, copyAllTiePoints);
        ProductUtils.copyGeoCoding((Product)sourceProduct, (Product)targetProduct);
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
        return targetProduct;
    }

    public static void copyTiePoints(Product sourceProduct, Product targetProduct, boolean copyAllTiePoints) {
        if (copyAllTiePoints) {
            ProductUtils.copyTiePointGrids((Product)sourceProduct, (Product)targetProduct);
        } else {
            for (int i = 0; i < sourceProduct.getNumTiePointGrids(); ++i) {
                TiePointGrid srcTPG = sourceProduct.getTiePointGridAt(i);
                if (!srcTPG.getName().equals("latitude") && !srcTPG.getName().equals("longitude")) continue;
                targetProduct.addTiePointGrid(srcTPG.cloneTiePointGrid());
            }
        }
    }

    public static void copyGeocodingFromBandToProduct(Band referenceBand, Product product) {
        Scene srcScene = SceneFactory.createScene((ProductNode)referenceBand);
        Scene destScene = SceneFactory.createScene((ProductNode)product);
        if (srcScene != null && destScene != null) {
            srcScene.transferGeoCodingTo(destScene, null);
        }
    }

    public static Product cloneProduct(Product sourceProduct, boolean copySourceBands) {
        return IdepixIO.cloneProduct(sourceProduct, sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight(), copySourceBands);
    }

    public static Product cloneProduct(Product sourceProduct, int width, int height, boolean copySourceBands) {
        Product clonedProduct = new Product(sourceProduct.getName(), sourceProduct.getProductType(), width, height);
        ProductUtils.copyMetadata((Product)sourceProduct, (Product)clonedProduct);
        ProductUtils.copyGeoCoding((Product)sourceProduct, (Product)clonedProduct);
        ProductUtils.copyFlagCodings((Product)sourceProduct, (Product)clonedProduct);
        ProductUtils.copyFlagBands((Product)sourceProduct, (Product)clonedProduct, (boolean)true);
        ProductUtils.copyMasks((Product)sourceProduct, (Product)clonedProduct);
        clonedProduct.setStartTime(sourceProduct.getStartTime());
        clonedProduct.setEndTime(sourceProduct.getEndTime());
        if (copySourceBands) {
            for (Band b : sourceProduct.getBands()) {
                if (clonedProduct.containsBand(b.getName())) continue;
                ProductUtils.copyBand((String)b.getName(), (Product)sourceProduct, (Product)clonedProduct, (boolean)true);
                if (!IdepixIO.isIdepixSpectralBand(b)) continue;
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)b, (RasterDataNode)clonedProduct.getBand(b.getName()));
            }
            for (int i = 0; i < sourceProduct.getNumTiePointGrids(); ++i) {
                TiePointGrid srcTPG = sourceProduct.getTiePointGridAt(i);
                if (clonedProduct.containsTiePointGrid(srcTPG.getName())) continue;
                clonedProduct.addTiePointGrid(srcTPG.cloneTiePointGrid());
            }
        }
        return clonedProduct;
    }

    public static boolean isIdepixSpectralBand(Band b) {
        return b.getName().startsWith("radiance") || b.getName().startsWith("refl") || b.getName().startsWith("brr") || b.getName().startsWith("rho_toa");
    }

    public static boolean validateInputProduct(Product inputProduct, AlgorithmSelector algorithm) {
        return IdepixIO.isInputValid(inputProduct) && IdepixIO.isInputConsistentWithAlgorithm(inputProduct, algorithm);
    }

    public static boolean isInputValid(Product inputProduct) {
        if (!(IdepixIO.isValidAvhrrProduct(inputProduct) || IdepixIO.isValidLandsat8Product(inputProduct) || IdepixIO.isValidProbavProduct(inputProduct) || IdepixIO.isValidModisProduct(inputProduct) || IdepixIO.isValidSeawifsProduct(inputProduct) || IdepixIO.isValidViirsProduct(inputProduct, ViirsConstants.VIIRS_SPECTRAL_BAND_NAMES) || IdepixIO.isValidMerisProduct(inputProduct) || IdepixIO.isValidOlciProduct(inputProduct) || IdepixIO.isValidOlciSlstrSynergyProduct(inputProduct) || IdepixIO.isValidVgtProduct(inputProduct))) {
            IdepixUtils.logErrorMessage("Input sensor must be either Landsat-8, MERIS, AATSR, AVHRR, OLCI, colocated OLCI/SLSTR, MODIS/SeaWiFS, PROBA-V or VGT!");
        }
        return true;
    }

    public static boolean isValidMerisProduct(Product product) {
        boolean merisL1TypePatternMatches = EnvisatConstants.MERIS_L1_TYPE_PATTERN.matcher(product.getProductType()).matches();
        boolean merisIcolTypePatternMatches = IdepixIO.isValidMerisIcolL1NProduct(product);
        boolean merisCCL1PTypePatternMatches = IdepixIO.isValidMerisCCL1PProduct(product);
        return merisL1TypePatternMatches || merisIcolTypePatternMatches || merisCCL1PTypePatternMatches;
    }

    public static boolean isValidOlciProduct(Product product) {
        return product.getProductType().contains("OL_1");
    }

    public static boolean isValidOlciSlstrSynergyProduct(Product product) {
        return product.getName().contains("S3A_SY_1");
    }

    private static boolean isValidMerisIcolL1NProduct(Product product) {
        String icolProductType = product.getProductType();
        if (icolProductType.endsWith("_1N")) {
            int index = icolProductType.indexOf("_1");
            String merisProductType = icolProductType.substring(0, index) + "_1P";
            return EnvisatConstants.MERIS_L1_TYPE_PATTERN.matcher(merisProductType).matches();
        }
        return false;
    }

    private static boolean isValidMerisCCL1PProduct(Product product) {
        return IdepixConstants.MERIS_CCL1P_TYPE_PATTERN.matcher(product.getProductType()).matches();
    }

    public static boolean isValidAvhrrProduct(Product product) {
        return product.getProductType().equalsIgnoreCase("AVHRR") || product.getProductType().equalsIgnoreCase("NOAA_POD_AVHRR_HRPT");
    }

    public static boolean isValidLandsat8Product(Product product) {
        return product.containsBand("coastal_aerosol") && product.containsBand("blue") && product.containsBand("green") && product.containsBand("red") && product.containsBand("near_infrared") && product.containsBand("swir_1") && product.containsBand("swir_2") && product.containsBand("panchromatic") && product.containsBand("cirrus") && product.containsBand("thermal_infrared_(tirs)_1") && product.containsBand("thermal_infrared_(tirs)_2");
    }

    public static boolean isValidModisProduct(Product product) {
        return product.getName().contains("MOD021KM") || product.getName().contains("MYD021KM") || product.getName().contains("L1B_");
    }

    public static boolean isValidSeawifsProduct(Product product) {
        return product.getName().matches("S[0-9]{13}.(?i)(L1B_LAC)") || product.getName().matches("S[0-9]{13}.(?i)(L1B_MLAC)") || product.getName().matches("S[0-9]{13}.(?i)(L1B_HRPT)") || product.getName().matches("S[0-9]{13}.(?i)(L1C)");
    }

    public static boolean isValidViirsProduct(Product product, String[] expectedBandNames) {
        if (expectedBandNames != null) {
            for (String expectedBandName : expectedBandNames) {
                if (product.containsBand(expectedBandName)) continue;
                return false;
            }
        }
        return product.getName().matches("V[0-9]{13}.(?i)(L1C)") || product.getName().matches("V[0-9]{13}.(?i)(L1C.nc)") || product.getName().matches("V[0-9]{13}.(?i)(L2)") || product.getName().matches("V[0-9]{13}.(?i)(L2.nc)");
    }

    public static boolean isValidProbavProduct(Product product) {
        return product.getProductType().startsWith("PROBA-V");
    }

    public static boolean isValidVgtProduct(Product product) {
        return product.getProductType().startsWith("VGT");
    }

    private static boolean isInputConsistentWithAlgorithm(Product sourceProduct, AlgorithmSelector algorithm) {
        switch (algorithm) {
            case AVHRR: {
                return IdepixIO.isValidAvhrrProduct(sourceProduct);
            }
            case LANDSAT8: {
                return IdepixIO.isValidLandsat8Product(sourceProduct);
            }
            case MODIS: {
                return IdepixIO.isValidModisProduct(sourceProduct);
            }
            case PROBAV: {
                return IdepixIO.isValidProbavProduct(sourceProduct);
            }
            case SEAWIFS: {
                return IdepixIO.isValidSeawifsProduct(sourceProduct);
            }
            case VIIRS: {
                return IdepixIO.isValidViirsProduct(sourceProduct, ViirsConstants.VIIRS_SPECTRAL_BAND_NAMES);
            }
            case MERIS: {
                return IdepixIO.isValidMerisProduct(sourceProduct);
            }
            case OLCI: {
                return IdepixIO.isValidOlciProduct(sourceProduct);
            }
            case OLCISLSTR: {
                return IdepixIO.isValidOlciSlstrSynergyProduct(sourceProduct);
            }
            case VGT: {
                return IdepixIO.isValidVgtProduct(sourceProduct);
            }
        }
        throw new OperatorException("Algorithm " + algorithm.toString() + " not supported.");
    }

    public static boolean areAllReflectancesValid(float[] reflectance) {
        for (float aReflectance : reflectance) {
            if (!Float.isNaN(aReflectance) && !(aReflectance <= 0.0f)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllReflectancesValid(double[] reflectance) {
        for (double aReflectance : reflectance) {
            if (!Double.isNaN(aReflectance) && !(aReflectance <= 0.0)) continue;
            return false;
        }
        return true;
    }

    public static void setNewBandProperties(Band band, String description, String unit, double noDataValue, boolean useNoDataValue) {
        band.setDescription(description);
        band.setUnit(unit);
        band.setNoDataValue(noDataValue);
        band.setNoDataValueUsed(useNoDataValue);
    }

    public static void copySourceBands(Product sourceProduct, Product targetProduct, String bandNameSubstring) {
        for (String bandname : sourceProduct.getBandNames()) {
            if (!bandname.contains(bandNameSubstring) || targetProduct.containsBand(bandname)) continue;
            ProductUtils.copyBand((String)bandname, (Product)sourceProduct, (Product)targetProduct, (boolean)true);
        }
    }

    public static void addRadianceBands(Product l1bProduct, Product targetProduct, String[] bandsToCopy) {
        for (String bandname : bandsToCopy) {
            if (targetProduct.containsBand(bandname) || !bandname.contains("radiance")) continue;
            ProductUtils.copyBand((String)bandname, (Product)l1bProduct, (Product)targetProduct, (boolean)true);
        }
    }

    public static void addMerisRadiance2ReflectanceBands(Product rad2reflProduct, Product targetProduct, String[] reflBandsToCopy) {
        for (int i = 1; i <= Rad2ReflConstants.MERIS_REFL_BAND_NAMES.length; ++i) {
            for (String bandname : reflBandsToCopy) {
                if (targetProduct.containsBand(bandname) || !bandname.startsWith("reflectance") || !bandname.endsWith("_" + String.valueOf(i))) continue;
                ProductUtils.copyBand((String)bandname, (Product)rad2reflProduct, (Product)targetProduct, (boolean)true);
                targetProduct.getBand(bandname).setUnit("dl");
            }
        }
    }

    public static void addOlciRadiance2ReflectanceBands(Product rad2reflProduct, Product targetProduct, String[] reflBandsToCopy) {
        for (int i = 1; i <= Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length; ++i) {
            for (String bandname : reflBandsToCopy) {
                if (targetProduct.containsBand(bandname) || !bandname.equals("Oa" + String.format("%02d", i) + "_reflectance")) continue;
                ProductUtils.copyBand((String)bandname, (Product)rad2reflProduct, (Product)targetProduct, (boolean)true);
                targetProduct.getBand(bandname).setUnit("dl");
            }
        }
    }

    public static void addSlstrRadiance2ReflectanceBands(Product rad2reflProduct, Product targetProduct, String[] reflBandsToCopy) {
        for (int i = 1; i <= Rad2ReflConstants.SLSTR_REFL_BAND_NAMES.length; ++i) {
            for (String bandname : reflBandsToCopy) {
                if (targetProduct.containsBand(bandname) || !bandname.startsWith("S" + String.format("%01d", i) + "_reflectance")) continue;
                ProductUtils.copyBand((String)bandname, (Product)rad2reflProduct, (Product)targetProduct, (boolean)true);
                targetProduct.getBand(bandname).setUnit("dl");
            }
        }
    }

    public static void addCawaBands(Product l1bProduct, Product targetProduct) {
        for (int i = 12; i <= 15; ++i) {
            String radBandName;
            String sfBandName = "solar_flux_band_" + i;
            if (!targetProduct.containsBand(sfBandName)) {
                ProductUtils.copyBand((String)sfBandName, (Product)l1bProduct, (Product)targetProduct, (boolean)true);
                targetProduct.getBand(sfBandName).setUnit("dl");
            }
            if (targetProduct.containsBand(radBandName = Rad2ReflConstants.OLCI_RAD_BAND_NAMES[i - 1])) continue;
            ProductUtils.copyBand((String)radBandName, (Product)l1bProduct, (Product)targetProduct, (boolean)true);
            String unit = l1bProduct.getBand(radBandName).getUnit();
            targetProduct.getBand(radBandName).setUnit(unit);
        }
        if (!targetProduct.containsBand("detector_index")) {
            ProductUtils.copyBand((String)"detector_index", (Product)l1bProduct, (Product)targetProduct, (boolean)true);
            targetProduct.getBand("detector_index").setUnit("dl");
        }
        if (!targetProduct.containsBand("lambda0_band_13")) {
            ProductUtils.copyBand((String)"lambda0_band_13", (Product)l1bProduct, (Product)targetProduct, (boolean)true);
            targetProduct.getBand("lambda0_band_13").setUnit("nm");
        }
        if (!targetProduct.containsBand("latitude")) {
            ProductUtils.copyBand((String)"latitude", (Product)l1bProduct, (Product)targetProduct, (boolean)true);
            targetProduct.getBand("latitude").setUnit("deg");
        }
        if (!targetProduct.containsBand("longitude")) {
            ProductUtils.copyBand((String)"longitude", (Product)l1bProduct, (Product)targetProduct, (boolean)true);
            targetProduct.getBand("longitude").setUnit("deg");
        }
        if (!targetProduct.containsBand("altitude")) {
            ProductUtils.copyBand((String)"altitude", (Product)l1bProduct, (Product)targetProduct, (boolean)true);
            targetProduct.getBand("altitude").setUnit("m");
        }
    }
}

