/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.core.seaice;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.esa.s3tbx.idepix.core.seaice.SeaIceClassification;
import org.esa.snap.core.util.io.CsvReader;

public class SeaIceClassifier {
    private final double[][][] map = new double[180][360][4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeaIceClassifier(int month) throws IOException {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("month must be in between 1 and 12.");
        }
        InputStream classificationZipStream = this.getClass().getResourceAsStream("classification.zip");
        try (ZipInputStream zip = new ZipInputStream(classificationZipStream);){
            this.loadClassifications(month, zip);
        }
    }

    public SeaIceClassification getClassification(double lat, double lon) {
        SeaIceClassifier.validateParameters(lat, lon);
        double[] entry = this.getEntry(lat, lon);
        double mean = entry[0];
        double min = entry[1];
        double max = entry[2];
        double stdDev = entry[3];
        return SeaIceClassification.create(mean, min, max, stdDev);
    }

    double[] getEntry(double lat, double lon) {
        int lonIndex;
        int latIndex = (int)lat;
        if (latIndex == 180) {
            --latIndex;
        }
        if ((lonIndex = (int)lon) == 360) {
            --lonIndex;
        }
        return this.map[latIndex][lonIndex];
    }

    static void validateParameters(double lat, double lon) {
        if (lat > 180.0 || lat < 0.0) {
            throw new IllegalArgumentException("lat must be >= 0 and <= 180, was '" + lat + "'.");
        }
        if (lon > 360.0 || lon < 0.0) {
            throw new IllegalArgumentException("lon must be >= 0 and <= 360, was '" + lon + "'.");
        }
    }

    private void loadClassifications(int month, ZipInputStream zip) throws IOException {
        ZipEntry ze = zip.getNextEntry();
        while (ze != null) {
            String fileName = String.format("classification_%d.csv", month);
            if (ze.getName().equals(fileName)) {
                InputStreamReader reader = new InputStreamReader(zip);
                CsvReader csvReader = new CsvReader((Reader)reader, new char[]{' '}, true, "#");
                List classifications = csvReader.readStringRecords();
                for (String[] classification : classifications) {
                    int latIndex = Integer.parseInt(classification[0]);
                    int lonIndex = Integer.parseInt(classification[1]);
                    for (int i = 0; i < 4; ++i) {
                        this.map[latIndex][lonIndex][i] = Double.parseDouble(classification[2 + i]);
                    }
                }
                return;
            }
            ze = zip.getNextEntry();
        }
    }
}

