/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.viirs;

import java.io.IOException;
import java.io.InputStream;
import org.esa.s3tbx.idepix.algorithms.viirs.ViirsAlgorithm;
import org.esa.s3tbx.idepix.algorithms.viirs.ViirsConstants;
import org.esa.s3tbx.idepix.algorithms.viirs.ViirsUtils;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;

@OperatorMetadata(alias="Idepix.Viirs.Classification", version="2.2", copyright="(c) 2016 by Brockmann Consult", description="VIIRS pixel classification operator.", internal=true)
public class ViirsClassificationOp
extends PixelOperator {
    @Parameter(defaultValue="true", label=" RhoTOA bands (VIIRS)", description="Write RhoTOA bands to target product (VIIRS).")
    private boolean outputViirsRhoToa = true;
    @Parameter(defaultValue="true", label=" Debug bands", description="Write further useful bands to target product.")
    private boolean outputDebug = true;
    @Parameter(defaultValue="1", label=" Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="50", valueSet={"50", "150"}, label=" Resolution of used land-water mask in m/pixel", description="Resolution in m/pixel")
    private int waterMaskResolution;
    @SourceProduct(alias="refl", description="MODIS L1b reflectance product")
    private Product reflProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    public static final String VIIRS_NET_NAME = "6x5x4x3x2_204.8.net";
    ThreadLocal<SchillerNeuralNetWrapper> viirsNeuralNet;

    public Product getSourceProduct() {
        return this.reflProduct;
    }

    protected void prepareInputs() throws OperatorException {
        this.readSchillerNet();
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        ViirsAlgorithm algorithm = this.createViirsAlgorithm(x, y, sourceSamples, targetSamples);
        this.setClassifFlag(targetSamples, algorithm);
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        for (int i = 0; i < ViirsConstants.VIIRS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            if (this.getSourceProduct().containsBand(ViirsConstants.VIIRS_SPECTRAL_BAND_NAMES[i])) {
                sampleConfigurer.defineSample(i, ViirsConstants.VIIRS_SPECTRAL_BAND_NAMES[i], this.getSourceProduct());
                continue;
            }
            sampleConfigurer.defineSample(i, ViirsConstants.VIIRS_SPECTRAL_BAND_NAMES[i].replace(".", "_"), this.getSourceProduct());
        }
        sampleConfigurer.defineSample(ViirsConstants.VIIRS_L1B_NUM_SPECTRAL_BANDS + 1, "land_water_fraction", this.waterMaskProduct);
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "pixel_classif_flags");
        if (this.outputDebug) {
            sampleConfigurer.defineSample(1, "brightness_value");
            sampleConfigurer.defineSample(2, "ndsi_value");
        }
        sampleConfigurer.defineSample(3, "nn_value");
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        productConfigurer.copyTimeCoding();
        productConfigurer.copyTiePointGrids(new String[0]);
        Band classifFlagBand = productConfigurer.addBand("pixel_classif_flags", 11);
        classifFlagBand.setDescription("Pixel classification flag");
        classifFlagBand.setUnit("dl");
        FlagCoding flagCoding = ViirsUtils.createViirsFlagCoding("pixel_classif_flags");
        classifFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.getTargetProduct().getFlagCodingGroup().add((ProductNode)flagCoding);
        productConfigurer.copyGeoCoding();
        ViirsUtils.setupViirsClassifBitmask(this.getTargetProduct());
        if (this.outputDebug) {
            Band brightnessValueBand = productConfigurer.addBand("brightness_value", 30);
            brightnessValueBand.setDescription("Brightness value (uses EV_250_Aggr1km_RefSB_1) ");
            brightnessValueBand.setUnit("dl");
            Band ndsiValueBand = productConfigurer.addBand("ndsi_value", 30);
            ndsiValueBand.setDescription("NDSI value (uses EV_250_Aggr1km_RefSB_1, EV_500_Aggr1km_RefSB_7)");
            ndsiValueBand.setUnit("dl");
        }
        Band nnValueBand = productConfigurer.addBand("nn_value", 30);
        nnValueBand.setDescription("Schiller NN output value");
        nnValueBand.setUnit("dl");
    }

    private void readSchillerNet() {
        try (InputStream isV = ((Object)((Object)this)).getClass().getResourceAsStream(VIIRS_NET_NAME);){
            this.viirsNeuralNet = SchillerNeuralNetWrapper.create(isV);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot read Neural Nets: " + e.getMessage());
        }
    }

    private void setClassifFlag(WritableSample[] targetSamples, ViirsAlgorithm algorithm) {
        targetSamples[0].set(0, algorithm.isInvalid());
        targetSamples[0].set(1, algorithm.isCloud());
        targetSamples[0].set(2, algorithm.isCloudAmbiguous());
        targetSamples[0].set(3, algorithm.isCloudSure());
        targetSamples[0].set(4, algorithm.isCloudBuffer());
        targetSamples[0].set(5, algorithm.isCloudShadow());
        targetSamples[0].set(6, algorithm.isSnowIce());
        targetSamples[0].set(12, algorithm.isMixedPixel());
        targetSamples[0].set(10, algorithm.isLand());
        targetSamples[0].set(7, algorithm.isBright());
        if (this.outputDebug) {
            targetSamples[1].set(algorithm.brightValue());
            targetSamples[2].set(algorithm.ndsiValue());
        }
    }

    private ViirsAlgorithm createViirsAlgorithm(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        double[] reflectance = new double[ViirsConstants.VIIRS_L1B_NUM_SPECTRAL_BANDS];
        float waterFraction = Float.NaN;
        ViirsAlgorithm viirsAlgorithm = new ViirsAlgorithm();
        for (int i = 0; i < ViirsConstants.VIIRS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            reflectance[i] = sourceSamples[i].getFloat();
        }
        viirsAlgorithm.setRefl(reflectance);
        if (this.getGeoPos((int)x, (int)y).lat > -58.0) {
            waterFraction = sourceSamples[ViirsConstants.VIIRS_L1B_NUM_SPECTRAL_BANDS + 1].getFloat();
        }
        viirsAlgorithm.setWaterFraction(waterFraction);
        double[] viirsNeuralNetInput = this.viirsNeuralNet.get().getInputVector();
        for (int i = 0; i < viirsNeuralNetInput.length; ++i) {
            viirsNeuralNetInput[i] = Math.sqrt(sourceSamples[i].getFloat());
        }
        double[] neuralNetOutput = this.viirsNeuralNet.get().getNeuralNet().calc(viirsNeuralNetInput);
        viirsAlgorithm.setNnOutput(neuralNetOutput);
        int targetOffset = this.outputDebug ? 3 : 1;
        targetSamples[targetOffset].set(neuralNetOutput[0]);
        return viirsAlgorithm;
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        GeoCoding geoCoding = this.reflProduct.getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ViirsClassificationOp.class);
        }
    }
}

