/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.viirs;

public class ViirsAlgorithm {
    private static final double THRESH_BRIGHT = 0.15;
    float waterFraction;
    double[] refl;
    double[] nnOutput;

    public boolean isInvalid() {
        return false;
    }

    public boolean isCoastline() {
        return this.waterFraction < 100.0f && this.waterFraction > 0.0f;
    }

    public boolean isLand() {
        return this.waterFraction == 0.0f;
    }

    public boolean isSnowIce() {
        return this.nnOutput[0] > 4.15 && this.nnOutput[0] <= 5.0;
    }

    public boolean isCloud() {
        return this.isCloudAmbiguous() || this.isCloudSure();
    }

    public boolean isCloudAmbiguous() {
        if (this.isCloudSure() || this.isSnowIce()) {
            return false;
        }
        return this.nnOutput[0] > 2.15 && this.nnOutput[0] <= 3.7;
    }

    public boolean isCloudSure() {
        if (this.isSnowIce()) {
            return false;
        }
        return this.nnOutput[0] > 3.7 && this.nnOutput[0] <= 4.2;
    }

    public boolean isCloudBuffer() {
        return false;
    }

    public boolean isCloudShadow() {
        return false;
    }

    public boolean isMixedPixel() {
        return false;
    }

    public boolean isGlintRisk() {
        return false;
    }

    public boolean isBright() {
        return (double)this.brightValue() > 0.15;
    }

    public float brightValue() {
        return (float)this.refl[4];
    }

    public float ndsiValue() {
        return 0.5f;
    }

    public void setWaterFraction(float waterFraction) {
        this.waterFraction = waterFraction;
    }

    public void setRefl(double[] reflectance) {
        this.refl = reflectance;
    }

    public void setNnOutput(double[] nnOutput) {
        this.nnOutput = nnOutput;
    }
}

