/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.vgt;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.vgt.VgtAlgorithm;
import org.esa.s3tbx.idepix.algorithms.vgt.VgtUtils;
import org.esa.s3tbx.idepix.core.IdepixConstants;
import org.esa.s3tbx.idepix.core.pixel.AbstractPixelProperties;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.Vgt.Classification", version="1.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Idepix land pixel classification operator for VGT.")
public class VgtClassificationOp
extends Operator {
    @Parameter(defaultValue="true", label=" Write TOA reflectances to the target product", description=" Write TOA reflectances to the target product")
    boolean copyToaReflectances = true;
    @Parameter(defaultValue="false", label=" Write input annotation bands to the target product", description=" Write input annotation bands to the target product")
    boolean copyAnnotations;
    @Parameter(defaultValue="false", label=" Write feature values to the target product", description=" Write all feature values to the target product")
    boolean copyFeatureValues = false;
    @Parameter(defaultValue="false", label=" Write NN value to the target product.", description=" If applied, write NN value to the target product ")
    private boolean outputSchillerNNValue;
    @Parameter(defaultValue="false", label=" Use land-water flag from L1b product instead", description="Use land-water flag from L1b product instead of SRTM mask")
    private boolean useL1bLandWaterFlag;
    @Parameter(defaultValue="1.1", label=" NN cloud ambiguous lower boundary", description=" NN cloud ambiguous lower boundary")
    private double nnCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="2.7", label=" NN cloud ambiguous/sure separation value", description=" NN cloud ambiguous cloud ambiguous/sure separation value")
    private double nnCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.6", label=" NN cloud sure/snow separation value", description=" NN cloud ambiguous cloud sure/snow separation value")
    private double nnCloudSureSnowSeparationValue;
    private Band[] vgtReflectanceBands;
    Band cloudFlagBand;
    Band temperatureBand;
    Band brightBand;
    Band whiteBand;
    Band brightWhiteBand;
    Band spectralFlatnessBand;
    Band ndviBand;
    Band ndsiBand;
    Band glintRiskBand;
    Band radioLandBand;
    Band radioWaterBand;
    public static final int SM_F_CLOUD_1 = 0;
    public static final int SM_F_CLOUD_2 = 1;
    public static final int SM_F_LAND = 3;
    public static final int SM_F_MIR_GOOD = 4;
    public static final int SM_F_B3_GOOD = 5;
    public static final int SM_F_B2_GOOD = 6;
    public static final int SM_F_B0_GOOD = 7;
    @SourceProduct(alias="l1b", description="The source product.")
    Product sourceProduct;
    @TargetProduct(description="The target product.")
    Product targetProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    public static final String VGT_NET_NAME = "3x2x2_341.8.net";
    ThreadLocal<SchillerNeuralNetWrapper> vgtNeuralNet;
    private Band landWaterBand;
    static final byte WATERMASK_FRACTION_THRESH = 23;

    public void initialize() throws OperatorException {
        this.setBands();
        this.landWaterBand = this.waterMaskProduct.getBand("land_water_fraction");
        this.readSchillerNeuralNets();
        this.createTargetProduct();
        this.extendTargetProduct();
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        Band smFlagBand = this.sourceProduct.getBand("SM");
        Tile smFlagTile = this.getSourceTile((RasterDataNode)smFlagBand, rectangle);
        Tile waterFractionTile = this.getSourceTile((RasterDataNode)this.landWaterBand, rectangle);
        Tile[] vgtReflectanceTiles = new Tile[IdepixConstants.VGT_REFLECTANCE_BAND_NAMES.length];
        float[] vgtReflectance = new float[IdepixConstants.VGT_REFLECTANCE_BAND_NAMES.length];
        for (int i = 0; i < IdepixConstants.VGT_REFLECTANCE_BAND_NAMES.length; ++i) {
            vgtReflectanceTiles[i] = this.getSourceTile((RasterDataNode)this.vgtReflectanceBands[i], rectangle);
        }
        Band cloudFlagTargetBand = this.targetProduct.getBand("pixel_classif_flags");
        Tile cloudFlagTargetTile = targetTiles.get(cloudFlagTargetBand);
        Tile nnTargetTile = null;
        if (this.outputSchillerNNValue) {
            Band nnTargetBand = this.targetProduct.getBand("vgt_nn_value");
            nnTargetTile = targetTiles.get(nnTargetBand);
        }
        try {
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                this.checkForCancellation();
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    byte waterMaskFraction = 127;
                    if (!this.useL1bLandWaterFlag) {
                        waterMaskFraction = (byte)waterFractionTile.getSampleInt(x, y);
                    }
                    VgtAlgorithm vgtAlgorithm = this.createVgtAlgorithm(smFlagTile, vgtReflectanceTiles, vgtReflectance, waterMaskFraction, y, x);
                    this.setCloudFlag(cloudFlagTargetTile, y, x, vgtAlgorithm);
                    double[] nnOutput = vgtAlgorithm.getNnOutput();
                    if (!cloudFlagTargetTile.getSampleBit(x, y, 0)) {
                        cloudFlagTargetTile.setSample(x, y, 2, false);
                        cloudFlagTargetTile.setSample(x, y, 3, false);
                        cloudFlagTargetTile.setSample(x, y, 1, false);
                        cloudFlagTargetTile.setSample(x, y, 6, false);
                        if (nnOutput[0] > this.nnCloudAmbiguousLowerBoundaryValue && nnOutput[0] <= this.nnCloudAmbiguousSureSeparationValue) {
                            cloudFlagTargetTile.setSample(x, y, 2, true);
                            cloudFlagTargetTile.setSample(x, y, 1, true);
                        }
                        if (nnOutput[0] > this.nnCloudAmbiguousSureSeparationValue && nnOutput[0] <= this.nnCloudSureSnowSeparationValue) {
                            cloudFlagTargetTile.setSample(x, y, 3, true);
                            cloudFlagTargetTile.setSample(x, y, 1, true);
                        }
                        if (nnOutput[0] > this.nnCloudSureSnowSeparationValue) {
                            cloudFlagTargetTile.setSample(x, y, 6, true);
                        }
                    }
                    if (this.outputSchillerNNValue && nnTargetTile != null) {
                        nnTargetTile.setSample(x, y, nnOutput[0]);
                    }
                    for (Band band : this.targetProduct.getBands()) {
                        Tile targetTile = targetTiles.get(band);
                        this.setPixelSamples(band, targetTile, y, x, vgtAlgorithm);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException("Failed to provide GA cloud screening:\n" + e.getMessage(), (Throwable)e);
        }
    }

    void createTargetProduct() throws OperatorException {
        int sceneWidth = this.sourceProduct.getSceneRasterWidth();
        int sceneHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), sceneWidth, sceneHeight);
        this.cloudFlagBand = this.targetProduct.addBand("pixel_classif_flags", 12);
        FlagCoding flagCoding = VgtUtils.createVgtFlagCoding("pixel_classif_flags");
        this.cloudFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.copyFeatureValues) {
            this.brightBand = this.targetProduct.addBand("bright_value", 30);
            IdepixIO.setNewBandProperties(this.brightBand, "Brightness", "dl", -1.0, true);
            this.whiteBand = this.targetProduct.addBand("white_value", 30);
            IdepixIO.setNewBandProperties(this.whiteBand, "Whiteness", "dl", -1.0, true);
            this.brightWhiteBand = this.targetProduct.addBand("bright_white_value", 30);
            IdepixIO.setNewBandProperties(this.brightWhiteBand, "Brightwhiteness", "dl", -1.0, true);
            this.temperatureBand = this.targetProduct.addBand("temperature_value", 30);
            IdepixIO.setNewBandProperties(this.temperatureBand, "Temperature", "K", -1.0, true);
            this.spectralFlatnessBand = this.targetProduct.addBand("spectral_flatness_value", 30);
            IdepixIO.setNewBandProperties(this.spectralFlatnessBand, "Spectral Flatness", "dl", -1.0, true);
            this.ndviBand = this.targetProduct.addBand("ndvi_value", 30);
            IdepixIO.setNewBandProperties(this.ndviBand, "NDVI", "dl", -1.0, true);
            this.ndsiBand = this.targetProduct.addBand("ndsi_value", 30);
            IdepixIO.setNewBandProperties(this.ndsiBand, "NDSI", "dl", -1.0, true);
            this.glintRiskBand = this.targetProduct.addBand("glint_risk_value", 30);
            IdepixIO.setNewBandProperties(this.glintRiskBand, "GLINT_RISK", "dl", -1.0, true);
            this.radioLandBand = this.targetProduct.addBand("radiometric_land_value", 30);
            IdepixIO.setNewBandProperties(this.radioLandBand, "Radiometric Land Value", "", -1.0, true);
            this.radioWaterBand = this.targetProduct.addBand("radiometric_water_value", 30);
            IdepixIO.setNewBandProperties(this.radioWaterBand, "Radiometric Water Value", "", -1.0, true);
        }
    }

    private void readSchillerNeuralNets() {
        try (InputStream vgtLandIS = ((Object)((Object)this)).getClass().getResourceAsStream(VGT_NET_NAME);){
            this.vgtNeuralNet = SchillerNeuralNetWrapper.create(vgtLandIS);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot read Neural Nets: " + e.getMessage());
        }
    }

    public void setBands() {
        this.vgtReflectanceBands = new Band[IdepixConstants.VGT_REFLECTANCE_BAND_NAMES.length];
        for (int i = 0; i < IdepixConstants.VGT_REFLECTANCE_BAND_NAMES.length; ++i) {
            this.vgtReflectanceBands[i] = this.sourceProduct.getBand(IdepixConstants.VGT_REFLECTANCE_BAND_NAMES[i]);
        }
    }

    void setCloudFlag(Tile targetTile, int y, int x, VgtAlgorithm vgtAlgorithm) {
        targetTile.setSample(x, y, 0, vgtAlgorithm.isInvalid());
        targetTile.setSample(x, y, 1, vgtAlgorithm.isCloud());
        targetTile.setSample(x, y, 3, vgtAlgorithm.isCloud());
        targetTile.setSample(x, y, 5, false);
        targetTile.setSample(x, y, 13, vgtAlgorithm.isClearLand());
        targetTile.setSample(x, y, 14, vgtAlgorithm.isClearWater());
        targetTile.setSample(x, y, 9, vgtAlgorithm.isCoastline());
        targetTile.setSample(x, y, 6, vgtAlgorithm.isClearSnow());
        targetTile.setSample(x, y, 10, vgtAlgorithm.isLand());
        targetTile.setSample(x, y, 12, vgtAlgorithm.isWater());
        targetTile.setSample(x, y, 7, vgtAlgorithm.isBright());
        targetTile.setSample(x, y, 8, vgtAlgorithm.isWhite());
    }

    void setPixelSamples(Band band, Tile targetTile, int y, int x, VgtAlgorithm vgtAlgorithm) {
        if (band == this.brightBand) {
            targetTile.setSample(x, y, vgtAlgorithm.brightValue());
        } else if (band == this.whiteBand) {
            targetTile.setSample(x, y, vgtAlgorithm.whiteValue());
        } else if (band == this.brightWhiteBand) {
            targetTile.setSample(x, y, vgtAlgorithm.brightValue() + vgtAlgorithm.whiteValue());
        } else if (band == this.temperatureBand) {
            targetTile.setSample(x, y, vgtAlgorithm.temperatureValue());
        } else if (band == this.spectralFlatnessBand) {
            targetTile.setSample(x, y, vgtAlgorithm.spectralFlatnessValue());
        } else if (band == this.ndviBand) {
            targetTile.setSample(x, y, vgtAlgorithm.ndviValue());
        } else if (band == this.ndsiBand) {
            targetTile.setSample(x, y, vgtAlgorithm.ndsiValue());
        } else if (band == this.glintRiskBand) {
            targetTile.setSample(x, y, vgtAlgorithm.glintRiskValue());
        } else if (band == this.radioLandBand) {
            targetTile.setSample(x, y, vgtAlgorithm.radiometricLandValue());
        } else if (band == this.radioWaterBand) {
            targetTile.setSample(x, y, vgtAlgorithm.radiometricWaterValue());
        }
    }

    public void extendTargetProduct() throws OperatorException {
        if (this.copyToaReflectances) {
            this.copyVgtReflectances();
            ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
        if (this.copyAnnotations) {
            this.copyVgtAnnotations();
        }
        if (this.outputSchillerNNValue) {
            this.targetProduct.addBand("vgt_nn_value", 30);
        }
    }

    private void copyVgtAnnotations() {
        for (String bandName : IdepixConstants.VGT_ANNOTATION_BAND_NAMES) {
            ProductUtils.copyBand((String)bandName, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
    }

    private void copyVgtReflectances() {
        for (int i = 0; i < IdepixConstants.VGT_REFLECTANCE_BAND_NAMES.length; ++i) {
            ProductUtils.copyBand((String)IdepixConstants.VGT_REFLECTANCE_BAND_NAMES[i], (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
    }

    private VgtAlgorithm createVgtAlgorithm(Tile smFlagTile, Tile[] vgtReflectanceTiles, float[] vgtReflectance, byte watermaskFraction, int y, int x) {
        boolean isLand;
        VgtAlgorithm vgtAlgorithm = new VgtAlgorithm();
        for (int i = 0; i < IdepixConstants.VGT_REFLECTANCE_BAND_NAMES.length; ++i) {
            vgtReflectance[i] = vgtReflectanceTiles[i].getSampleFloat(x, y);
        }
        this.checkVgtReflectanceQuality(vgtReflectance, smFlagTile, x, y);
        float[] vgtReflectanceSaturationCorrected = IdepixUtils.correctSaturatedReflectances(vgtReflectance);
        vgtAlgorithm.setRefl(vgtReflectanceSaturationCorrected);
        SchillerNeuralNetWrapper nnWrapper = this.vgtNeuralNet.get();
        double[] inputVector = nnWrapper.getInputVector();
        for (int i = 0; i < inputVector.length; ++i) {
            inputVector[i] = Math.sqrt(vgtReflectanceSaturationCorrected[i]);
        }
        vgtAlgorithm.setNnOutput(nnWrapper.getNeuralNet().calc(inputVector));
        if (this.useL1bLandWaterFlag) {
            isLand = smFlagTile.getSampleBit(x, y, 3);
            vgtAlgorithm.setSmLand(isLand);
            vgtAlgorithm.setIsWater(!isLand);
            vgtAlgorithm.setIsCoastline(false);
        } else {
            isLand = smFlagTile.getSampleBit(x, y, 3) && watermaskFraction < 23;
            vgtAlgorithm.setSmLand(isLand);
            this.setIsWaterByFraction(watermaskFraction, vgtAlgorithm);
            boolean isCoastline = this.isCoastlinePixel(x, y, watermaskFraction);
            vgtAlgorithm.setIsCoastline(isCoastline);
        }
        return vgtAlgorithm;
    }

    void setIsWaterByFraction(byte watermaskFraction, AbstractPixelProperties pixelProperties) {
        boolean isWater = watermaskFraction == 127 ? pixelProperties.isL1Water() : watermaskFraction >= 23;
        pixelProperties.setIsWater(isWater);
    }

    private boolean isCoastlinePixel(int x, int y, int waterFraction) {
        return this.getGeoPos((int)x, (int)y).lat > -58.0 && waterFraction <= 100 && waterFraction < 100 && waterFraction > 0;
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        GeoCoding geoCoding = this.getSourceProduct().getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    private void checkVgtReflectanceQuality(float[] vgtReflectance, Tile smFlagTile, int x, int y) {
        boolean isMirGood;
        boolean isB0Good = smFlagTile.getSampleBit(x, y, 7);
        boolean isB2Good = smFlagTile.getSampleBit(x, y, 6);
        boolean isB3Good = smFlagTile.getSampleBit(x, y, 5);
        boolean bl = isMirGood = smFlagTile.getSampleBit(x, y, 4) || (double)vgtReflectance[3] <= 0.65;
        if (!(isB0Good && isB2Good && isB3Good && isMirGood)) {
            for (int i = 0; i < vgtReflectance.length; ++i) {
                vgtReflectance[i] = Float.NaN;
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(VgtClassificationOp.class);
        }
    }
}

