/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.vgt;

import org.esa.s3tbx.idepix.core.IdepixConstants;
import org.esa.s3tbx.idepix.core.pixel.AbstractPixelProperties;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.math.MathUtils;

public class VgtAlgorithm
extends AbstractPixelProperties {
    static final float LAND_THRESH = 0.9f;
    static final float WATER_THRESH = 0.9f;
    float[] refl;
    private static final float BRIGHTWHITE_THRESH = 0.65f;
    private static final float NDSI_THRESH = 0.5f;
    private static final float PRESSURE_THRESH = 0.9f;
    private static final float CLOUD_THRESH = 1.65f;
    private static final float UNCERTAINTY_VALUE = 0.5f;
    private static final float BRIGHT_THRESH = 0.3f;
    private static final float WHITE_THRESH = 0.5f;
    private static final float BRIGHT_FOR_WHITE_THRESH = 0.2f;
    private static final float NDVI_THRESH = 0.4f;
    private static final float REFL835_WATER_THRESH = 0.1f;
    private static final float REFL835_LAND_THRESH = 0.15f;
    private boolean smLand;
    private double[] nnOutput;
    public boolean isWater;
    public boolean usel1bLandWaterFlag;
    private boolean isCoastline;

    @Override
    public boolean isInvalid() {
        return !IdepixIO.areAllReflectancesValid(this.refl);
    }

    @Override
    public boolean isClearSnow() {
        return !this.isInvalid() && this.isLand() && this.isBrightWhite() && this.ndsiValue() > this.getNdsiThreshold();
    }

    @Override
    public boolean isClearLand() {
        float landValue;
        if (this.isInvalid()) {
            return false;
        }
        if (!MathUtils.equalValues((float)this.radiometricLandValue(), (float)0.5f)) {
            landValue = this.radiometricLandValue();
        } else if (this.aPrioriLandValue() > 0.5f) {
            landValue = this.aPrioriLandValue();
        } else {
            return false;
        }
        return !this.isWater && !this.isCloud() && landValue > 0.9f;
    }

    @Override
    public boolean isClearWater() {
        float waterValue;
        if (this.isInvalid()) {
            return false;
        }
        if (!MathUtils.equalValues((float)this.radiometricWaterValue(), (float)0.5f)) {
            waterValue = this.radiometricWaterValue();
        } else if (this.aPrioriWaterValue() > 0.5f) {
            waterValue = this.aPrioriWaterValue();
        } else {
            return false;
        }
        return this.isWater && !this.isCloud() && waterValue > 0.9f;
    }

    @Override
    public boolean isCloud() {
        return !this.isInvalid() && this.whiteValue() + this.brightValue() + this.pressureValue() + this.temperatureValue() > 1.65f && !this.isClearSnow();
    }

    @Override
    public boolean isLand() {
        boolean isLand1 = !this.usel1bLandWaterFlag && !this.isWater;
        return !this.isInvalid() && (isLand1 || this.aPrioriLandValue() > 0.9f);
    }

    @Override
    public boolean isWater() {
        return !this.isInvalid() && this.isWater;
    }

    @Override
    public boolean isL1Water() {
        return false;
    }

    @Override
    public boolean isBrightWhite() {
        return !this.isInvalid() && this.whiteValue() + this.brightValue() > this.getBrightWhiteThreshold();
    }

    @Override
    public boolean isBright() {
        return !this.isInvalid() && this.brightValue() > this.getBrightThreshold();
    }

    @Override
    public boolean isWhite() {
        return !this.isInvalid() && this.whiteValue() > this.getWhiteThreshold();
    }

    @Override
    public boolean isVegRisk() {
        return !this.isInvalid() && this.ndviValue() > this.getNdviThreshold();
    }

    @Override
    public boolean isHigh() {
        return !this.isInvalid() && this.pressureValue() > this.getPressureThreshold();
    }

    @Override
    public boolean isSeaIce() {
        return false;
    }

    @Override
    public boolean isGlintRisk() {
        return false;
    }

    public float brightValue() {
        double value = (this.refl[0] + this.refl[1]) / 2.0f;
        value = Math.min(value, 1.0);
        value = Math.max(value, 0.0);
        return (float)value;
    }

    public float temperatureValue() {
        return 0.5f;
    }

    public float spectralFlatnessValue() {
        double slope0 = IdepixUtils.spectralSlope(this.refl[0], this.refl[1], IdepixConstants.VGT_WAVELENGTHS[0], IdepixConstants.VGT_WAVELENGTHS[1]);
        double slope1 = IdepixUtils.spectralSlope(this.refl[1], this.refl[2], IdepixConstants.VGT_WAVELENGTHS[1], IdepixConstants.VGT_WAVELENGTHS[2]);
        double flatness = 1.0 - Math.abs(2000.0 * (slope0 + slope1) / 2.0);
        return (float)Math.max(0.0, flatness);
    }

    public float whiteValue() {
        if (this.brightValue() > 0.2f) {
            return this.spectralFlatnessValue();
        }
        return 0.0f;
    }

    public float ndsiValue() {
        double value = (this.refl[2] - this.refl[3]) / (this.refl[2] + this.refl[3]);
        value = Math.min(value, 1.0);
        value = Math.max(value, 0.0);
        return (float)value;
    }

    public float ndviValue() {
        double value = (this.refl[2] - this.refl[1]) / (this.refl[2] + this.refl[1]);
        value = Math.min(value, 1.0);
        value = Math.max(value, 0.0);
        return (float)value;
    }

    public float pressureValue() {
        return 0.5f;
    }

    public float glintRiskValue() {
        return IdepixUtils.spectralSlope(this.refl[0], this.refl[1], IdepixConstants.VGT_WAVELENGTHS[0], IdepixConstants.VGT_WAVELENGTHS[1]);
    }

    public float aPrioriLandValue() {
        if (this.isInvalid()) {
            return 0.5f;
        }
        if (this.smLand) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float aPrioriWaterValue() {
        if (this.isInvalid()) {
            return 0.5f;
        }
        if (!this.smLand) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float radiometricLandValue() {
        if (this.isInvalid() || this.isCloud()) {
            return 0.5f;
        }
        if (this.refl[2] > this.refl[1] && this.refl[2] > 0.15f) {
            return 1.0f;
        }
        if (this.refl[2] > 0.15f) {
            return 0.75f;
        }
        return 0.25f;
    }

    public float radiometricWaterValue() {
        if (this.isInvalid() || this.isCloud()) {
            return 0.5f;
        }
        if (this.refl[0] > this.refl[1] && this.refl[1] > this.refl[2] && this.refl[2] < 0.1f) {
            return 1.0f;
        }
        return 0.25f;
    }

    public float getBrightWhiteThreshold() {
        return 0.65f;
    }

    public float getNdsiThreshold() {
        return 0.5f;
    }

    public float getNdviThreshold() {
        return 0.4f;
    }

    public float getBrightThreshold() {
        return 0.3f;
    }

    public float getWhiteThreshold() {
        return 0.5f;
    }

    public float getPressureThreshold() {
        return 0.9f;
    }

    public void setSmLand(boolean smLand) {
        this.smLand = smLand;
    }

    public void setIsCoastline(boolean isCoastline) {
        this.isCoastline = isCoastline;
    }

    @Override
    public void setIsWater(boolean isWater) {
        this.isWater = !this.isInvalid() && isWater;
    }

    public void setRefl(float[] refl) {
        if (refl.length != IdepixConstants.VGT_WAVELENGTHS.length) {
            throw new OperatorException("VGT pixel processing: Invalid number of wavelengths [" + refl.length + "] - must be " + IdepixConstants.VGT_WAVELENGTHS.length);
        }
        this.refl = refl;
    }

    public void setNnOutput(double[] nnOutput) {
        this.nnOutput = nnOutput;
    }

    public double[] getNnOutput() {
        return this.nnOutput;
    }

    public boolean isCoastline() {
        return this.isCoastline;
    }
}

