/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.seawifs;

public class SeaWifsAlgorithm {
    private static final double THRESH_BRIGHT_CLOUD_AMBIGUOUS = 0.07;
    private static final double THRESH_BRIGHT_CLOUD_SURE = 0.15;
    float waterFraction;
    double[] refl;
    double[] nnOutput;

    public boolean isInvalid() {
        return false;
    }

    public boolean isCoastline() {
        return this.waterFraction < 100.0f && this.waterFraction > 0.0f;
    }

    public boolean isLand() {
        return this.waterFraction == 0.0f;
    }

    public boolean isSnowIce() {
        return false;
    }

    public boolean isCloud() {
        return this.isCloudAmbiguous() || this.isCloudSure();
    }

    public boolean isCloudAmbiguous() {
        if (this.isLand() || this.isCloudSure()) {
            return false;
        }
        if (this.nnOutput != null) {
            return this.nnOutput[0] >= 0.48 && this.nnOutput[0] < 0.48;
        }
        return (double)this.brightValue() > 0.07;
    }

    public boolean isCloudSure() {
        if (this.isLand() || this.isSnowIce()) {
            return false;
        }
        if (this.nnOutput != null) {
            return this.nnOutput[0] >= 0.0 && this.nnOutput[0] < 0.48;
        }
        return (double)this.brightValue() > 0.15;
    }

    public boolean isCloudBuffer() {
        return false;
    }

    public boolean isCloudShadow() {
        return false;
    }

    public boolean isMixedPixel() {
        return false;
    }

    public boolean isGlintRisk() {
        return false;
    }

    public boolean isBright() {
        return false;
    }

    public float brightValue() {
        return (float)this.refl[7];
    }

    public float whiteValue(int numeratorIndex, int denominatorIndex) {
        return 0.0f;
    }

    public float ndsiValue() {
        return 0.0f;
    }

    public void setWaterFraction(float waterFraction) {
        this.waterFraction = waterFraction;
    }

    public void setRefl(double[] reflectance) {
        this.refl = reflectance;
    }

    public void setNnOutput(double[] nnOutput) {
        this.nnOutput = nnOutput;
    }
}

